/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements. See the NOTICE file distributed with this
work for additional information regarding copyright ownership. The ASF
licenses this file to You under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
License for the specific language governing permissions and limitations
under the License.
*/

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.0
// 	protoc        v3.21.1
// source: master.proto

package __

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type LoadStep int32

const (
	LoadStep_Vertex        LoadStep = 0
	LoadStep_ScatterVertex LoadStep = 1
	LoadStep_Edge          LoadStep = 2
	LoadStep_OutDegree     LoadStep = 3
	LoadStep_Complete      LoadStep = 4
	LoadStep_Error         LoadStep = 5
)

// Enum value maps for LoadStep.
var (
	LoadStep_name = map[int32]string{
		0: "Vertex",
		1: "ScatterVertex",
		2: "Edge",
		3: "OutDegree",
		4: "Complete",
		5: "Error",
	}
	LoadStep_value = map[string]int32{
		"Vertex":        0,
		"ScatterVertex": 1,
		"Edge":          2,
		"OutDegree":     3,
		"Complete":      4,
		"Error":         5,
	}
)

func (x LoadStep) Enum() *LoadStep {
	p := new(LoadStep)
	*p = x
	return p
}

func (x LoadStep) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoadStep) Descriptor() protoreflect.EnumDescriptor {
	return file_master_proto_enumTypes[0].Descriptor()
}

func (LoadStep) Type() protoreflect.EnumType {
	return &file_master_proto_enumTypes[0]
}

func (x LoadStep) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoadStep.Descriptor instead.
func (LoadStep) EnumDescriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{0}
}

type ComputeAction int32

const (
	ComputeAction_Compute          ComputeAction = 0
	ComputeAction_SettingOutEdges  ComputeAction = 1
	ComputeAction_SettingOutDegree ComputeAction = 2
)

// Enum value maps for ComputeAction.
var (
	ComputeAction_name = map[int32]string{
		0: "Compute",
		1: "SettingOutEdges",
		2: "SettingOutDegree",
	}
	ComputeAction_value = map[string]int32{
		"Compute":          0,
		"SettingOutEdges":  1,
		"SettingOutDegree": 2,
	}
)

func (x ComputeAction) Enum() *ComputeAction {
	p := new(ComputeAction)
	*p = x
	return p
}

func (x ComputeAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ComputeAction) Descriptor() protoreflect.EnumDescriptor {
	return file_master_proto_enumTypes[1].Descriptor()
}

func (ComputeAction) Type() protoreflect.EnumType {
	return &file_master_proto_enumTypes[1]
}

func (x ComputeAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ComputeAction.Descriptor instead.
func (ComputeAction) EnumDescriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{1}
}

type HelloMasterReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base        *BaseRequest `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
	WorkerPeer  string       `protobuf:"bytes,2,opt,name=WorkerPeer,proto3" json:"WorkerPeer,omitempty"`
	Version     string       `protobuf:"bytes,3,opt,name=Version,proto3" json:"Version,omitempty"`
	WorkerGroup string       `protobuf:"bytes,4,opt,name=WorkerGroup,proto3" json:"WorkerGroup,omitempty"`
}

func (x *HelloMasterReq) Reset() {
	*x = HelloMasterReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HelloMasterReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HelloMasterReq) ProtoMessage() {}

func (x *HelloMasterReq) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HelloMasterReq.ProtoReflect.Descriptor instead.
func (*HelloMasterReq) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{0}
}

func (x *HelloMasterReq) GetBase() *BaseRequest {
	if x != nil {
		return x.Base
	}
	return nil
}

func (x *HelloMasterReq) GetWorkerPeer() string {
	if x != nil {
		return x.WorkerPeer
	}
	return ""
}

func (x *HelloMasterReq) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *HelloMasterReq) GetWorkerGroup() string {
	if x != nil {
		return x.WorkerGroup
	}
	return ""
}

type HelloMasterResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base       *BaseResponse `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
	WorkerId   int32         `protobuf:"varint,2,opt,name=WorkerId,proto3" json:"WorkerId,omitempty"`
	WorkerName string        `protobuf:"bytes,3,opt,name=WorkerName,proto3" json:"WorkerName,omitempty"`
	Workers    []*WorkerInfo `protobuf:"bytes,4,rep,name=Workers,proto3" json:"Workers,omitempty"`
	Spaces     []string      `protobuf:"bytes,5,rep,name=Spaces,proto3" json:"Spaces,omitempty"`
}

func (x *HelloMasterResp) Reset() {
	*x = HelloMasterResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HelloMasterResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HelloMasterResp) ProtoMessage() {}

func (x *HelloMasterResp) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HelloMasterResp.ProtoReflect.Descriptor instead.
func (*HelloMasterResp) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{1}
}

func (x *HelloMasterResp) GetBase() *BaseResponse {
	if x != nil {
		return x.Base
	}
	return nil
}

func (x *HelloMasterResp) GetWorkerId() int32 {
	if x != nil {
		return x.WorkerId
	}
	return 0
}

func (x *HelloMasterResp) GetWorkerName() string {
	if x != nil {
		return x.WorkerName
	}
	return ""
}

func (x *HelloMasterResp) GetWorkers() []*WorkerInfo {
	if x != nil {
		return x.Workers
	}
	return nil
}

func (x *HelloMasterResp) GetSpaces() []string {
	if x != nil {
		return x.Spaces
	}
	return nil
}

type WorkerInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name     string `protobuf:"bytes,1,opt,name=Name,proto3" json:"Name,omitempty"`
	Id       int32  `protobuf:"varint,2,opt,name=Id,proto3" json:"Id,omitempty"`
	GrpcPeer string `protobuf:"bytes,3,opt,name=GrpcPeer,proto3" json:"GrpcPeer,omitempty"`
}

func (x *WorkerInfo) Reset() {
	*x = WorkerInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkerInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerInfo) ProtoMessage() {}

func (x *WorkerInfo) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerInfo.ProtoReflect.Descriptor instead.
func (*WorkerInfo) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{2}
}

func (x *WorkerInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *WorkerInfo) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *WorkerInfo) GetGrpcPeer() string {
	if x != nil {
		return x.GrpcPeer
	}
	return ""
}

type LoadGraphTaskReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base       *BaseRequest `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
	WorkerName string       `protobuf:"bytes,2,opt,name=WorkerName,proto3" json:"WorkerName,omitempty"`
	TaskId     int32        `protobuf:"varint,4,opt,name=TaskId,proto3" json:"TaskId,omitempty"`
	State      string       `protobuf:"bytes,5,opt,name=State,proto3" json:"State,omitempty"`
	PartId     int32        `protobuf:"varint,6,opt,name=PartId,proto3" json:"PartId,omitempty"`
}

func (x *LoadGraphTaskReq) Reset() {
	*x = LoadGraphTaskReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoadGraphTaskReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadGraphTaskReq) ProtoMessage() {}

func (x *LoadGraphTaskReq) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadGraphTaskReq.ProtoReflect.Descriptor instead.
func (*LoadGraphTaskReq) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{3}
}

func (x *LoadGraphTaskReq) GetBase() *BaseRequest {
	if x != nil {
		return x.Base
	}
	return nil
}

func (x *LoadGraphTaskReq) GetWorkerName() string {
	if x != nil {
		return x.WorkerName
	}
	return ""
}

func (x *LoadGraphTaskReq) GetTaskId() int32 {
	if x != nil {
		return x.TaskId
	}
	return 0
}

func (x *LoadGraphTaskReq) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

func (x *LoadGraphTaskReq) GetPartId() int32 {
	if x != nil {
		return x.PartId
	}
	return 0
}

type LoadGraphTaskResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base      *BaseResponse     `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
	LoadType  string            `protobuf:"bytes,2,opt,name=LoadType,proto3" json:"LoadType,omitempty"`
	Parallel  int32             `protobuf:"varint,3,opt,name=Parallel,proto3" json:"Parallel,omitempty"`
	TaskId    int32             `protobuf:"varint,4,opt,name=TaskId,proto3" json:"TaskId,omitempty"`
	SpaceName string            `protobuf:"bytes,5,opt,name=SpaceName,proto3" json:"SpaceName,omitempty"`
	GraphName string            `protobuf:"bytes,6,opt,name=GraphName,proto3" json:"GraphName,omitempty"`
	Workers   []string          `protobuf:"bytes,7,rep,name=Workers,proto3" json:"Workers,omitempty"`
	Step      LoadStep          `protobuf:"varint,8,opt,name=Step,proto3,enum=master.LoadStep" json:"Step,omitempty"`
	Params    map[string]string `protobuf:"bytes,10,rep,name=Params,proto3" json:"Params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *LoadGraphTaskResp) Reset() {
	*x = LoadGraphTaskResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoadGraphTaskResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadGraphTaskResp) ProtoMessage() {}

func (x *LoadGraphTaskResp) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadGraphTaskResp.ProtoReflect.Descriptor instead.
func (*LoadGraphTaskResp) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{4}
}

func (x *LoadGraphTaskResp) GetBase() *BaseResponse {
	if x != nil {
		return x.Base
	}
	return nil
}

func (x *LoadGraphTaskResp) GetLoadType() string {
	if x != nil {
		return x.LoadType
	}
	return ""
}

func (x *LoadGraphTaskResp) GetParallel() int32 {
	if x != nil {
		return x.Parallel
	}
	return 0
}

func (x *LoadGraphTaskResp) GetTaskId() int32 {
	if x != nil {
		return x.TaskId
	}
	return 0
}

func (x *LoadGraphTaskResp) GetSpaceName() string {
	if x != nil {
		return x.SpaceName
	}
	return ""
}

func (x *LoadGraphTaskResp) GetGraphName() string {
	if x != nil {
		return x.GraphName
	}
	return ""
}

func (x *LoadGraphTaskResp) GetWorkers() []string {
	if x != nil {
		return x.Workers
	}
	return nil
}

func (x *LoadGraphTaskResp) GetStep() LoadStep {
	if x != nil {
		return x.Step
	}
	return LoadStep_Vertex
}

func (x *LoadGraphTaskResp) GetParams() map[string]string {
	if x != nil {
		return x.Params
	}
	return nil
}

type FetchLoadPartReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base       *BaseRequest `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
	WorkerName string       `protobuf:"bytes,2,opt,name=WorkerName,proto3" json:"WorkerName,omitempty"`
	TaskId     int32        `protobuf:"varint,4,opt,name=TaskId,proto3" json:"TaskId,omitempty"`
}

func (x *FetchLoadPartReq) Reset() {
	*x = FetchLoadPartReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchLoadPartReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchLoadPartReq) ProtoMessage() {}

func (x *FetchLoadPartReq) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchLoadPartReq.ProtoReflect.Descriptor instead.
func (*FetchLoadPartReq) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{5}
}

func (x *FetchLoadPartReq) GetBase() *BaseRequest {
	if x != nil {
		return x.Base
	}
	return nil
}

func (x *FetchLoadPartReq) GetWorkerName() string {
	if x != nil {
		return x.WorkerName
	}
	return ""
}

func (x *FetchLoadPartReq) GetTaskId() int32 {
	if x != nil {
		return x.TaskId
	}
	return 0
}

type FetchLoadPartResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base     *BaseResponse     `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
	TaskId   int32             `protobuf:"varint,2,opt,name=TaskId,proto3" json:"TaskId,omitempty"`
	PartId   int32             `protobuf:"varint,3,opt,name=PartId,proto3" json:"PartId,omitempty"`
	LoadType string            `protobuf:"bytes,4,opt,name=loadType,proto3" json:"loadType,omitempty"`
	Params   map[string]string `protobuf:"bytes,10,rep,name=Params,proto3" json:"Params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *FetchLoadPartResp) Reset() {
	*x = FetchLoadPartResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchLoadPartResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchLoadPartResp) ProtoMessage() {}

func (x *FetchLoadPartResp) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchLoadPartResp.ProtoReflect.Descriptor instead.
func (*FetchLoadPartResp) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{6}
}

func (x *FetchLoadPartResp) GetBase() *BaseResponse {
	if x != nil {
		return x.Base
	}
	return nil
}

func (x *FetchLoadPartResp) GetTaskId() int32 {
	if x != nil {
		return x.TaskId
	}
	return 0
}

func (x *FetchLoadPartResp) GetPartId() int32 {
	if x != nil {
		return x.PartId
	}
	return 0
}

func (x *FetchLoadPartResp) GetLoadType() string {
	if x != nil {
		return x.LoadType
	}
	return ""
}

func (x *FetchLoadPartResp) GetParams() map[string]string {
	if x != nil {
		return x.Params
	}
	return nil
}

type LoadPartStatusReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base   *BaseRequest `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
	TaskId int32        `protobuf:"varint,2,opt,name=TaskId,proto3" json:"TaskId,omitempty"`
	PartId int32        `protobuf:"varint,3,opt,name=PartId,proto3" json:"PartId,omitempty"`
	State  string       `protobuf:"bytes,4,opt,name=State,proto3" json:"State,omitempty"`
}

func (x *LoadPartStatusReq) Reset() {
	*x = LoadPartStatusReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoadPartStatusReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadPartStatusReq) ProtoMessage() {}

func (x *LoadPartStatusReq) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadPartStatusReq.ProtoReflect.Descriptor instead.
func (*LoadPartStatusReq) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{7}
}

func (x *LoadPartStatusReq) GetBase() *BaseRequest {
	if x != nil {
		return x.Base
	}
	return nil
}

func (x *LoadPartStatusReq) GetTaskId() int32 {
	if x != nil {
		return x.TaskId
	}
	return 0
}

func (x *LoadPartStatusReq) GetPartId() int32 {
	if x != nil {
		return x.PartId
	}
	return 0
}

func (x *LoadPartStatusReq) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

type LoadPartStatusResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base *BaseResponse `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
}

func (x *LoadPartStatusResp) Reset() {
	*x = LoadPartStatusResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoadPartStatusResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadPartStatusResp) ProtoMessage() {}

func (x *LoadPartStatusResp) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadPartStatusResp.ProtoReflect.Descriptor instead.
func (*LoadPartStatusResp) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{8}
}

func (x *LoadPartStatusResp) GetBase() *BaseResponse {
	if x != nil {
		return x.Base
	}
	return nil
}

type LoadTaskStatusReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base       *BaseRequest `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
	TaskId     int32        `protobuf:"varint,2,opt,name=TaskId,proto3" json:"TaskId,omitempty"`
	WorkerName string       `protobuf:"bytes,3,opt,name=workerName,proto3" json:"workerName,omitempty"`
	State      string       `protobuf:"bytes,4,opt,name=State,proto3" json:"State,omitempty"`
	ErrorMsg   string       `protobuf:"bytes,5,opt,name=ErrorMsg,proto3" json:"ErrorMsg,omitempty"`
}

func (x *LoadTaskStatusReq) Reset() {
	*x = LoadTaskStatusReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoadTaskStatusReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadTaskStatusReq) ProtoMessage() {}

func (x *LoadTaskStatusReq) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadTaskStatusReq.ProtoReflect.Descriptor instead.
func (*LoadTaskStatusReq) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{9}
}

func (x *LoadTaskStatusReq) GetBase() *BaseRequest {
	if x != nil {
		return x.Base
	}
	return nil
}

func (x *LoadTaskStatusReq) GetTaskId() int32 {
	if x != nil {
		return x.TaskId
	}
	return 0
}

func (x *LoadTaskStatusReq) GetWorkerName() string {
	if x != nil {
		return x.WorkerName
	}
	return ""
}

func (x *LoadTaskStatusReq) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

func (x *LoadTaskStatusReq) GetErrorMsg() string {
	if x != nil {
		return x.ErrorMsg
	}
	return ""
}

type LoadTaskStatusResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base *BaseResponse `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
}

func (x *LoadTaskStatusResp) Reset() {
	*x = LoadTaskStatusResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoadTaskStatusResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadTaskStatusResp) ProtoMessage() {}

func (x *LoadTaskStatusResp) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadTaskStatusResp.ProtoReflect.Descriptor instead.
func (*LoadTaskStatusResp) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{10}
}

func (x *LoadTaskStatusResp) GetBase() *BaseResponse {
	if x != nil {
		return x.Base
	}
	return nil
}

type WorkerVertexCountReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base       *BaseRequest `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
	WorkerName string       `protobuf:"bytes,2,opt,name=WorkerName,proto3" json:"WorkerName,omitempty"`
	Count      uint32       `protobuf:"varint,3,opt,name=Count,proto3" json:"Count,omitempty"`
	TaskId     int32        `protobuf:"varint,4,opt,name=TaskId,proto3" json:"TaskId,omitempty"`
}

func (x *WorkerVertexCountReq) Reset() {
	*x = WorkerVertexCountReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkerVertexCountReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerVertexCountReq) ProtoMessage() {}

func (x *WorkerVertexCountReq) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerVertexCountReq.ProtoReflect.Descriptor instead.
func (*WorkerVertexCountReq) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{11}
}

func (x *WorkerVertexCountReq) GetBase() *BaseRequest {
	if x != nil {
		return x.Base
	}
	return nil
}

func (x *WorkerVertexCountReq) GetWorkerName() string {
	if x != nil {
		return x.WorkerName
	}
	return ""
}

func (x *WorkerVertexCountReq) GetCount() uint32 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *WorkerVertexCountReq) GetTaskId() int32 {
	if x != nil {
		return x.TaskId
	}
	return 0
}

type WorkerVertexCountResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base *BaseResponse `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
}

func (x *WorkerVertexCountResp) Reset() {
	*x = WorkerVertexCountResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkerVertexCountResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerVertexCountResp) ProtoMessage() {}

func (x *WorkerVertexCountResp) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerVertexCountResp.ProtoReflect.Descriptor instead.
func (*WorkerVertexCountResp) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{12}
}

func (x *WorkerVertexCountResp) GetBase() *BaseResponse {
	if x != nil {
		return x.Base
	}
	return nil
}

type WorkerEdgeCountReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base       *BaseRequest `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
	WorkerName string       `protobuf:"bytes,2,opt,name=WorkerName,proto3" json:"WorkerName,omitempty"`
	Count      int64        `protobuf:"varint,3,opt,name=Count,proto3" json:"Count,omitempty"`
	TaskId     int32        `protobuf:"varint,4,opt,name=TaskId,proto3" json:"TaskId,omitempty"`
}

func (x *WorkerEdgeCountReq) Reset() {
	*x = WorkerEdgeCountReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkerEdgeCountReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerEdgeCountReq) ProtoMessage() {}

func (x *WorkerEdgeCountReq) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerEdgeCountReq.ProtoReflect.Descriptor instead.
func (*WorkerEdgeCountReq) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{13}
}

func (x *WorkerEdgeCountReq) GetBase() *BaseRequest {
	if x != nil {
		return x.Base
	}
	return nil
}

func (x *WorkerEdgeCountReq) GetWorkerName() string {
	if x != nil {
		return x.WorkerName
	}
	return ""
}

func (x *WorkerEdgeCountReq) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *WorkerEdgeCountReq) GetTaskId() int32 {
	if x != nil {
		return x.TaskId
	}
	return 0
}

type WorkerEdgeCountResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base *BaseResponse `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
}

func (x *WorkerEdgeCountResp) Reset() {
	*x = WorkerEdgeCountResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkerEdgeCountResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerEdgeCountResp) ProtoMessage() {}

func (x *WorkerEdgeCountResp) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerEdgeCountResp.ProtoReflect.Descriptor instead.
func (*WorkerEdgeCountResp) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{14}
}

func (x *WorkerEdgeCountResp) GetBase() *BaseResponse {
	if x != nil {
		return x.Base
	}
	return nil
}

type GraphWorker struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name        string `protobuf:"bytes,1,opt,name=Name,proto3" json:"Name,omitempty"`
	VertexCount uint32 `protobuf:"varint,2,opt,name=VertexCount,proto3" json:"VertexCount,omitempty"`
	VertIdStart uint32 `protobuf:"varint,3,opt,name=VertIdStart,proto3" json:"VertIdStart,omitempty"`
}

func (x *GraphWorker) Reset() {
	*x = GraphWorker{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GraphWorker) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GraphWorker) ProtoMessage() {}

func (x *GraphWorker) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GraphWorker.ProtoReflect.Descriptor instead.
func (*GraphWorker) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{15}
}

func (x *GraphWorker) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GraphWorker) GetVertexCount() uint32 {
	if x != nil {
		return x.VertexCount
	}
	return 0
}

func (x *GraphWorker) GetVertIdStart() uint32 {
	if x != nil {
		return x.VertIdStart
	}
	return 0
}

type GetGraphWorkersReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base      *BaseRequest `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
	GraphName string       `protobuf:"bytes,2,opt,name=GraphName,proto3" json:"GraphName,omitempty"`
	SpaceName string       `protobuf:"bytes,3,opt,name=SpaceName,proto3" json:"SpaceName,omitempty"`
}

func (x *GetGraphWorkersReq) Reset() {
	*x = GetGraphWorkersReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGraphWorkersReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGraphWorkersReq) ProtoMessage() {}

func (x *GetGraphWorkersReq) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGraphWorkersReq.ProtoReflect.Descriptor instead.
func (*GetGraphWorkersReq) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{16}
}

func (x *GetGraphWorkersReq) GetBase() *BaseRequest {
	if x != nil {
		return x.Base
	}
	return nil
}

func (x *GetGraphWorkersReq) GetGraphName() string {
	if x != nil {
		return x.GraphName
	}
	return ""
}

func (x *GetGraphWorkersReq) GetSpaceName() string {
	if x != nil {
		return x.SpaceName
	}
	return ""
}

type GetGraphWorkersResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base    *BaseResponse  `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
	Workers []*GraphWorker `protobuf:"bytes,2,rep,name=Workers,proto3" json:"Workers,omitempty"`
}

func (x *GetGraphWorkersResp) Reset() {
	*x = GetGraphWorkersResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGraphWorkersResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGraphWorkersResp) ProtoMessage() {}

func (x *GetGraphWorkersResp) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGraphWorkersResp.ProtoReflect.Descriptor instead.
func (*GetGraphWorkersResp) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{17}
}

func (x *GetGraphWorkersResp) GetBase() *BaseResponse {
	if x != nil {
		return x.Base
	}
	return nil
}

func (x *GetGraphWorkersResp) GetWorkers() []*GraphWorker {
	if x != nil {
		return x.Workers
	}
	return nil
}

type ComputeTaskReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base       *BaseRequest `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
	WorkerName string       `protobuf:"bytes,2,opt,name=WorkerName,proto3" json:"WorkerName,omitempty"`
	TaskId     int32        `protobuf:"varint,3,opt,name=TaskId,proto3" json:"TaskId,omitempty"`
	State      string       `protobuf:"bytes,4,opt,name=State,proto3" json:"State,omitempty"`
}

func (x *ComputeTaskReq) Reset() {
	*x = ComputeTaskReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputeTaskReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeTaskReq) ProtoMessage() {}

func (x *ComputeTaskReq) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeTaskReq.ProtoReflect.Descriptor instead.
func (*ComputeTaskReq) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{18}
}

func (x *ComputeTaskReq) GetBase() *BaseRequest {
	if x != nil {
		return x.Base
	}
	return nil
}

func (x *ComputeTaskReq) GetWorkerName() string {
	if x != nil {
		return x.WorkerName
	}
	return ""
}

func (x *ComputeTaskReq) GetTaskId() int32 {
	if x != nil {
		return x.TaskId
	}
	return 0
}

func (x *ComputeTaskReq) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

type ComputeTaskResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base      *BaseResponse     `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
	Algorithm string            `protobuf:"bytes,2,opt,name=Algorithm,proto3" json:"Algorithm,omitempty"`
	TaskId    int32             `protobuf:"varint,3,opt,name=TaskId,proto3" json:"TaskId,omitempty"`
	GraphName string            `protobuf:"bytes,4,opt,name=GraphName,proto3" json:"GraphName,omitempty"`
	SpaceName string            `protobuf:"bytes,5,opt,name=SpaceName,proto3" json:"SpaceName,omitempty"`
	Params    map[string]string `protobuf:"bytes,6,rep,name=Params,proto3" json:"Params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Action    ComputeAction     `protobuf:"varint,7,opt,name=Action,proto3,enum=master.ComputeAction" json:"Action,omitempty"`
}

func (x *ComputeTaskResp) Reset() {
	*x = ComputeTaskResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputeTaskResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeTaskResp) ProtoMessage() {}

func (x *ComputeTaskResp) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeTaskResp.ProtoReflect.Descriptor instead.
func (*ComputeTaskResp) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{19}
}

func (x *ComputeTaskResp) GetBase() *BaseResponse {
	if x != nil {
		return x.Base
	}
	return nil
}

func (x *ComputeTaskResp) GetAlgorithm() string {
	if x != nil {
		return x.Algorithm
	}
	return ""
}

func (x *ComputeTaskResp) GetTaskId() int32 {
	if x != nil {
		return x.TaskId
	}
	return 0
}

func (x *ComputeTaskResp) GetGraphName() string {
	if x != nil {
		return x.GraphName
	}
	return ""
}

func (x *ComputeTaskResp) GetSpaceName() string {
	if x != nil {
		return x.SpaceName
	}
	return ""
}

func (x *ComputeTaskResp) GetParams() map[string]string {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *ComputeTaskResp) GetAction() ComputeAction {
	if x != nil {
		return x.Action
	}
	return ComputeAction_Compute
}

type ComputeTaskStatusReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base          *BaseRequest      `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
	WorkerName    string            `protobuf:"bytes,2,opt,name=WorkerName,proto3" json:"WorkerName,omitempty"`
	TaskId        int32             `protobuf:"varint,3,opt,name=TaskId,proto3" json:"TaskId,omitempty"`
	State         string            `protobuf:"bytes,4,opt,name=State,proto3" json:"State,omitempty"`
	ErrorMsg      string            `protobuf:"bytes,5,opt,name=ErrorMsg,proto3" json:"ErrorMsg,omitempty"`
	Step          int32             `protobuf:"varint,6,opt,name=Step,proto3" json:"Step,omitempty"`
	ComputeValues map[string][]byte `protobuf:"bytes,7,rep,name=ComputeValues,proto3" json:"ComputeValues,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	SpaceName     string            `protobuf:"bytes,8,opt,name=SpaceName,proto3" json:"SpaceName,omitempty"`
}

func (x *ComputeTaskStatusReq) Reset() {
	*x = ComputeTaskStatusReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputeTaskStatusReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeTaskStatusReq) ProtoMessage() {}

func (x *ComputeTaskStatusReq) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeTaskStatusReq.ProtoReflect.Descriptor instead.
func (*ComputeTaskStatusReq) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{20}
}

func (x *ComputeTaskStatusReq) GetBase() *BaseRequest {
	if x != nil {
		return x.Base
	}
	return nil
}

func (x *ComputeTaskStatusReq) GetWorkerName() string {
	if x != nil {
		return x.WorkerName
	}
	return ""
}

func (x *ComputeTaskStatusReq) GetTaskId() int32 {
	if x != nil {
		return x.TaskId
	}
	return 0
}

func (x *ComputeTaskStatusReq) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

func (x *ComputeTaskStatusReq) GetErrorMsg() string {
	if x != nil {
		return x.ErrorMsg
	}
	return ""
}

func (x *ComputeTaskStatusReq) GetStep() int32 {
	if x != nil {
		return x.Step
	}
	return 0
}

func (x *ComputeTaskStatusReq) GetComputeValues() map[string][]byte {
	if x != nil {
		return x.ComputeValues
	}
	return nil
}

func (x *ComputeTaskStatusReq) GetSpaceName() string {
	if x != nil {
		return x.SpaceName
	}
	return ""
}

type ComputeTaskStatusResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base *BaseResponse `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
}

func (x *ComputeTaskStatusResp) Reset() {
	*x = ComputeTaskStatusResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputeTaskStatusResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeTaskStatusResp) ProtoMessage() {}

func (x *ComputeTaskStatusResp) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeTaskStatusResp.ProtoReflect.Descriptor instead.
func (*ComputeTaskStatusResp) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{21}
}

func (x *ComputeTaskStatusResp) GetBase() *BaseResponse {
	if x != nil {
		return x.Base
	}
	return nil
}

type SuperStepReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base *BaseRequest `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
}

func (x *SuperStepReq) Reset() {
	*x = SuperStepReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SuperStepReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuperStepReq) ProtoMessage() {}

func (x *SuperStepReq) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuperStepReq.ProtoReflect.Descriptor instead.
func (*SuperStepReq) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{22}
}

func (x *SuperStepReq) GetBase() *BaseRequest {
	if x != nil {
		return x.Base
	}
	return nil
}

type SuperStepResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base          *BaseResponse     `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
	WorkerName    string            `protobuf:"bytes,2,opt,name=WorkerName,proto3" json:"WorkerName,omitempty"`
	TaskId        int32             `protobuf:"varint,3,opt,name=TaskId,proto3" json:"TaskId,omitempty"`
	Step          int32             `protobuf:"varint,4,opt,name=Step,proto3" json:"Step,omitempty"`
	Output        bool              `protobuf:"varint,5,opt,name=Output,proto3" json:"Output,omitempty"`
	ComputeValues map[string][]byte `protobuf:"bytes,6,rep,name=ComputeValues,proto3" json:"ComputeValues,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *SuperStepResp) Reset() {
	*x = SuperStepResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SuperStepResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuperStepResp) ProtoMessage() {}

func (x *SuperStepResp) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuperStepResp.ProtoReflect.Descriptor instead.
func (*SuperStepResp) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{23}
}

func (x *SuperStepResp) GetBase() *BaseResponse {
	if x != nil {
		return x.Base
	}
	return nil
}

func (x *SuperStepResp) GetWorkerName() string {
	if x != nil {
		return x.WorkerName
	}
	return ""
}

func (x *SuperStepResp) GetTaskId() int32 {
	if x != nil {
		return x.TaskId
	}
	return 0
}

func (x *SuperStepResp) GetStep() int32 {
	if x != nil {
		return x.Step
	}
	return 0
}

func (x *SuperStepResp) GetOutput() bool {
	if x != nil {
		return x.Output
	}
	return false
}

func (x *SuperStepResp) GetComputeValues() map[string][]byte {
	if x != nil {
		return x.ComputeValues
	}
	return nil
}

type VertexValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ID    string `protobuf:"bytes,1,opt,name=ID,proto3" json:"ID,omitempty"`
	Value string `protobuf:"bytes,2,opt,name=Value,proto3" json:"Value,omitempty"`
}

func (x *VertexValue) Reset() {
	*x = VertexValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VertexValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VertexValue) ProtoMessage() {}

func (x *VertexValue) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VertexValue.ProtoReflect.Descriptor instead.
func (*VertexValue) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{24}
}

func (x *VertexValue) GetID() string {
	if x != nil {
		return x.ID
	}
	return ""
}

func (x *VertexValue) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

type UploadVertexValueReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base         *BaseRequest   `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
	TaskId       int32          `protobuf:"varint,2,opt,name=TaskId,proto3" json:"TaskId,omitempty"`
	VertexValues []*VertexValue `protobuf:"bytes,3,rep,name=VertexValues,proto3" json:"VertexValues,omitempty"`
}

func (x *UploadVertexValueReq) Reset() {
	*x = UploadVertexValueReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadVertexValueReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadVertexValueReq) ProtoMessage() {}

func (x *UploadVertexValueReq) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadVertexValueReq.ProtoReflect.Descriptor instead.
func (*UploadVertexValueReq) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{25}
}

func (x *UploadVertexValueReq) GetBase() *BaseRequest {
	if x != nil {
		return x.Base
	}
	return nil
}

func (x *UploadVertexValueReq) GetTaskId() int32 {
	if x != nil {
		return x.TaskId
	}
	return 0
}

func (x *UploadVertexValueReq) GetVertexValues() []*VertexValue {
	if x != nil {
		return x.VertexValues
	}
	return nil
}

type UploadVertexValueResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base *BaseRequest `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
}

func (x *UploadVertexValueResp) Reset() {
	*x = UploadVertexValueResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadVertexValueResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadVertexValueResp) ProtoMessage() {}

func (x *UploadVertexValueResp) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadVertexValueResp.ProtoReflect.Descriptor instead.
func (*UploadVertexValueResp) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{26}
}

func (x *UploadVertexValueResp) GetBase() *BaseRequest {
	if x != nil {
		return x.Base
	}
	return nil
}

type UploadStatisticsReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base       *BaseRequest `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
	TaskId     int32        `protobuf:"varint,2,opt,name=TaskId,proto3" json:"TaskId,omitempty"`
	Statistics []byte       `protobuf:"bytes,3,opt,name=Statistics,proto3" json:"Statistics,omitempty"`
}

func (x *UploadStatisticsReq) Reset() {
	*x = UploadStatisticsReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadStatisticsReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadStatisticsReq) ProtoMessage() {}

func (x *UploadStatisticsReq) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadStatisticsReq.ProtoReflect.Descriptor instead.
func (*UploadStatisticsReq) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{27}
}

func (x *UploadStatisticsReq) GetBase() *BaseRequest {
	if x != nil {
		return x.Base
	}
	return nil
}

func (x *UploadStatisticsReq) GetTaskId() int32 {
	if x != nil {
		return x.TaskId
	}
	return 0
}

func (x *UploadStatisticsReq) GetStatistics() []byte {
	if x != nil {
		return x.Statistics
	}
	return nil
}

type UploadStatisticsResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base *BaseRequest `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
}

func (x *UploadStatisticsResp) Reset() {
	*x = UploadStatisticsResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadStatisticsResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadStatisticsResp) ProtoMessage() {}

func (x *UploadStatisticsResp) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadStatisticsResp.ProtoReflect.Descriptor instead.
func (*UploadStatisticsResp) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{28}
}

func (x *UploadStatisticsResp) GetBase() *BaseRequest {
	if x != nil {
		return x.Base
	}
	return nil
}

type SettingGraphReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base       *BaseRequest `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
	TaskId     int32        `protobuf:"varint,2,opt,name=TaskId,proto3" json:"TaskId,omitempty"`
	WorkerName string       `protobuf:"bytes,3,opt,name=workerName,proto3" json:"workerName,omitempty"`
	State      string       `protobuf:"bytes,4,opt,name=State,proto3" json:"State,omitempty"`
	ErrorMsg   string       `protobuf:"bytes,5,opt,name=ErrorMsg,proto3" json:"ErrorMsg,omitempty"`
}

func (x *SettingGraphReq) Reset() {
	*x = SettingGraphReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SettingGraphReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SettingGraphReq) ProtoMessage() {}

func (x *SettingGraphReq) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SettingGraphReq.ProtoReflect.Descriptor instead.
func (*SettingGraphReq) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{29}
}

func (x *SettingGraphReq) GetBase() *BaseRequest {
	if x != nil {
		return x.Base
	}
	return nil
}

func (x *SettingGraphReq) GetTaskId() int32 {
	if x != nil {
		return x.TaskId
	}
	return 0
}

func (x *SettingGraphReq) GetWorkerName() string {
	if x != nil {
		return x.WorkerName
	}
	return ""
}

func (x *SettingGraphReq) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

func (x *SettingGraphReq) GetErrorMsg() string {
	if x != nil {
		return x.ErrorMsg
	}
	return ""
}

type SettingGraphResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base *BaseResponse `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
}

func (x *SettingGraphResp) Reset() {
	*x = SettingGraphResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SettingGraphResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SettingGraphResp) ProtoMessage() {}

func (x *SettingGraphResp) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SettingGraphResp.ProtoReflect.Descriptor instead.
func (*SettingGraphResp) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{30}
}

func (x *SettingGraphResp) GetBase() *BaseResponse {
	if x != nil {
		return x.Base
	}
	return nil
}

type UploadTPResultReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base   *BaseRequest `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
	TaskId int32        `protobuf:"varint,2,opt,name=TaskId,proto3" json:"TaskId,omitempty"`
	Result []byte       `protobuf:"bytes,3,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *UploadTPResultReq) Reset() {
	*x = UploadTPResultReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadTPResultReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadTPResultReq) ProtoMessage() {}

func (x *UploadTPResultReq) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadTPResultReq.ProtoReflect.Descriptor instead.
func (*UploadTPResultReq) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{31}
}

func (x *UploadTPResultReq) GetBase() *BaseRequest {
	if x != nil {
		return x.Base
	}
	return nil
}

func (x *UploadTPResultReq) GetTaskId() int32 {
	if x != nil {
		return x.TaskId
	}
	return 0
}

func (x *UploadTPResultReq) GetResult() []byte {
	if x != nil {
		return x.Result
	}
	return nil
}

type UploadTPResultResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Base *BaseRequest `protobuf:"bytes,1,opt,name=Base,proto3" json:"Base,omitempty"`
}

func (x *UploadTPResultResp) Reset() {
	*x = UploadTPResultResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_master_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadTPResultResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadTPResultResp) ProtoMessage() {}

func (x *UploadTPResultResp) ProtoReflect() protoreflect.Message {
	mi := &file_master_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadTPResultResp.ProtoReflect.Descriptor instead.
func (*UploadTPResultResp) Descriptor() ([]byte, []int) {
	return file_master_proto_rawDescGZIP(), []int{32}
}

func (x *UploadTPResultResp) GetBase() *BaseRequest {
	if x != nil {
		return x.Base
	}
	return nil
}

var File_master_proto protoreflect.FileDescriptor

var file_master_proto_rawDesc = []byte{
	0x0a, 0x0c, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x06,
	0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x1a, 0x0c, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x95, 0x01, 0x0a, 0x0e, 0x48, 0x65, 0x6c, 0x6c, 0x6f, 0x4d, 0x61,
	0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x12, 0x27, 0x0a, 0x04, 0x42, 0x61, 0x73, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x42,
	0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x04, 0x42, 0x61, 0x73, 0x65,
	0x12, 0x1e, 0x0a, 0x0a, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x65, 0x65, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x65, 0x65, 0x72,
	0x12, 0x18, 0x0a, 0x07, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x57, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0xbd, 0x01, 0x0a,
	0x0f, 0x48, 0x65, 0x6c, 0x6c, 0x6f, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70,
	0x12, 0x28, 0x0a, 0x04, 0x42, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x42, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x52, 0x04, 0x42, 0x61, 0x73, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x57, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x49, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x57, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x4e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x57, 0x6f, 0x72, 0x6b,
	0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x07, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72,
	0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x07, 0x57, 0x6f, 0x72,
	0x6b, 0x65, 0x72, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x53, 0x70, 0x61, 0x63, 0x65, 0x73, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x53, 0x70, 0x61, 0x63, 0x65, 0x73, 0x22, 0x4c, 0x0a, 0x0a,
	0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x4e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x0e,
	0x0a, 0x02, 0x49, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x02, 0x49, 0x64, 0x12, 0x1a,
	0x0a, 0x08, 0x47, 0x72, 0x70, 0x63, 0x50, 0x65, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x47, 0x72, 0x70, 0x63, 0x50, 0x65, 0x65, 0x72, 0x22, 0xa1, 0x01, 0x0a, 0x10, 0x4c,
	0x6f, 0x61, 0x64, 0x47, 0x72, 0x61, 0x70, 0x68, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x71, 0x12,
	0x27, 0x0a, 0x04, 0x42, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x42, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x52, 0x04, 0x42, 0x61, 0x73, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x57, 0x6f, 0x72, 0x6b,
	0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x57, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x54, 0x61, 0x73, 0x6b,
	0x49, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x64,
	0x12, 0x14, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x50, 0x61, 0x72, 0x74, 0x49, 0x64,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x50, 0x61, 0x72, 0x74, 0x49, 0x64, 0x22, 0x83,
	0x03, 0x0a, 0x11, 0x4c, 0x6f, 0x61, 0x64, 0x47, 0x72, 0x61, 0x70, 0x68, 0x54, 0x61, 0x73, 0x6b,
	0x52, 0x65, 0x73, 0x70, 0x12, 0x28, 0x0a, 0x04, 0x42, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x14, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x42, 0x61, 0x73, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x04, 0x42, 0x61, 0x73, 0x65, 0x12, 0x1a,
	0x0a, 0x08, 0x4c, 0x6f, 0x61, 0x64, 0x54, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x4c, 0x6f, 0x61, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x50, 0x61,
	0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x50, 0x61,
	0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x12, 0x1c,
	0x0a, 0x09, 0x53, 0x70, 0x61, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x53, 0x70, 0x61, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09,
	0x47, 0x72, 0x61, 0x70, 0x68, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x47, 0x72, 0x61, 0x70, 0x68, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x57, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x57, 0x6f, 0x72,
	0x6b, 0x65, 0x72, 0x73, 0x12, 0x24, 0x0a, 0x04, 0x53, 0x74, 0x65, 0x70, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x10, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x4c, 0x6f, 0x61, 0x64,
	0x53, 0x74, 0x65, 0x70, 0x52, 0x04, 0x53, 0x74, 0x65, 0x70, 0x12, 0x3d, 0x0a, 0x06, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x6d, 0x61, 0x73,
	0x74, 0x65, 0x72, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x47, 0x72, 0x61, 0x70, 0x68, 0x54, 0x61, 0x73,
	0x6b, 0x52, 0x65, 0x73, 0x70, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x06, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x73, 0x0a, 0x10, 0x46, 0x65, 0x74, 0x63, 0x68, 0x4c, 0x6f, 0x61,
	0x64, 0x50, 0x61, 0x72, 0x74, 0x52, 0x65, 0x71, 0x12, 0x27, 0x0a, 0x04, 0x42, 0x61, 0x73, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x42, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x04, 0x42, 0x61, 0x73,
	0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x16, 0x0a, 0x06, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x06, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x22, 0x83, 0x02, 0x0a, 0x11, 0x46, 0x65,
	0x74, 0x63, 0x68, 0x4c, 0x6f, 0x61, 0x64, 0x50, 0x61, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x12,
	0x28, 0x0a, 0x04, 0x42, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x42, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x52, 0x04, 0x42, 0x61, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x54, 0x61, 0x73,
	0x6b, 0x49, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x54, 0x61, 0x73, 0x6b, 0x49,
	0x64, 0x12, 0x16, 0x0a, 0x06, 0x50, 0x61, 0x72, 0x74, 0x49, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x06, 0x50, 0x61, 0x72, 0x74, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x61,
	0x64, 0x54, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x61,
	0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3d, 0x0a, 0x06, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18,
	0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x46,
	0x65, 0x74, 0x63, 0x68, 0x4c, 0x6f, 0x61, 0x64, 0x50, 0x61, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x82, 0x01, 0x0a, 0x11, 0x4c, 0x6f, 0x61, 0x64, 0x50, 0x61, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x65, 0x71, 0x12, 0x27, 0x0a, 0x04, 0x42, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x42, 0x61, 0x73,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x04, 0x42, 0x61, 0x73, 0x65, 0x12, 0x16,
	0x0a, 0x06, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06,
	0x54, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x50, 0x61, 0x72, 0x74, 0x49, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x50, 0x61, 0x72, 0x74, 0x49, 0x64, 0x12, 0x14,
	0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x22, 0x3e, 0x0a, 0x12, 0x4c, 0x6f, 0x61, 0x64, 0x50, 0x61, 0x72, 0x74,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x12, 0x28, 0x0a, 0x04, 0x42, 0x61,
	0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x42, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x04,
	0x42, 0x61, 0x73, 0x65, 0x22, 0xa6, 0x01, 0x0a, 0x11, 0x4c, 0x6f, 0x61, 0x64, 0x54, 0x61, 0x73,
	0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x12, 0x27, 0x0a, 0x04, 0x42, 0x61,
	0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x42, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x04, 0x42,
	0x61, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x06, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x77,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x1a, 0x0a, 0x08, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x73, 0x67, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x73, 0x67, 0x22, 0x3e, 0x0a,
	0x12, 0x4c, 0x6f, 0x61, 0x64, 0x54, 0x61, 0x73, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x12, 0x28, 0x0a, 0x04, 0x42, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x14, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x42, 0x61, 0x73, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x04, 0x42, 0x61, 0x73, 0x65, 0x22, 0x8d, 0x01,
	0x0a, 0x14, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x12, 0x27, 0x0a, 0x04, 0x42, 0x61, 0x73, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x42, 0x61,
	0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x04, 0x42, 0x61, 0x73, 0x65, 0x12,
	0x1e, 0x0a, 0x0a, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x22, 0x41, 0x0a,
	0x15, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x12, 0x28, 0x0a, 0x04, 0x42, 0x61, 0x73, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x42, 0x61,
	0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x04, 0x42, 0x61, 0x73, 0x65,
	0x22, 0x8b, 0x01, 0x0a, 0x12, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x45, 0x64, 0x67, 0x65, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x12, 0x27, 0x0a, 0x04, 0x42, 0x61, 0x73, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x42,
	0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x04, 0x42, 0x61, 0x73, 0x65,
	0x12, 0x1e, 0x0a, 0x0a, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x05, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x22, 0x3f,
	0x0a, 0x13, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x45, 0x64, 0x67, 0x65, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x12, 0x28, 0x0a, 0x04, 0x42, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x42, 0x61, 0x73,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x04, 0x42, 0x61, 0x73, 0x65, 0x22,
	0x65, 0x0a, 0x0b, 0x47, 0x72, 0x61, 0x70, 0x68, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x12, 0x12,
	0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x56, 0x65, 0x72, 0x74, 0x49, 0x64, 0x53, 0x74,
	0x61, 0x72, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x56, 0x65, 0x72, 0x74, 0x49,
	0x64, 0x53, 0x74, 0x61, 0x72, 0x74, 0x22, 0x79, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x47, 0x72, 0x61,
	0x70, 0x68, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x12, 0x27, 0x0a, 0x04,
	0x42, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x42, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52,
	0x04, 0x42, 0x61, 0x73, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x47, 0x72, 0x61, 0x70, 0x68, 0x4e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x47, 0x72, 0x61, 0x70, 0x68, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x53, 0x70, 0x61, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x53, 0x70, 0x61, 0x63, 0x65, 0x4e, 0x61, 0x6d,
	0x65, 0x22, 0x6e, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x47, 0x72, 0x61, 0x70, 0x68, 0x57, 0x6f, 0x72,
	0x6b, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x12, 0x28, 0x0a, 0x04, 0x42, 0x61, 0x73, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x42, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x04, 0x42, 0x61,
	0x73, 0x65, 0x12, 0x2d, 0x0a, 0x07, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x47, 0x72, 0x61,
	0x70, 0x68, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x52, 0x07, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x73, 0x22, 0x87, 0x01, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x54, 0x61, 0x73,
	0x6b, 0x52, 0x65, 0x71, 0x12, 0x27, 0x0a, 0x04, 0x42, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x13, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x42, 0x61, 0x73, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x04, 0x42, 0x61, 0x73, 0x65, 0x12, 0x1e, 0x0a,
	0x0a, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a,
	0x06, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x54,
	0x61, 0x73, 0x6b, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0xd4, 0x02, 0x0a, 0x0f,
	0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x12,
	0x28, 0x0a, 0x04, 0x42, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x42, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x52, 0x04, 0x42, 0x61, 0x73, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x41, 0x6c, 0x67,
	0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x41, 0x6c,
	0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x16, 0x0a, 0x06, 0x54, 0x61, 0x73, 0x6b, 0x49,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x12,
	0x1c, 0x0a, 0x09, 0x47, 0x72, 0x61, 0x70, 0x68, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x47, 0x72, 0x61, 0x70, 0x68, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a,
	0x09, 0x53, 0x70, 0x61, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x53, 0x70, 0x61, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x06, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x6d, 0x61,
	0x73, 0x74, 0x65, 0x72, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x54, 0x61, 0x73, 0x6b,
	0x52, 0x65, 0x73, 0x70, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x06, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x2d, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65,
	0x72, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0xf4, 0x02, 0x0a, 0x14, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x54, 0x61,
	0x73, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x12, 0x27, 0x0a, 0x04, 0x42,
	0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2e, 0x42, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x04,
	0x42, 0x61, 0x73, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x4e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x73, 0x67, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x73, 0x67, 0x12, 0x12,
	0x0a, 0x04, 0x53, 0x74, 0x65, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x53, 0x74,
	0x65, 0x70, 0x12, 0x55, 0x0a, 0x0d, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x6d, 0x61, 0x73, 0x74,
	0x65, 0x72, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d, 0x43, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x53, 0x70, 0x61,
	0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x53, 0x70,
	0x61, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x40, 0x0a, 0x12, 0x43, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x41, 0x0a, 0x15, 0x43, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x12, 0x28, 0x0a, 0x04, 0x42, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x14, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x42, 0x61, 0x73, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x04, 0x42, 0x61, 0x73, 0x65, 0x22, 0x37, 0x0a, 0x0c,
	0x53, 0x75, 0x70, 0x65, 0x72, 0x53, 0x74, 0x65, 0x70, 0x52, 0x65, 0x71, 0x12, 0x27, 0x0a, 0x04,
	0x42, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x42, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52,
	0x04, 0x42, 0x61, 0x73, 0x65, 0x22, 0xaf, 0x02, 0x0a, 0x0d, 0x53, 0x75, 0x70, 0x65, 0x72, 0x53,
	0x74, 0x65, 0x70, 0x52, 0x65, 0x73, 0x70, 0x12, 0x28, 0x0a, 0x04, 0x42, 0x61, 0x73, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x42,
	0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x04, 0x42, 0x61, 0x73,
	0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x16, 0x0a, 0x06, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x06, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x53, 0x74, 0x65,
	0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x53, 0x74, 0x65, 0x70, 0x12, 0x16, 0x0a,
	0x06, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x4e, 0x0a, 0x0d, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x6d,
	0x61, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x75, 0x70, 0x65, 0x72, 0x53, 0x74, 0x65, 0x70, 0x52,
	0x65, 0x73, 0x70, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x40, 0x0a, 0x12, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x33, 0x0a, 0x0b, 0x56, 0x65, 0x72, 0x74, 0x65,
	0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x02, 0x49, 0x44, 0x12, 0x14, 0x0a, 0x05, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x90, 0x01, 0x0a,
	0x14, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x65, 0x71, 0x12, 0x27, 0x0a, 0x04, 0x42, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x42, 0x61, 0x73,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x04, 0x42, 0x61, 0x73, 0x65, 0x12, 0x16,
	0x0a, 0x06, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06,
	0x54, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x12, 0x37, 0x0a, 0x0c, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x6d,
	0x61, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x0c, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22,
	0x40, 0x0a, 0x15, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x65, 0x73, 0x70, 0x12, 0x27, 0x0a, 0x04, 0x42, 0x61, 0x73, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x42, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x04, 0x42, 0x61, 0x73,
	0x65, 0x22, 0x76, 0x0a, 0x13, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x74, 0x61, 0x74, 0x69,
	0x73, 0x74, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x12, 0x27, 0x0a, 0x04, 0x42, 0x61, 0x73, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x42, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x04, 0x42, 0x61, 0x73,
	0x65, 0x12, 0x16, 0x0a, 0x06, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x06, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x53, 0x74, 0x61,
	0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x53,
	0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x22, 0x3f, 0x0a, 0x14, 0x55, 0x70, 0x6c,
	0x6f, 0x61, 0x64, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x12, 0x27, 0x0a, 0x04, 0x42, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x13, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x42, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x52, 0x04, 0x42, 0x61, 0x73, 0x65, 0x22, 0xa4, 0x01, 0x0a, 0x0f, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x47, 0x72, 0x61, 0x70, 0x68, 0x52, 0x65, 0x71, 0x12, 0x27,
	0x0a, 0x04, 0x42, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x42, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x52, 0x04, 0x42, 0x61, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x54, 0x61, 0x73, 0x6b, 0x49,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x12,
	0x1e, 0x0a, 0x0a, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x73,
	0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x73,
	0x67, 0x22, 0x3c, 0x0a, 0x10, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x47, 0x72, 0x61, 0x70,
	0x68, 0x52, 0x65, 0x73, 0x70, 0x12, 0x28, 0x0a, 0x04, 0x42, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x42, 0x61, 0x73,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x04, 0x42, 0x61, 0x73, 0x65, 0x22,
	0x6c, 0x0a, 0x11, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x54, 0x50, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x52, 0x65, 0x71, 0x12, 0x27, 0x0a, 0x04, 0x42, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x13, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x42, 0x61, 0x73, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x04, 0x42, 0x61, 0x73, 0x65, 0x12, 0x16, 0x0a,
	0x06, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x54,
	0x61, 0x73, 0x6b, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x3d, 0x0a,
	0x12, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x54, 0x50, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x12, 0x27, 0x0a, 0x04, 0x42, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x13, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x42, 0x61, 0x73, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x04, 0x42, 0x61, 0x73, 0x65, 0x2a, 0x5b, 0x0a, 0x08,
	0x4c, 0x6f, 0x61, 0x64, 0x53, 0x74, 0x65, 0x70, 0x12, 0x0a, 0x0a, 0x06, 0x56, 0x65, 0x72, 0x74,
	0x65, 0x78, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x63, 0x61, 0x74, 0x74, 0x65, 0x72, 0x56,
	0x65, 0x72, 0x74, 0x65, 0x78, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x45, 0x64, 0x67, 0x65, 0x10,
	0x02, 0x12, 0x0d, 0x0a, 0x09, 0x4f, 0x75, 0x74, 0x44, 0x65, 0x67, 0x72, 0x65, 0x65, 0x10, 0x03,
	0x12, 0x0c, 0x0a, 0x08, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x10, 0x04, 0x12, 0x09,
	0x0a, 0x05, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x10, 0x05, 0x2a, 0x47, 0x0a, 0x0d, 0x43, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x4f, 0x75, 0x74, 0x45, 0x64, 0x67, 0x65, 0x73, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x4f, 0x75, 0x74, 0x44, 0x65, 0x67, 0x72, 0x65, 0x65,
	0x10, 0x02, 0x32, 0xf0, 0x08, 0x0a, 0x06, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x12, 0x43, 0x0a,
	0x0e, 0x53, 0x61, 0x79, 0x48, 0x65, 0x6c, 0x6c, 0x6f, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x12,
	0x16, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x48, 0x65, 0x6c, 0x6c, 0x6f, 0x4d, 0x61,
	0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x1a, 0x17, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72,
	0x2e, 0x48, 0x65, 0x6c, 0x6c, 0x6f, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70,
	0x22, 0x00, 0x12, 0x4a, 0x0a, 0x0d, 0x4c, 0x6f, 0x61, 0x64, 0x47, 0x72, 0x61, 0x70, 0x68, 0x54,
	0x61, 0x73, 0x6b, 0x12, 0x18, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x4c, 0x6f, 0x61,
	0x64, 0x47, 0x72, 0x61, 0x70, 0x68, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x71, 0x1a, 0x19, 0x2e,
	0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x47, 0x72, 0x61, 0x70, 0x68,
	0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x22, 0x00, 0x28, 0x01, 0x30, 0x01, 0x12, 0x44,
	0x0a, 0x0b, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x12, 0x16, 0x2e,
	0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x54, 0x61,
	0x73, 0x6b, 0x52, 0x65, 0x71, 0x1a, 0x17, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x43,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x22, 0x00,
	0x28, 0x01, 0x30, 0x01, 0x12, 0x3c, 0x0a, 0x09, 0x53, 0x75, 0x70, 0x65, 0x72, 0x53, 0x74, 0x65,
	0x70, 0x12, 0x14, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x75, 0x70, 0x65, 0x72,
	0x53, 0x74, 0x65, 0x70, 0x52, 0x65, 0x71, 0x1a, 0x15, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72,
	0x2e, 0x53, 0x75, 0x70, 0x65, 0x72, 0x53, 0x74, 0x65, 0x70, 0x52, 0x65, 0x73, 0x70, 0x22, 0x00,
	0x30, 0x01, 0x12, 0x46, 0x0a, 0x0d, 0x46, 0x65, 0x74, 0x63, 0x68, 0x4c, 0x6f, 0x61, 0x64, 0x50,
	0x61, 0x72, 0x74, 0x12, 0x18, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x46, 0x65, 0x74,
	0x63, 0x68, 0x4c, 0x6f, 0x61, 0x64, 0x50, 0x61, 0x72, 0x74, 0x52, 0x65, 0x71, 0x1a, 0x19, 0x2e,
	0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x4c, 0x6f, 0x61, 0x64,
	0x50, 0x61, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x22, 0x00, 0x12, 0x49, 0x0a, 0x0e, 0x4c, 0x6f,
	0x61, 0x64, 0x50, 0x61, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x19, 0x2e, 0x6d,
	0x61, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x50, 0x61, 0x72, 0x74, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x1a, 0x1a, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72,
	0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x50, 0x61, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x22, 0x00, 0x12, 0x50, 0x0a, 0x0f, 0x57, 0x6f, 0x72, 0x6b, 0x56, 0x65, 0x72,
	0x74, 0x65, 0x78, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1c, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65,
	0x72, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x1a, 0x1d, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x2e,
	0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x22, 0x00, 0x12, 0x4a, 0x0a, 0x0d, 0x57, 0x6f, 0x72, 0x6b, 0x45,
	0x64, 0x67, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1a, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65,
	0x72, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x45, 0x64, 0x67, 0x65, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x1a, 0x1b, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x57, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x45, 0x64, 0x67, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x22, 0x00, 0x12, 0x4c, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x47, 0x72, 0x61, 0x70, 0x68, 0x57,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x12, 0x1a, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x2e,
	0x47, 0x65, 0x74, 0x47, 0x72, 0x61, 0x70, 0x68, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x52,
	0x65, 0x71, 0x1a, 0x1b, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x47, 0x65, 0x74, 0x47,
	0x72, 0x61, 0x70, 0x68, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x22,
	0x00, 0x12, 0x49, 0x0a, 0x0e, 0x4c, 0x6f, 0x61, 0x64, 0x54, 0x61, 0x73, 0x6b, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x19, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x4c, 0x6f, 0x61,
	0x64, 0x54, 0x61, 0x73, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x1a, 0x1a,
	0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x54, 0x61, 0x73, 0x6b,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x22, 0x00, 0x12, 0x52, 0x0a, 0x11,
	0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x1c, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x1a,
	0x1d, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65,
	0x54, 0x61, 0x73, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x22, 0x00,
	0x12, 0x52, 0x0a, 0x11, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1c, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x55,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x65, 0x71, 0x1a, 0x1d, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x55, 0x70, 0x6c,
	0x6f, 0x61, 0x64, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x22, 0x00, 0x12, 0x4f, 0x0a, 0x10, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x74,
	0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x12, 0x1b, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65,
	0x72, 0x2e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69,
	0x63, 0x73, 0x52, 0x65, 0x71, 0x1a, 0x1c, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x55,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x22, 0x00, 0x12, 0x49, 0x0a, 0x0e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x54,
	0x50, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x19, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72,
	0x2e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x54, 0x50, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52,
	0x65, 0x71, 0x1a, 0x1a, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x55, 0x70, 0x6c, 0x6f,
	0x61, 0x64, 0x54, 0x50, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x65, 0x73, 0x70, 0x22, 0x00,
	0x12, 0x43, 0x0a, 0x0c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x47, 0x72, 0x61, 0x70, 0x68,
	0x12, 0x17, 0x2e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x47, 0x72, 0x61, 0x70, 0x68, 0x52, 0x65, 0x71, 0x1a, 0x18, 0x2e, 0x6d, 0x61, 0x73, 0x74,
	0x65, 0x72, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x47, 0x72, 0x61, 0x70, 0x68, 0x52,
	0x65, 0x73, 0x70, 0x22, 0x00, 0x42, 0x03, 0x5a, 0x01, 0x2f, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_master_proto_rawDescOnce sync.Once
	file_master_proto_rawDescData = file_master_proto_rawDesc
)

func file_master_proto_rawDescGZIP() []byte {
	file_master_proto_rawDescOnce.Do(func() {
		file_master_proto_rawDescData = protoimpl.X.CompressGZIP(file_master_proto_rawDescData)
	})
	return file_master_proto_rawDescData
}

var file_master_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_master_proto_msgTypes = make([]protoimpl.MessageInfo, 38)
var file_master_proto_goTypes = []interface{}{
	(LoadStep)(0),                 // 0: master.LoadStep
	(ComputeAction)(0),            // 1: master.ComputeAction
	(*HelloMasterReq)(nil),        // 2: master.HelloMasterReq
	(*HelloMasterResp)(nil),       // 3: master.HelloMasterResp
	(*WorkerInfo)(nil),            // 4: master.WorkerInfo
	(*LoadGraphTaskReq)(nil),      // 5: master.LoadGraphTaskReq
	(*LoadGraphTaskResp)(nil),     // 6: master.LoadGraphTaskResp
	(*FetchLoadPartReq)(nil),      // 7: master.FetchLoadPartReq
	(*FetchLoadPartResp)(nil),     // 8: master.FetchLoadPartResp
	(*LoadPartStatusReq)(nil),     // 9: master.LoadPartStatusReq
	(*LoadPartStatusResp)(nil),    // 10: master.LoadPartStatusResp
	(*LoadTaskStatusReq)(nil),     // 11: master.LoadTaskStatusReq
	(*LoadTaskStatusResp)(nil),    // 12: master.LoadTaskStatusResp
	(*WorkerVertexCountReq)(nil),  // 13: master.WorkerVertexCountReq
	(*WorkerVertexCountResp)(nil), // 14: master.WorkerVertexCountResp
	(*WorkerEdgeCountReq)(nil),    // 15: master.WorkerEdgeCountReq
	(*WorkerEdgeCountResp)(nil),   // 16: master.WorkerEdgeCountResp
	(*GraphWorker)(nil),           // 17: master.GraphWorker
	(*GetGraphWorkersReq)(nil),    // 18: master.GetGraphWorkersReq
	(*GetGraphWorkersResp)(nil),   // 19: master.GetGraphWorkersResp
	(*ComputeTaskReq)(nil),        // 20: master.ComputeTaskReq
	(*ComputeTaskResp)(nil),       // 21: master.ComputeTaskResp
	(*ComputeTaskStatusReq)(nil),  // 22: master.ComputeTaskStatusReq
	(*ComputeTaskStatusResp)(nil), // 23: master.ComputeTaskStatusResp
	(*SuperStepReq)(nil),          // 24: master.SuperStepReq
	(*SuperStepResp)(nil),         // 25: master.SuperStepResp
	(*VertexValue)(nil),           // 26: master.VertexValue
	(*UploadVertexValueReq)(nil),  // 27: master.UploadVertexValueReq
	(*UploadVertexValueResp)(nil), // 28: master.UploadVertexValueResp
	(*UploadStatisticsReq)(nil),   // 29: master.UploadStatisticsReq
	(*UploadStatisticsResp)(nil),  // 30: master.UploadStatisticsResp
	(*SettingGraphReq)(nil),       // 31: master.SettingGraphReq
	(*SettingGraphResp)(nil),      // 32: master.SettingGraphResp
	(*UploadTPResultReq)(nil),     // 33: master.UploadTPResultReq
	(*UploadTPResultResp)(nil),    // 34: master.UploadTPResultResp
	nil,                           // 35: master.LoadGraphTaskResp.ParamsEntry
	nil,                           // 36: master.FetchLoadPartResp.ParamsEntry
	nil,                           // 37: master.ComputeTaskResp.ParamsEntry
	nil,                           // 38: master.ComputeTaskStatusReq.ComputeValuesEntry
	nil,                           // 39: master.SuperStepResp.ComputeValuesEntry
	(*BaseRequest)(nil),           // 40: common.BaseRequest
	(*BaseResponse)(nil),          // 41: common.BaseResponse
}
var file_master_proto_depIdxs = []int32{
	40, // 0: master.HelloMasterReq.Base:type_name -> common.BaseRequest
	41, // 1: master.HelloMasterResp.Base:type_name -> common.BaseResponse
	4,  // 2: master.HelloMasterResp.Workers:type_name -> master.WorkerInfo
	40, // 3: master.LoadGraphTaskReq.Base:type_name -> common.BaseRequest
	41, // 4: master.LoadGraphTaskResp.Base:type_name -> common.BaseResponse
	0,  // 5: master.LoadGraphTaskResp.Step:type_name -> master.LoadStep
	35, // 6: master.LoadGraphTaskResp.Params:type_name -> master.LoadGraphTaskResp.ParamsEntry
	40, // 7: master.FetchLoadPartReq.Base:type_name -> common.BaseRequest
	41, // 8: master.FetchLoadPartResp.Base:type_name -> common.BaseResponse
	36, // 9: master.FetchLoadPartResp.Params:type_name -> master.FetchLoadPartResp.ParamsEntry
	40, // 10: master.LoadPartStatusReq.Base:type_name -> common.BaseRequest
	41, // 11: master.LoadPartStatusResp.Base:type_name -> common.BaseResponse
	40, // 12: master.LoadTaskStatusReq.Base:type_name -> common.BaseRequest
	41, // 13: master.LoadTaskStatusResp.Base:type_name -> common.BaseResponse
	40, // 14: master.WorkerVertexCountReq.Base:type_name -> common.BaseRequest
	41, // 15: master.WorkerVertexCountResp.Base:type_name -> common.BaseResponse
	40, // 16: master.WorkerEdgeCountReq.Base:type_name -> common.BaseRequest
	41, // 17: master.WorkerEdgeCountResp.Base:type_name -> common.BaseResponse
	40, // 18: master.GetGraphWorkersReq.Base:type_name -> common.BaseRequest
	41, // 19: master.GetGraphWorkersResp.Base:type_name -> common.BaseResponse
	17, // 20: master.GetGraphWorkersResp.Workers:type_name -> master.GraphWorker
	40, // 21: master.ComputeTaskReq.Base:type_name -> common.BaseRequest
	41, // 22: master.ComputeTaskResp.Base:type_name -> common.BaseResponse
	37, // 23: master.ComputeTaskResp.Params:type_name -> master.ComputeTaskResp.ParamsEntry
	1,  // 24: master.ComputeTaskResp.Action:type_name -> master.ComputeAction
	40, // 25: master.ComputeTaskStatusReq.Base:type_name -> common.BaseRequest
	38, // 26: master.ComputeTaskStatusReq.ComputeValues:type_name -> master.ComputeTaskStatusReq.ComputeValuesEntry
	41, // 27: master.ComputeTaskStatusResp.Base:type_name -> common.BaseResponse
	40, // 28: master.SuperStepReq.Base:type_name -> common.BaseRequest
	41, // 29: master.SuperStepResp.Base:type_name -> common.BaseResponse
	39, // 30: master.SuperStepResp.ComputeValues:type_name -> master.SuperStepResp.ComputeValuesEntry
	40, // 31: master.UploadVertexValueReq.Base:type_name -> common.BaseRequest
	26, // 32: master.UploadVertexValueReq.VertexValues:type_name -> master.VertexValue
	40, // 33: master.UploadVertexValueResp.Base:type_name -> common.BaseRequest
	40, // 34: master.UploadStatisticsReq.Base:type_name -> common.BaseRequest
	40, // 35: master.UploadStatisticsResp.Base:type_name -> common.BaseRequest
	40, // 36: master.SettingGraphReq.Base:type_name -> common.BaseRequest
	41, // 37: master.SettingGraphResp.Base:type_name -> common.BaseResponse
	40, // 38: master.UploadTPResultReq.Base:type_name -> common.BaseRequest
	40, // 39: master.UploadTPResultResp.Base:type_name -> common.BaseRequest
	2,  // 40: master.Master.SayHelloMaster:input_type -> master.HelloMasterReq
	5,  // 41: master.Master.LoadGraphTask:input_type -> master.LoadGraphTaskReq
	20, // 42: master.Master.ComputeTask:input_type -> master.ComputeTaskReq
	24, // 43: master.Master.SuperStep:input_type -> master.SuperStepReq
	7,  // 44: master.Master.FetchLoadPart:input_type -> master.FetchLoadPartReq
	9,  // 45: master.Master.LoadPartStatus:input_type -> master.LoadPartStatusReq
	13, // 46: master.Master.WorkVertexCount:input_type -> master.WorkerVertexCountReq
	15, // 47: master.Master.WorkEdgeCount:input_type -> master.WorkerEdgeCountReq
	18, // 48: master.Master.GetGraphWorkers:input_type -> master.GetGraphWorkersReq
	11, // 49: master.Master.LoadTaskStatus:input_type -> master.LoadTaskStatusReq
	22, // 50: master.Master.ComputeTaskStatus:input_type -> master.ComputeTaskStatusReq
	27, // 51: master.Master.UploadVertexValue:input_type -> master.UploadVertexValueReq
	29, // 52: master.Master.UploadStatistics:input_type -> master.UploadStatisticsReq
	33, // 53: master.Master.UploadTPResult:input_type -> master.UploadTPResultReq
	31, // 54: master.Master.SettingGraph:input_type -> master.SettingGraphReq
	3,  // 55: master.Master.SayHelloMaster:output_type -> master.HelloMasterResp
	6,  // 56: master.Master.LoadGraphTask:output_type -> master.LoadGraphTaskResp
	21, // 57: master.Master.ComputeTask:output_type -> master.ComputeTaskResp
	25, // 58: master.Master.SuperStep:output_type -> master.SuperStepResp
	8,  // 59: master.Master.FetchLoadPart:output_type -> master.FetchLoadPartResp
	10, // 60: master.Master.LoadPartStatus:output_type -> master.LoadPartStatusResp
	14, // 61: master.Master.WorkVertexCount:output_type -> master.WorkerVertexCountResp
	16, // 62: master.Master.WorkEdgeCount:output_type -> master.WorkerEdgeCountResp
	19, // 63: master.Master.GetGraphWorkers:output_type -> master.GetGraphWorkersResp
	12, // 64: master.Master.LoadTaskStatus:output_type -> master.LoadTaskStatusResp
	23, // 65: master.Master.ComputeTaskStatus:output_type -> master.ComputeTaskStatusResp
	28, // 66: master.Master.UploadVertexValue:output_type -> master.UploadVertexValueResp
	30, // 67: master.Master.UploadStatistics:output_type -> master.UploadStatisticsResp
	34, // 68: master.Master.UploadTPResult:output_type -> master.UploadTPResultResp
	32, // 69: master.Master.SettingGraph:output_type -> master.SettingGraphResp
	55, // [55:70] is the sub-list for method output_type
	40, // [40:55] is the sub-list for method input_type
	40, // [40:40] is the sub-list for extension type_name
	40, // [40:40] is the sub-list for extension extendee
	0,  // [0:40] is the sub-list for field type_name
}

func init() { file_master_proto_init() }
func file_master_proto_init() {
	if File_master_proto != nil {
		return
	}
	file_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_master_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HelloMasterReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HelloMasterResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkerInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoadGraphTaskReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoadGraphTaskResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchLoadPartReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchLoadPartResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoadPartStatusReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoadPartStatusResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoadTaskStatusReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoadTaskStatusResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkerVertexCountReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkerVertexCountResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkerEdgeCountReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkerEdgeCountResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GraphWorker); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGraphWorkersReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGraphWorkersResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputeTaskReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputeTaskResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputeTaskStatusReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputeTaskStatusResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SuperStepReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SuperStepResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VertexValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UploadVertexValueReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UploadVertexValueResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UploadStatisticsReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UploadStatisticsResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SettingGraphReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SettingGraphResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UploadTPResultReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_master_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UploadTPResultResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_master_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   38,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_master_proto_goTypes,
		DependencyIndexes: file_master_proto_depIdxs,
		EnumInfos:         file_master_proto_enumTypes,
		MessageInfos:      file_master_proto_msgTypes,
	}.Build()
	File_master_proto = out.File
	file_master_proto_rawDesc = nil
	file_master_proto_goTypes = nil
	file_master_proto_depIdxs = nil
}
