/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements. See the NOTICE file distributed with this
work for additional information regarding copyright ownership. The ASF
licenses this file to You under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
License for the specific language governing permissions and limitations
under the License.
*/
// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.2.0
// - protoc             v3.21.1
// source: master.proto

package __

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// MasterClient is the client API for Master service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type MasterClient interface {
	SayHelloMaster(ctx context.Context, in *HelloMasterReq, opts ...grpc.CallOption) (*HelloMasterResp, error)
	LoadGraphTask(ctx context.Context, opts ...grpc.CallOption) (Master_LoadGraphTaskClient, error)
	ComputeTask(ctx context.Context, opts ...grpc.CallOption) (Master_ComputeTaskClient, error)
	SuperStep(ctx context.Context, in *SuperStepReq, opts ...grpc.CallOption) (Master_SuperStepClient, error)
	FetchLoadPart(ctx context.Context, in *FetchLoadPartReq, opts ...grpc.CallOption) (*FetchLoadPartResp, error)
	LoadPartStatus(ctx context.Context, in *LoadPartStatusReq, opts ...grpc.CallOption) (*LoadPartStatusResp, error)
	WorkVertexCount(ctx context.Context, in *WorkerVertexCountReq, opts ...grpc.CallOption) (*WorkerVertexCountResp, error)
	WorkEdgeCount(ctx context.Context, in *WorkerEdgeCountReq, opts ...grpc.CallOption) (*WorkerEdgeCountResp, error)
	GetGraphWorkers(ctx context.Context, in *GetGraphWorkersReq, opts ...grpc.CallOption) (*GetGraphWorkersResp, error)
	LoadTaskStatus(ctx context.Context, in *LoadTaskStatusReq, opts ...grpc.CallOption) (*LoadTaskStatusResp, error)
	ComputeTaskStatus(ctx context.Context, in *ComputeTaskStatusReq, opts ...grpc.CallOption) (*ComputeTaskStatusResp, error)
	UploadVertexValue(ctx context.Context, in *UploadVertexValueReq, opts ...grpc.CallOption) (*UploadVertexValueResp, error)
	UploadStatistics(ctx context.Context, in *UploadStatisticsReq, opts ...grpc.CallOption) (*UploadStatisticsResp, error)
	UploadTPResult(ctx context.Context, in *UploadTPResultReq, opts ...grpc.CallOption) (*UploadTPResultResp, error)
	SettingGraph(ctx context.Context, in *SettingGraphReq, opts ...grpc.CallOption) (*SettingGraphResp, error)
}

type masterClient struct {
	cc grpc.ClientConnInterface
}

func NewMasterClient(cc grpc.ClientConnInterface) MasterClient {
	return &masterClient{cc}
}

func (c *masterClient) SayHelloMaster(ctx context.Context, in *HelloMasterReq, opts ...grpc.CallOption) (*HelloMasterResp, error) {
	out := new(HelloMasterResp)
	err := c.cc.Invoke(ctx, "/master.Master/SayHelloMaster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *masterClient) LoadGraphTask(ctx context.Context, opts ...grpc.CallOption) (Master_LoadGraphTaskClient, error) {
	stream, err := c.cc.NewStream(ctx, &Master_ServiceDesc.Streams[0], "/master.Master/LoadGraphTask", opts...)
	if err != nil {
		return nil, err
	}
	x := &masterLoadGraphTaskClient{stream}
	return x, nil
}

type Master_LoadGraphTaskClient interface {
	Send(*LoadGraphTaskReq) error
	Recv() (*LoadGraphTaskResp, error)
	grpc.ClientStream
}

type masterLoadGraphTaskClient struct {
	grpc.ClientStream
}

func (x *masterLoadGraphTaskClient) Send(m *LoadGraphTaskReq) error {
	return x.ClientStream.SendMsg(m)
}

func (x *masterLoadGraphTaskClient) Recv() (*LoadGraphTaskResp, error) {
	m := new(LoadGraphTaskResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *masterClient) ComputeTask(ctx context.Context, opts ...grpc.CallOption) (Master_ComputeTaskClient, error) {
	stream, err := c.cc.NewStream(ctx, &Master_ServiceDesc.Streams[1], "/master.Master/ComputeTask", opts...)
	if err != nil {
		return nil, err
	}
	x := &masterComputeTaskClient{stream}
	return x, nil
}

type Master_ComputeTaskClient interface {
	Send(*ComputeTaskReq) error
	Recv() (*ComputeTaskResp, error)
	grpc.ClientStream
}

type masterComputeTaskClient struct {
	grpc.ClientStream
}

func (x *masterComputeTaskClient) Send(m *ComputeTaskReq) error {
	return x.ClientStream.SendMsg(m)
}

func (x *masterComputeTaskClient) Recv() (*ComputeTaskResp, error) {
	m := new(ComputeTaskResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *masterClient) SuperStep(ctx context.Context, in *SuperStepReq, opts ...grpc.CallOption) (Master_SuperStepClient, error) {
	stream, err := c.cc.NewStream(ctx, &Master_ServiceDesc.Streams[2], "/master.Master/SuperStep", opts...)
	if err != nil {
		return nil, err
	}
	x := &masterSuperStepClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Master_SuperStepClient interface {
	Recv() (*SuperStepResp, error)
	grpc.ClientStream
}

type masterSuperStepClient struct {
	grpc.ClientStream
}

func (x *masterSuperStepClient) Recv() (*SuperStepResp, error) {
	m := new(SuperStepResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *masterClient) FetchLoadPart(ctx context.Context, in *FetchLoadPartReq, opts ...grpc.CallOption) (*FetchLoadPartResp, error) {
	out := new(FetchLoadPartResp)
	err := c.cc.Invoke(ctx, "/master.Master/FetchLoadPart", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *masterClient) LoadPartStatus(ctx context.Context, in *LoadPartStatusReq, opts ...grpc.CallOption) (*LoadPartStatusResp, error) {
	out := new(LoadPartStatusResp)
	err := c.cc.Invoke(ctx, "/master.Master/LoadPartStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *masterClient) WorkVertexCount(ctx context.Context, in *WorkerVertexCountReq, opts ...grpc.CallOption) (*WorkerVertexCountResp, error) {
	out := new(WorkerVertexCountResp)
	err := c.cc.Invoke(ctx, "/master.Master/WorkVertexCount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *masterClient) WorkEdgeCount(ctx context.Context, in *WorkerEdgeCountReq, opts ...grpc.CallOption) (*WorkerEdgeCountResp, error) {
	out := new(WorkerEdgeCountResp)
	err := c.cc.Invoke(ctx, "/master.Master/WorkEdgeCount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *masterClient) GetGraphWorkers(ctx context.Context, in *GetGraphWorkersReq, opts ...grpc.CallOption) (*GetGraphWorkersResp, error) {
	out := new(GetGraphWorkersResp)
	err := c.cc.Invoke(ctx, "/master.Master/GetGraphWorkers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *masterClient) LoadTaskStatus(ctx context.Context, in *LoadTaskStatusReq, opts ...grpc.CallOption) (*LoadTaskStatusResp, error) {
	out := new(LoadTaskStatusResp)
	err := c.cc.Invoke(ctx, "/master.Master/LoadTaskStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *masterClient) ComputeTaskStatus(ctx context.Context, in *ComputeTaskStatusReq, opts ...grpc.CallOption) (*ComputeTaskStatusResp, error) {
	out := new(ComputeTaskStatusResp)
	err := c.cc.Invoke(ctx, "/master.Master/ComputeTaskStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *masterClient) UploadVertexValue(ctx context.Context, in *UploadVertexValueReq, opts ...grpc.CallOption) (*UploadVertexValueResp, error) {
	out := new(UploadVertexValueResp)
	err := c.cc.Invoke(ctx, "/master.Master/UploadVertexValue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *masterClient) UploadStatistics(ctx context.Context, in *UploadStatisticsReq, opts ...grpc.CallOption) (*UploadStatisticsResp, error) {
	out := new(UploadStatisticsResp)
	err := c.cc.Invoke(ctx, "/master.Master/UploadStatistics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *masterClient) UploadTPResult(ctx context.Context, in *UploadTPResultReq, opts ...grpc.CallOption) (*UploadTPResultResp, error) {
	out := new(UploadTPResultResp)
	err := c.cc.Invoke(ctx, "/master.Master/UploadTPResult", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *masterClient) SettingGraph(ctx context.Context, in *SettingGraphReq, opts ...grpc.CallOption) (*SettingGraphResp, error) {
	out := new(SettingGraphResp)
	err := c.cc.Invoke(ctx, "/master.Master/SettingGraph", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MasterServer is the server API for Master service.
// All implementations must embed UnimplementedMasterServer
// for forward compatibility
type MasterServer interface {
	SayHelloMaster(context.Context, *HelloMasterReq) (*HelloMasterResp, error)
	LoadGraphTask(Master_LoadGraphTaskServer) error
	ComputeTask(Master_ComputeTaskServer) error
	SuperStep(*SuperStepReq, Master_SuperStepServer) error
	FetchLoadPart(context.Context, *FetchLoadPartReq) (*FetchLoadPartResp, error)
	LoadPartStatus(context.Context, *LoadPartStatusReq) (*LoadPartStatusResp, error)
	WorkVertexCount(context.Context, *WorkerVertexCountReq) (*WorkerVertexCountResp, error)
	WorkEdgeCount(context.Context, *WorkerEdgeCountReq) (*WorkerEdgeCountResp, error)
	GetGraphWorkers(context.Context, *GetGraphWorkersReq) (*GetGraphWorkersResp, error)
	LoadTaskStatus(context.Context, *LoadTaskStatusReq) (*LoadTaskStatusResp, error)
	ComputeTaskStatus(context.Context, *ComputeTaskStatusReq) (*ComputeTaskStatusResp, error)
	UploadVertexValue(context.Context, *UploadVertexValueReq) (*UploadVertexValueResp, error)
	UploadStatistics(context.Context, *UploadStatisticsReq) (*UploadStatisticsResp, error)
	UploadTPResult(context.Context, *UploadTPResultReq) (*UploadTPResultResp, error)
	SettingGraph(context.Context, *SettingGraphReq) (*SettingGraphResp, error)
	mustEmbedUnimplementedMasterServer()
}

// UnimplementedMasterServer must be embedded to have forward compatible implementations.
type UnimplementedMasterServer struct {
}

func (UnimplementedMasterServer) SayHelloMaster(context.Context, *HelloMasterReq) (*HelloMasterResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SayHelloMaster not implemented")
}
func (UnimplementedMasterServer) LoadGraphTask(Master_LoadGraphTaskServer) error {
	return status.Errorf(codes.Unimplemented, "method LoadGraphTask not implemented")
}
func (UnimplementedMasterServer) ComputeTask(Master_ComputeTaskServer) error {
	return status.Errorf(codes.Unimplemented, "method ComputeTask not implemented")
}
func (UnimplementedMasterServer) SuperStep(*SuperStepReq, Master_SuperStepServer) error {
	return status.Errorf(codes.Unimplemented, "method SuperStep not implemented")
}
func (UnimplementedMasterServer) FetchLoadPart(context.Context, *FetchLoadPartReq) (*FetchLoadPartResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchLoadPart not implemented")
}
func (UnimplementedMasterServer) LoadPartStatus(context.Context, *LoadPartStatusReq) (*LoadPartStatusResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LoadPartStatus not implemented")
}
func (UnimplementedMasterServer) WorkVertexCount(context.Context, *WorkerVertexCountReq) (*WorkerVertexCountResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WorkVertexCount not implemented")
}
func (UnimplementedMasterServer) WorkEdgeCount(context.Context, *WorkerEdgeCountReq) (*WorkerEdgeCountResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WorkEdgeCount not implemented")
}
func (UnimplementedMasterServer) GetGraphWorkers(context.Context, *GetGraphWorkersReq) (*GetGraphWorkersResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGraphWorkers not implemented")
}
func (UnimplementedMasterServer) LoadTaskStatus(context.Context, *LoadTaskStatusReq) (*LoadTaskStatusResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LoadTaskStatus not implemented")
}
func (UnimplementedMasterServer) ComputeTaskStatus(context.Context, *ComputeTaskStatusReq) (*ComputeTaskStatusResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ComputeTaskStatus not implemented")
}
func (UnimplementedMasterServer) UploadVertexValue(context.Context, *UploadVertexValueReq) (*UploadVertexValueResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UploadVertexValue not implemented")
}
func (UnimplementedMasterServer) UploadStatistics(context.Context, *UploadStatisticsReq) (*UploadStatisticsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UploadStatistics not implemented")
}
func (UnimplementedMasterServer) UploadTPResult(context.Context, *UploadTPResultReq) (*UploadTPResultResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UploadTPResult not implemented")
}
func (UnimplementedMasterServer) SettingGraph(context.Context, *SettingGraphReq) (*SettingGraphResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SettingGraph not implemented")
}
func (UnimplementedMasterServer) mustEmbedUnimplementedMasterServer() {}

// UnsafeMasterServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to MasterServer will
// result in compilation errors.
type UnsafeMasterServer interface {
	mustEmbedUnimplementedMasterServer()
}

func RegisterMasterServer(s grpc.ServiceRegistrar, srv MasterServer) {
	s.RegisterService(&Master_ServiceDesc, srv)
}

func _Master_SayHelloMaster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HelloMasterReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MasterServer).SayHelloMaster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/master.Master/SayHelloMaster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MasterServer).SayHelloMaster(ctx, req.(*HelloMasterReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Master_LoadGraphTask_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(MasterServer).LoadGraphTask(&masterLoadGraphTaskServer{stream})
}

type Master_LoadGraphTaskServer interface {
	Send(*LoadGraphTaskResp) error
	Recv() (*LoadGraphTaskReq, error)
	grpc.ServerStream
}

type masterLoadGraphTaskServer struct {
	grpc.ServerStream
}

func (x *masterLoadGraphTaskServer) Send(m *LoadGraphTaskResp) error {
	return x.ServerStream.SendMsg(m)
}

func (x *masterLoadGraphTaskServer) Recv() (*LoadGraphTaskReq, error) {
	m := new(LoadGraphTaskReq)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Master_ComputeTask_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(MasterServer).ComputeTask(&masterComputeTaskServer{stream})
}

type Master_ComputeTaskServer interface {
	Send(*ComputeTaskResp) error
	Recv() (*ComputeTaskReq, error)
	grpc.ServerStream
}

type masterComputeTaskServer struct {
	grpc.ServerStream
}

func (x *masterComputeTaskServer) Send(m *ComputeTaskResp) error {
	return x.ServerStream.SendMsg(m)
}

func (x *masterComputeTaskServer) Recv() (*ComputeTaskReq, error) {
	m := new(ComputeTaskReq)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Master_SuperStep_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SuperStepReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(MasterServer).SuperStep(m, &masterSuperStepServer{stream})
}

type Master_SuperStepServer interface {
	Send(*SuperStepResp) error
	grpc.ServerStream
}

type masterSuperStepServer struct {
	grpc.ServerStream
}

func (x *masterSuperStepServer) Send(m *SuperStepResp) error {
	return x.ServerStream.SendMsg(m)
}

func _Master_FetchLoadPart_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchLoadPartReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MasterServer).FetchLoadPart(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/master.Master/FetchLoadPart",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MasterServer).FetchLoadPart(ctx, req.(*FetchLoadPartReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Master_LoadPartStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LoadPartStatusReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MasterServer).LoadPartStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/master.Master/LoadPartStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MasterServer).LoadPartStatus(ctx, req.(*LoadPartStatusReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Master_WorkVertexCount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WorkerVertexCountReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MasterServer).WorkVertexCount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/master.Master/WorkVertexCount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MasterServer).WorkVertexCount(ctx, req.(*WorkerVertexCountReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Master_WorkEdgeCount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WorkerEdgeCountReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MasterServer).WorkEdgeCount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/master.Master/WorkEdgeCount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MasterServer).WorkEdgeCount(ctx, req.(*WorkerEdgeCountReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Master_GetGraphWorkers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGraphWorkersReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MasterServer).GetGraphWorkers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/master.Master/GetGraphWorkers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MasterServer).GetGraphWorkers(ctx, req.(*GetGraphWorkersReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Master_LoadTaskStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LoadTaskStatusReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MasterServer).LoadTaskStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/master.Master/LoadTaskStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MasterServer).LoadTaskStatus(ctx, req.(*LoadTaskStatusReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Master_ComputeTaskStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ComputeTaskStatusReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MasterServer).ComputeTaskStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/master.Master/ComputeTaskStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MasterServer).ComputeTaskStatus(ctx, req.(*ComputeTaskStatusReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Master_UploadVertexValue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UploadVertexValueReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MasterServer).UploadVertexValue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/master.Master/UploadVertexValue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MasterServer).UploadVertexValue(ctx, req.(*UploadVertexValueReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Master_UploadStatistics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UploadStatisticsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MasterServer).UploadStatistics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/master.Master/UploadStatistics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MasterServer).UploadStatistics(ctx, req.(*UploadStatisticsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Master_UploadTPResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UploadTPResultReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MasterServer).UploadTPResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/master.Master/UploadTPResult",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MasterServer).UploadTPResult(ctx, req.(*UploadTPResultReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Master_SettingGraph_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SettingGraphReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MasterServer).SettingGraph(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/master.Master/SettingGraph",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MasterServer).SettingGraph(ctx, req.(*SettingGraphReq))
	}
	return interceptor(ctx, in, info, handler)
}

// Master_ServiceDesc is the grpc.ServiceDesc for Master service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Master_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "master.Master",
	HandlerType: (*MasterServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SayHelloMaster",
			Handler:    _Master_SayHelloMaster_Handler,
		},
		{
			MethodName: "FetchLoadPart",
			Handler:    _Master_FetchLoadPart_Handler,
		},
		{
			MethodName: "LoadPartStatus",
			Handler:    _Master_LoadPartStatus_Handler,
		},
		{
			MethodName: "WorkVertexCount",
			Handler:    _Master_WorkVertexCount_Handler,
		},
		{
			MethodName: "WorkEdgeCount",
			Handler:    _Master_WorkEdgeCount_Handler,
		},
		{
			MethodName: "GetGraphWorkers",
			Handler:    _Master_GetGraphWorkers_Handler,
		},
		{
			MethodName: "LoadTaskStatus",
			Handler:    _Master_LoadTaskStatus_Handler,
		},
		{
			MethodName: "ComputeTaskStatus",
			Handler:    _Master_ComputeTaskStatus_Handler,
		},
		{
			MethodName: "UploadVertexValue",
			Handler:    _Master_UploadVertexValue_Handler,
		},
		{
			MethodName: "UploadStatistics",
			Handler:    _Master_UploadStatistics_Handler,
		},
		{
			MethodName: "UploadTPResult",
			Handler:    _Master_UploadTPResult_Handler,
		},
		{
			MethodName: "SettingGraph",
			Handler:    _Master_SettingGraph_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "LoadGraphTask",
			Handler:       _Master_LoadGraphTask_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "ComputeTask",
			Handler:       _Master_ComputeTask_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "SuperStep",
			Handler:       _Master_SuperStep_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "master.proto",
}
