/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.DataTypeDefinition;
import org.eclipse.milo.opcua.stack.core.types.structured.EnumField;

public class EnumDefinition
extends DataTypeDefinition
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=100");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=123");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=14799");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15067");
    private final EnumField[] fields;

    public EnumDefinition(EnumField[] fields) {
        this.fields = fields;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public EnumField[] getFields() {
        return this.fields;
    }

    protected EnumDefinition(EnumDefinitionBuilder<?, ?> b) {
        super((DataTypeDefinition.DataTypeDefinitionBuilder<?, ?>)b);
        this.fields = ((EnumDefinitionBuilder)b).fields;
    }

    public static EnumDefinitionBuilder<?, ?> builder() {
        return new EnumDefinitionBuilderImpl();
    }

    public EnumDefinitionBuilder<?, ?> toBuilder() {
        return new EnumDefinitionBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnumDefinition)) {
            return false;
        }
        EnumDefinition other = (EnumDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.getFields(), other.getFields());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EnumDefinition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getFields());
        return result;
    }

    @Override
    public String toString() {
        return "EnumDefinition(fields=" + Arrays.deepToString(this.getFields()) + ")";
    }

    private static final class EnumDefinitionBuilderImpl
    extends EnumDefinitionBuilder<EnumDefinition, EnumDefinitionBuilderImpl> {
        private EnumDefinitionBuilderImpl() {
        }

        @Override
        protected EnumDefinitionBuilderImpl self() {
            return this;
        }

        @Override
        public EnumDefinition build() {
            return new EnumDefinition(this);
        }
    }

    public static abstract class EnumDefinitionBuilder<C extends EnumDefinition, B extends EnumDefinitionBuilder<C, B>>
    extends DataTypeDefinition.DataTypeDefinitionBuilder<C, B> {
        private EnumField[] fields;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            EnumDefinitionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(EnumDefinition instance, EnumDefinitionBuilder<?, ?> b) {
            b.fields(instance.fields);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B fields(EnumField[] fields) {
            this.fields = fields;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "EnumDefinition.EnumDefinitionBuilder(super=" + super.toString() + ", fields=" + Arrays.deepToString(this.fields) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<EnumDefinition> {
        @Override
        public Class<EnumDefinition> getType() {
            return EnumDefinition.class;
        }

        @Override
        public EnumDefinition decode(SerializationContext context, UaDecoder decoder) {
            EnumField[] fields = (EnumField[])decoder.readStructArray("Fields", EnumField.TYPE_ID);
            return new EnumDefinition(fields);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, EnumDefinition value) {
            encoder.writeStructArray("Fields", (Object[])value.getFields(), EnumField.TYPE_ID);
        }
    }
}

