/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.websocket;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualTreeBidiMap;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.connector.protocol.websocket.WebSocketConnector;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.tsfile.exception.NotImplementedException;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketConnectorServer
extends WebSocketServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketConnectorServer.class);
    private final AtomicLong eventIdGenerator = new AtomicLong(0L);
    private final ConcurrentHashMap<String, PriorityBlockingQueue<EventWaitingForTransfer>> eventsWaitingForTransfer = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentHashMap<Long, EventWaitingForAck>> eventsWaitingForAck = new ConcurrentHashMap();
    private final BidiMap<String, WebSocket> router = new DualTreeBidiMap<String, WebSocket>(null, Comparator.comparing(Object::hashCode)){};
    private static final AtomicReference<WebSocketConnectorServer> instance = new AtomicReference();
    private static final AtomicBoolean isStarted = new AtomicBoolean(false);

    private WebSocketConnectorServer(int port) {
        super(new InetSocketAddress(port));
        new TransferThread(this).start();
    }

    public static synchronized WebSocketConnectorServer getOrCreateInstance(int port) {
        if (null == instance.get()) {
            instance.set(new WebSocketConnectorServer(port));
        }
        return instance.get();
    }

    public synchronized void register(WebSocketConnector connector) {
        this.eventsWaitingForTransfer.putIfAbsent(connector.getPipeName(), new PriorityBlockingQueue<EventWaitingForTransfer>(11, Comparator.comparing(o -> ((EventWaitingForTransfer)o).eventId)));
        this.eventsWaitingForAck.putIfAbsent(connector.getPipeName(), new ConcurrentHashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unregister(WebSocketConnector connector) {
        String pipeName = connector.getPipeName();
        if (pipeName == null) {
            return;
        }
        if (this.eventsWaitingForTransfer.containsKey(pipeName)) {
            PriorityBlockingQueue<EventWaitingForTransfer> eventTransferQueue = this.eventsWaitingForTransfer.remove(pipeName);
            while (!eventTransferQueue.isEmpty()) {
                eventTransferQueue.forEach(eventWrapper -> {
                    if (((EventWaitingForTransfer)eventWrapper).event instanceof EnrichedEvent) {
                        ((EnrichedEvent)((EventWaitingForTransfer)eventWrapper).event).decreaseReferenceCount(WebSocketConnectorServer.class.getName(), false);
                    }
                });
                eventTransferQueue.clear();
                PriorityBlockingQueue<EventWaitingForTransfer> priorityBlockingQueue = eventTransferQueue;
                synchronized (priorityBlockingQueue) {
                    eventTransferQueue.notifyAll();
                }
            }
        }
        if (this.eventsWaitingForAck.containsKey(pipeName)) {
            this.eventsWaitingForAck.remove(pipeName).forEach((eventId, eventWrapper) -> {
                if (((EventWaitingForAck)eventWrapper).event instanceof EnrichedEvent) {
                    ((EnrichedEvent)((EventWaitingForAck)eventWrapper).event).decreaseReferenceCount(WebSocketConnectorServer.class.getName(), false);
                }
            });
        }
    }

    public void start() {
        super.start();
        isStarted.set(true);
    }

    public void onStart() {
        LOGGER.info("The websocket server {}:{} has been started!", (Object)this.getAddress().getHostName(), (Object)this.getPort());
    }

    public boolean isStarted() {
        return isStarted.get();
    }

    public void onOpen(WebSocket webSocket, ClientHandshake clientHandshake) {
        LOGGER.info("The websocket connection from client {}:{} has been opened!", (Object)webSocket.getRemoteSocketAddress().getHostName(), (Object)webSocket.getRemoteSocketAddress().getPort());
    }

    public void onClose(WebSocket webSocket, int code, String reason, boolean remote) {
        if (webSocket.getRemoteSocketAddress() != null) {
            LOGGER.info("The websocket connection from client {}:{} has been closed! The code is {}. The reason is {}. Is it closed by remote? {}", new Object[]{webSocket.getRemoteSocketAddress().getHostName(), webSocket.getRemoteSocketAddress().getPort(), code, reason, remote});
        } else {
            LOGGER.warn("The websocket connection from client has been closed!The code is {}. The reason is {}. Is it closed by remote? {}", new Object[]{code, reason, remote});
        }
        this.router.remove(this.router.getKey((Object)webSocket));
    }

    public void onMessage(WebSocket webSocket, String s) {
        if (s.startsWith("BIND")) {
            LOGGER.info("Received a bind message from {}:{}", (Object)webSocket.getRemoteSocketAddress().getHostName(), (Object)webSocket.getRemoteSocketAddress().getPort());
            this.handleBind(webSocket, s.replace("BIND:", ""));
        } else if (s.startsWith("ACK")) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Received a ack message from {}:{}", (Object)webSocket.getRemoteSocketAddress().getHostName(), (Object)webSocket.getRemoteSocketAddress().getPort());
            }
            this.handleAck(webSocket, Long.parseLong(s.replace("ACK:", "")));
        } else if (s.startsWith("ERROR")) {
            LOGGER.warn("Received an error message {} from {}:{}", new Object[]{s, webSocket.getRemoteSocketAddress().getHostName(), webSocket.getRemoteSocketAddress().getPort()});
            this.handleError(webSocket, Long.parseLong(s.replace("ERROR:", "")));
        } else {
            LOGGER.warn("Received an unknown message {} from {}:{}", new Object[]{s, webSocket.getRemoteSocketAddress().getHostName(), webSocket.getRemoteSocketAddress().getPort()});
        }
    }

    private void handleBind(WebSocket webSocket, String pipeName) {
        if (this.router.containsKey((Object)pipeName)) {
            this.broadcast("ERROR", Collections.singletonList(webSocket));
            webSocket.close(4000, "Too many connections.");
            return;
        }
        this.broadcast("READY", Collections.singletonList(webSocket));
        this.router.put((Object)pipeName, (Object)webSocket);
    }

    private void handleAck(WebSocket webSocket, long eventId) {
        String pipeName = (String)this.router.getKey((Object)webSocket);
        if (pipeName == null) {
            LOGGER.warn("The websocket connection from {}:{} has been closed, but the ack message of commitId: {} is received.", new Object[]{webSocket.getRemoteSocketAddress().getHostName(), webSocket.getRemoteSocketAddress().getPort(), eventId});
            return;
        }
        ConcurrentHashMap<Long, EventWaitingForAck> eventId2EventMap = this.eventsWaitingForAck.get(pipeName);
        if (eventId2EventMap == null) {
            LOGGER.warn("The pipe {} was dropped so the event ack {} will be ignored.", (Object)pipeName, (Object)eventId);
            return;
        }
        EventWaitingForAck eventWrapper = eventId2EventMap.remove(eventId);
        if (eventWrapper == null) {
            LOGGER.warn("The event ack {} is not found.", (Object)eventId);
            return;
        }
        eventWrapper.connector.commit(eventWrapper.event instanceof EnrichedEvent ? (EnrichedEvent)eventWrapper.event : null);
    }

    private synchronized void handleError(WebSocket webSocket, long eventId) {
        String pipeName = (String)this.router.getKey((Object)webSocket);
        if (pipeName == null) {
            LOGGER.warn("The websocket connection from {}:{} has been closed, but the error message of commitId: {} is received.", new Object[]{webSocket.getRemoteSocketAddress().getHostName(), webSocket.getRemoteSocketAddress().getPort(), eventId});
            return;
        }
        ConcurrentHashMap<Long, EventWaitingForAck> eventId2EventMap = this.eventsWaitingForAck.get(pipeName);
        PriorityBlockingQueue<EventWaitingForTransfer> eventTransferQueue = this.eventsWaitingForTransfer.get(pipeName);
        if (eventId2EventMap == null || eventTransferQueue == null) {
            LOGGER.warn("The pipe {} was dropped so the event in error {} will be ignored.", (Object)pipeName, (Object)eventId);
            return;
        }
        EventWaitingForAck eventWrapper = eventId2EventMap.remove(eventId);
        if (eventWrapper == null) {
            LOGGER.warn("The event in error {} is not found.", (Object)eventId);
            return;
        }
        LOGGER.warn("The tablet of commitId: {} can't be parsed by client, it will be retried later.", (Object)eventId);
        eventTransferQueue.put(new EventWaitingForTransfer(eventId, eventWrapper.connector, eventWrapper.event));
    }

    public void onError(WebSocket webSocket, Exception e) {
        if (webSocket.getRemoteSocketAddress() != null) {
            LOGGER.warn("Got an error \"{}\" from {}:{}.", new Object[]{e.getMessage(), webSocket.getLocalSocketAddress().getHostName(), webSocket.getLocalSocketAddress().getPort(), e});
        } else {
            LOGGER.warn("Got an error \"{}\" from an unknown client.", (Object)e.getMessage(), (Object)e);
            this.router.remove(this.router.getKey((Object)webSocket));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(Event event, WebSocketConnector connector) {
        PriorityBlockingQueue<EventWaitingForTransfer> queue = this.eventsWaitingForTransfer.get(connector.getPipeName());
        if (queue == null) {
            LOGGER.warn("The pipe {} was dropped so the event {} will be dropped.", (Object)connector, (Object)event);
            if (event instanceof EnrichedEvent) {
                ((EnrichedEvent)event).decreaseReferenceCount(WebSocketConnectorServer.class.getName(), false);
            }
            return;
        }
        if (queue.size() >= 5) {
            PriorityBlockingQueue<EventWaitingForTransfer> priorityBlockingQueue = queue;
            synchronized (priorityBlockingQueue) {
                while (queue.size() >= 5) {
                    try {
                        queue.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new PipeException(e.getMessage());
                    }
                }
                queue.put(new EventWaitingForTransfer(this.eventIdGenerator.incrementAndGet(), connector, event));
                return;
            }
        }
        queue.put(new EventWaitingForTransfer(this.eventIdGenerator.incrementAndGet(), connector, event));
    }

    private class TransferThread
    extends Thread {
        private final WebSocketConnectorServer server;

        public TransferThread(WebSocketConnectorServer server) {
            this.server = server;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block5: while (true) {
                if (this.sleepIfNecessary()) {
                    continue;
                }
                var1_1 = WebSocketConnectorServer.access$200(WebSocketConnectorServer.this).keySet().iterator();
                while (true) {
                    if (var1_1.hasNext()) ** break;
                    continue block5;
                    pipeName = (String)var1_1.next();
                    queue = WebSocketConnectorServer.access$200(WebSocketConnectorServer.this).getOrDefault(pipeName, null);
                    if (queue == null || queue.isEmpty() || !WebSocketConnectorServer.access$300(WebSocketConnectorServer.this).containsKey((Object)pipeName)) continue;
                    try {
                        queueElement = (EventWaitingForTransfer)queue.take();
                        var5_6 = queue;
                        synchronized (var5_6) {
                            queue.notifyAll();
                        }
                        this.transfer(pipeName, queueElement);
                        continue;
                    }
                    catch (InterruptedException e) {
                        WebSocketConnectorServer.access$400().warn("The transfer thread is interrupted.", (Throwable)e);
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void transfer(String pipeName, EventWaitingForTransfer element) {
            Long eventId = element.eventId;
            Event event = element.event;
            WebSocketConnector connector = element.connector;
            try {
                if (!(event instanceof PipeRawTabletInsertionEvent)) {
                    throw new NotImplementedException("IoTDBCDCConnector only support PipeInsertNodeTabletInsertionEvent and PipeRawTabletInsertionEvent.");
                }
                ByteBuffer tabletBuffer = ((PipeRawTabletInsertionEvent)event).convertToTablet().serialize();
                if (tabletBuffer == null) {
                    connector.commit((EnrichedEvent)event);
                    return;
                }
                ByteBuffer payload = ByteBuffer.allocate(8 + tabletBuffer.limit());
                payload.putLong(eventId);
                payload.put(tabletBuffer);
                payload.flip();
                this.server.broadcast(payload, Collections.singletonList((WebSocket)WebSocketConnectorServer.this.router.get((Object)pipeName)));
                ConcurrentHashMap eventId2EventMap = (ConcurrentHashMap)WebSocketConnectorServer.this.eventsWaitingForAck.get(pipeName);
                if (eventId2EventMap == null) {
                    LOGGER.warn("The pipe {} was dropped so the event ack {} will be ignored.", (Object)pipeName, (Object)eventId);
                    return;
                }
                eventId2EventMap.put(eventId, new EventWaitingForAck(connector, event));
            }
            catch (Exception e) {
                WebSocketConnectorServer webSocketConnectorServer = this.server;
                synchronized (webSocketConnectorServer) {
                    PriorityBlockingQueue queue = (PriorityBlockingQueue)WebSocketConnectorServer.this.eventsWaitingForTransfer.get(pipeName);
                    if (queue == null) {
                        LOGGER.warn("The pipe {} was dropped so the event {} will be dropped.", (Object)pipeName, (Object)eventId);
                        if (event instanceof EnrichedEvent) {
                            ((EnrichedEvent)event).decreaseReferenceCount(WebSocketConnectorServer.class.getName(), false);
                        }
                        return;
                    }
                    LOGGER.warn("The event {} can't be transferred to client, it will be retried later.", (Object)eventId, (Object)e);
                    queue.put(new EventWaitingForTransfer(eventId, connector, event));
                }
            }
        }

        private boolean sleepIfNecessary() {
            if (!WebSocketConnectorServer.this.eventsWaitingForTransfer.isEmpty()) {
                return false;
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                LOGGER.warn("The transfer thread is interrupted.", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            return true;
        }
    }

    private static class EventWaitingForAck {
        private final WebSocketConnector connector;
        private final Event event;

        public EventWaitingForAck(WebSocketConnector connector, Event event) {
            this.connector = connector;
            this.event = event;
        }
    }

    private static class EventWaitingForTransfer {
        private final Long eventId;
        private final WebSocketConnector connector;
        private final Event event;

        public EventWaitingForTransfer(Long eventId, WebSocketConnector connector, Event event) {
            this.eventId = eventId;
            this.connector = connector;
            this.event = event;
        }
    }
}

