/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.ternary;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.api.YieldableState;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.Transformer;
import org.apache.iotdb.db.queryengine.transformation.dag.util.TypeUtils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;

public abstract class TernaryTransformer
extends Transformer {
    protected final LayerReader firstReader;
    protected final LayerReader secondReader;
    protected final LayerReader thirdReader;
    protected final TSDataType firstReaderDataType;
    protected final TSDataType secondReaderDataType;
    protected final TSDataType thirdReaderDataType;
    protected final boolean isFirstReaderConstant;
    protected final boolean isSecondReaderConstant;
    protected final boolean isThirdReaderConstant;
    protected final boolean isCurrentConstant;
    protected Column[] firstColumns;
    protected Column[] secondColumns;
    protected Column[] thirdColumns;
    protected int firstConsumed;
    protected int secondConsumed;
    protected int thirdConsumed;

    protected TernaryTransformer(LayerReader firstReader, LayerReader secondReader, LayerReader thirdReader) {
        this.firstReader = firstReader;
        this.secondReader = secondReader;
        this.thirdReader = thirdReader;
        this.firstReaderDataType = firstReader.getDataTypes()[0];
        this.secondReaderDataType = secondReader.getDataTypes()[0];
        this.thirdReaderDataType = thirdReader.getDataTypes()[0];
        this.isFirstReaderConstant = firstReader.isConstantPointReader();
        this.isSecondReaderConstant = secondReader.isConstantPointReader();
        this.isThirdReaderConstant = thirdReader.isConstantPointReader();
        this.isCurrentConstant = this.isFirstReaderConstant && this.isSecondReaderConstant && this.isThirdReaderConstant;
        this.checkType();
    }

    @Override
    public YieldableState yieldValue() throws Exception {
        YieldableState state;
        if (this.firstColumns == null) {
            state = this.firstReader.yield();
            if (state != YieldableState.YIELDABLE) {
                return state;
            }
            this.firstColumns = this.firstReader.current();
        }
        if (this.secondColumns == null) {
            state = this.secondReader.yield();
            if (state != YieldableState.YIELDABLE) {
                return state;
            }
            this.secondColumns = this.secondReader.current();
        }
        if (this.thirdColumns == null) {
            state = this.thirdReader.yield();
            if (state != YieldableState.YIELDABLE) {
                return state;
            }
            this.thirdColumns = this.thirdReader.current();
        }
        int firstCount = this.firstColumns[0].getPositionCount();
        int secondCount = this.secondColumns[0].getPositionCount();
        int thirdCount = this.thirdColumns[0].getPositionCount();
        int firstRemains = firstCount - this.firstConsumed;
        int secondRemains = secondCount - this.secondConsumed;
        int thirdRemains = thirdCount - this.thirdConsumed;
        int expectedEntries = Math.min(Math.min(firstRemains, secondRemains), thirdRemains);
        this.cachedColumns = this.mergeAndTransformColumns(expectedEntries);
        return YieldableState.YIELDABLE;
    }

    @Override
    public boolean isConstantPointReader() {
        return this.firstReader.isConstantPointReader() && this.secondReader.isConstantPointReader() && this.thirdReader.isConstantPointReader();
    }

    protected Column[] mergeAndTransformColumns(int count) throws QueryProcessException, IOException {
        TSDataType outputType = this.getDataTypes()[0];
        TimeColumnBuilder timeBuilder = new TimeColumnBuilder(null, count);
        ColumnBuilder valueBuilder = TypeUtils.initColumnBuilder(outputType, count);
        int firstEnd = this.firstColumns[0].getPositionCount();
        int secondEnd = this.secondColumns[0].getPositionCount();
        int thirdEnd = this.thirdColumns[0].getPositionCount();
        while (this.firstConsumed < firstEnd && this.secondConsumed < secondEnd && this.thirdConsumed < thirdEnd) {
            long time = this.findFirstSameTime();
            if (this.firstConsumed >= firstEnd || this.secondConsumed >= secondEnd || this.thirdConsumed >= thirdEnd) continue;
            if (time != Long.MIN_VALUE) {
                timeBuilder.writeLong(time);
                if (this.firstColumns[0].isNull(this.firstConsumed) || this.secondColumns[0].isNull(this.secondConsumed) || this.thirdColumns[0].isNull(this.thirdConsumed)) {
                    valueBuilder.appendNull();
                } else {
                    this.transformAndCache(this.firstColumns[0], this.firstConsumed, this.secondColumns[0], this.secondConsumed, this.thirdColumns[0], this.thirdConsumed, valueBuilder);
                }
            }
            ++this.firstConsumed;
            ++this.secondConsumed;
            ++this.thirdConsumed;
        }
        if (this.firstConsumed == firstEnd) {
            this.firstColumns = null;
            this.firstConsumed = 0;
            this.firstReader.consumedAll();
        }
        if (this.secondConsumed == secondEnd) {
            this.secondColumns = null;
            this.secondConsumed = 0;
            this.secondReader.consumedAll();
        }
        if (this.thirdConsumed == thirdEnd) {
            this.thirdColumns = null;
            this.thirdConsumed = 0;
            this.thirdReader.consumedAll();
        }
        Column times = timeBuilder.build();
        Column values = valueBuilder.build();
        return new Column[]{values, times};
    }

    private long findFirstSameTime() {
        int firstEnd = this.firstColumns[0].getPositionCount();
        int secondEnd = this.secondColumns[0].getPositionCount();
        int thirdEnd = this.thirdColumns[0].getPositionCount();
        long firstTime = this.getTime(this.firstReader, this.firstColumns, this.firstConsumed);
        long secondTime = this.getTime(this.secondReader, this.secondColumns, this.secondConsumed);
        long thirdTime = this.getTime(this.thirdReader, this.thirdColumns, this.thirdConsumed);
        while (firstTime != secondTime || secondTime != thirdTime) {
            if (firstTime < secondTime) {
                if (this.isFirstReaderConstant) {
                    firstTime = secondTime;
                    continue;
                }
                ++this.firstConsumed;
                if (this.firstConsumed >= firstEnd) break;
                firstTime = this.getTime(this.firstReader, this.firstColumns, this.firstConsumed);
                continue;
            }
            if (secondTime < thirdTime) {
                if (this.isSecondReaderConstant) {
                    secondTime = thirdTime;
                    continue;
                }
                ++this.secondConsumed;
                if (this.secondConsumed >= secondEnd) break;
                secondTime = this.getTime(this.secondReader, this.secondColumns, this.secondConsumed);
                continue;
            }
            if (this.isThirdReaderConstant) {
                thirdTime = firstTime;
                continue;
            }
            ++this.thirdConsumed;
            if (this.thirdConsumed >= thirdEnd) break;
            thirdTime = this.getTime(this.thirdReader, this.thirdColumns, this.thirdConsumed);
        }
        return firstTime;
    }

    private long getTime(LayerReader reader, Column[] columns, int index) {
        return reader.isConstantPointReader() ? Long.MIN_VALUE : columns[1].getLong(index);
    }

    protected abstract void transformAndCache(Column var1, int var2, Column var3, int var4, Column var5, int var6, ColumnBuilder var7) throws QueryProcessException, IOException;

    protected abstract void checkType();
}

