/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.active;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveLoadFailedMessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveLoadFailedMessageHandler.class);
    private static final Map<String, ExceptionMessageHandler> EXCEPTION_MESSAGE_HANDLER_MAP = Collections.unmodifiableMap(new HashMap<String, ExceptionMessageHandler>(){
        {
            this.put("memory", filePair -> LOGGER.info("Rejecting auto load tsfile {} (isGeneratedByPipe = {}) due to memory constraints, will retry later.", filePair.getLeft(), filePair.getRight()));
            this.put("read only", filePair -> LOGGER.info("Rejecting auto load tsfile {} (isGeneratedByPipe = {}) due to the system is read only, will retry later.", filePair.getLeft(), filePair.getRight()));
            this.put("procedure return", filePair -> LOGGER.info("Rejecting auto load tsfile {} (isGeneratedByPipe = {}) due to time out to wait for procedure return, will retry later.", filePair.getLeft(), filePair.getRight()));
            this.put("not enough", filePair -> LOGGER.info("Rejecting auto load tsfile {} (isGeneratedByPipe = {}) due to the datanode is not enough, will retry later.", filePair.getLeft(), filePair.getRight()));
            this.put("any config node", filePair -> LOGGER.info("Rejecting auto load tsfile {} (isGeneratedByPipe = {}) due to fail to connect to any config node, will retry later.", filePair.getLeft(), filePair.getRight()));
            this.put("query is time out", filePair -> LOGGER.info("Rejecting auto load tsfile {} (isGeneratedByPipe = {}) due to current query is time out, will retry later.", filePair.getLeft(), filePair.getRight()));
        }
    });

    public static boolean isExceptionMessageShouldRetry(Pair<String, Boolean> filePair, String message) {
        if (CommonDescriptor.getInstance().getConfig().isReadOnly()) {
            EXCEPTION_MESSAGE_HANDLER_MAP.get("read only").handle(filePair);
            return true;
        }
        for (String key : EXCEPTION_MESSAGE_HANDLER_MAP.keySet()) {
            if (message == null || !message.contains(key)) continue;
            EXCEPTION_MESSAGE_HANDLER_MAP.get(key).handle(filePair);
            return true;
        }
        return false;
    }

    @FunctionalInterface
    private static interface ExceptionMessageHandler {
        public void handle(Pair<String, Boolean> var1);
    }
}

