/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.services;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import org.eclipse.milo.opcua.sdk.server.DiagnosticsContext;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.api.services.ViewServices;
import org.eclipse.milo.opcua.sdk.server.services.ServiceAttributes;
import org.eclipse.milo.opcua.sdk.server.services.ServiceCounter;
import org.eclipse.milo.opcua.sdk.server.services.helpers.BrowseHelper;
import org.eclipse.milo.opcua.sdk.server.services.helpers.BrowsePathsHelper;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.RegisterNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RegisterNodesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.UnregisterNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.UnregisterNodesResponse;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.server.services.ServiceRequest;
import org.eclipse.milo.opcua.stack.server.services.ViewServiceSet;

public class DefaultViewServiceSet
implements ViewServiceSet {
    private final ServiceCounter browseCounter = new ServiceCounter();
    private final ServiceCounter browseNextCounter = new ServiceCounter();
    private final ServiceCounter translateBrowsePathsCounter = new ServiceCounter();
    private final BrowseHelper browseHelper;

    public DefaultViewServiceSet(ExecutorService executor) {
        this.browseHelper = new BrowseHelper(executor);
    }

    public void onBrowse(ServiceRequest service) {
        this.browseCounter.record(service);
        BrowseRequest request = (BrowseRequest)service.getRequest();
        DiagnosticsContext diagnosticsContext = new DiagnosticsContext();
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = (Session)service.attr(ServiceAttributes.SESSION_KEY).get();
        List nodesToBrowse = ConversionUtil.l((Object[])request.getNodesToBrowse());
        if (nodesToBrowse.isEmpty()) {
            service.setServiceFault(0x800F0000L);
            return;
        }
        if (nodesToBrowse.size() > server.getConfig().getLimits().getMaxNodesPerBrowse().intValue()) {
            service.setServiceFault(0x80100000L);
            return;
        }
        if (request.getView().getViewId().isNotNull() && !server.getRegisteredViews().contains(request.getView().getViewId())) {
            service.setServiceFault(2154496000L);
            return;
        }
        Stream<CompletableFuture> futures = nodesToBrowse.stream().map(browseDescription -> this.browseHelper.browse(() -> Optional.of(session), server, request.getView(), request.getRequestedMaxReferencesPerNode(), (BrowseDescription)browseDescription));
        FutureUtils.sequence(futures).thenAccept(results -> {
            ResponseHeader header = service.createResponseHeader();
            DiagnosticInfo[] diagnosticInfos = diagnosticsContext.getDiagnosticInfos(nodesToBrowse);
            BrowseResponse response = new BrowseResponse(header, (BrowseResult[])ConversionUtil.a((List)results, BrowseResult.class), diagnosticInfos);
            service.setResponse((UaResponseMessage)response);
        });
    }

    public void onBrowseNext(ServiceRequest service) {
        this.browseNextCounter.record(service);
        this.browseHelper.browseNext(service);
    }

    public void onTranslateBrowsePaths(ServiceRequest service) {
        this.translateBrowsePathsCounter.record(service);
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = (Session)service.attr(ServiceAttributes.SESSION_KEY).get();
        BrowsePathsHelper browsePathsHelper = new BrowsePathsHelper(() -> Optional.ofNullable(session), server);
        browsePathsHelper.onTranslateBrowsePaths(service);
    }

    public void onRegisterNodes(ServiceRequest service) throws UaException {
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = (Session)service.attr(ServiceAttributes.SESSION_KEY).get();
        RegisterNodesRequest request = (RegisterNodesRequest)service.getRequest();
        List nodeIds = ConversionUtil.l((Object[])request.getNodesToRegister());
        if (nodeIds.isEmpty()) {
            throw new UaException(0x800F0000L);
        }
        if (nodeIds.size() > server.getConfig().getLimits().getMaxNodesPerRegisterNodes().intValue()) {
            throw new UaException(0x80100000L);
        }
        ViewServices.RegisterNodesContext context = new ViewServices.RegisterNodesContext(server, session);
        server.getAddressSpaceManager().registerNodes(context, nodeIds);
        context.getFuture().thenAccept(registeredNodeIds -> {
            ResponseHeader header = service.createResponseHeader();
            RegisterNodesResponse response = new RegisterNodesResponse(header, registeredNodeIds.toArray(new NodeId[0]));
            service.setResponse((UaResponseMessage)response);
        });
    }

    public void onUnregisterNodes(ServiceRequest service) throws UaException {
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = (Session)service.attr(ServiceAttributes.SESSION_KEY).get();
        UnregisterNodesRequest request = (UnregisterNodesRequest)service.getRequest();
        List nodeIds = ConversionUtil.l((Object[])request.getNodesToUnregister());
        if (nodeIds.isEmpty()) {
            throw new UaException(0x800F0000L);
        }
        if (nodeIds.size() > server.getConfig().getLimits().getMaxNodesPerRegisterNodes().intValue()) {
            throw new UaException(0x80100000L);
        }
        ViewServices.UnregisterNodesContext context = new ViewServices.UnregisterNodesContext(server, session);
        server.getAddressSpaceManager().unregisterNodes(context, nodeIds);
        context.getFuture().thenAccept(registeredNodeIds -> {
            ResponseHeader header = service.createResponseHeader();
            UnregisterNodesResponse response = new UnregisterNodesResponse(header);
            service.setResponse((UaResponseMessage)response);
        });
    }
}

