/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker.subscriptions;

import io.moquette.broker.subscriptions.CNode;
import io.moquette.broker.subscriptions.DumpTreeVisitor;
import io.moquette.broker.subscriptions.INode;
import io.moquette.broker.subscriptions.ShareName;
import io.moquette.broker.subscriptions.SharedSubscription;
import io.moquette.broker.subscriptions.Subscription;
import io.moquette.broker.subscriptions.SubscriptionCounterVisitor;
import io.moquette.broker.subscriptions.SubscriptionIdentifier;
import io.moquette.broker.subscriptions.TNode;
import io.moquette.broker.subscriptions.Token;
import io.moquette.broker.subscriptions.Topic;
import io.netty.handler.codec.mqtt.MqttSubscriptionOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class CTrie {
    private static final Token ROOT = new Token("root");
    private static final INode NO_PARENT = null;
    INode root;

    CTrie() {
        CNode mainNode = new CNode(ROOT);
        this.root = new INode(mainNode);
    }

    Optional<CNode> lookup(Topic topic) {
        Optional<INode> child;
        INode inode = this.root;
        Token token = topic.headToken();
        while (!topic.isEmpty() && (child = inode.mainNode().childOf(token)).isPresent()) {
            topic = topic.exceptHeadToken();
            inode = child.get();
            token = topic.headToken();
        }
        if (inode == null || !topic.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(inode.mainNode());
    }

    private NavigationAction evaluate(Topic topicName, CNode cnode, int depth) {
        boolean isFirstLevel;
        boolean bl = isFirstLevel = depth == 1;
        if (Token.MULTI.equals(cnode.getToken())) {
            Token token = topicName.headToken();
            if (token != null && token.isReserved() && isFirstLevel) {
                return NavigationAction.STOP;
            }
            return NavigationAction.MATCH;
        }
        if (topicName.isEmpty()) {
            return NavigationAction.STOP;
        }
        Token token = topicName.headToken();
        if (Token.SINGLE.equals(cnode.getToken()) || cnode.getToken().equals(token) || ROOT.equals(cnode.getToken())) {
            if (Token.SINGLE.equals(cnode.getToken()) && token.isReserved() && isFirstLevel) {
                return NavigationAction.STOP;
            }
            return NavigationAction.GODEEP;
        }
        return NavigationAction.STOP;
    }

    public List<Subscription> recursiveMatch(Topic topicName) {
        return this.recursiveMatch(topicName, this.root, 0);
    }

    private List<Subscription> recursiveMatch(Topic topicName, INode inode, int depth) {
        CNode cnode = inode.mainNode();
        if (cnode instanceof TNode) {
            return Collections.emptyList();
        }
        NavigationAction action = this.evaluate(topicName, cnode, depth);
        if (action == NavigationAction.MATCH) {
            return cnode.sharedAndNonSharedSubscriptions();
        }
        if (action == NavigationAction.STOP) {
            return Collections.emptyList();
        }
        Topic remainingTopic = ROOT.equals(cnode.getToken()) ? topicName : topicName.exceptHeadToken();
        ArrayList<Subscription> subscriptions = new ArrayList<Subscription>();
        Optional<INode> subInode = cnode.childOf(Token.MULTI);
        if (subInode.isPresent()) {
            subscriptions.addAll(this.recursiveMatch(remainingTopic, subInode.get(), depth + 1));
        }
        if ((subInode = cnode.childOf(Token.SINGLE)).isPresent()) {
            subscriptions.addAll(this.recursiveMatch(remainingTopic, subInode.get(), depth + 1));
        }
        if (remainingTopic.isEmpty()) {
            subscriptions.addAll(cnode.sharedAndNonSharedSubscriptions());
        } else {
            subInode = cnode.childOf(remainingTopic.headToken());
            if (subInode.isPresent()) {
                subscriptions.addAll(this.recursiveMatch(remainingTopic, subInode.get(), depth + 1));
            }
        }
        return subscriptions;
    }

    public boolean addToTree(SubscriptionRequest request) {
        Action res;
        while ((res = this.insert(request.getTopicFilter(), this.root, request)) == Action.REPEAT) {
        }
        return res == Action.OK_NEW;
    }

    private Action insert(Topic topic, INode inode, SubscriptionRequest request) {
        Optional<INode> nextInode;
        Token token = topic.headToken();
        CNode cnode = inode.mainNode();
        if (!topic.isEmpty() && (nextInode = cnode.childOf(token)).isPresent()) {
            Topic remainingTopic = topic.exceptHeadToken();
            return this.insert(remainingTopic, nextInode.get(), request);
        }
        if (topic.isEmpty()) {
            return this.insertSubscription(inode, cnode, request);
        }
        return this.createNodeAndInsertSubscription(topic, inode, cnode, request);
    }

    private Action insertSubscription(INode inode, CNode cnode, SubscriptionRequest newSubscription) {
        CNode updatedCnode = cnode instanceof TNode ? new CNode(cnode.getToken()) : cnode.copy();
        updatedCnode.addSubscription(newSubscription);
        return inode.compareAndSet(cnode, updatedCnode) ? Action.OK : Action.REPEAT;
    }

    private Action createNodeAndInsertSubscription(Topic topic, INode inode, CNode cnode, SubscriptionRequest request) {
        INode newInode = this.createPathRec(topic, request);
        CNode updatedCnode = cnode instanceof TNode ? new CNode(cnode.getToken()) : cnode.copy();
        updatedCnode.add(newInode);
        return inode.compareAndSet(cnode, updatedCnode) ? Action.OK_NEW : Action.REPEAT;
    }

    private INode createPathRec(Topic topic, SubscriptionRequest request) {
        Topic remainingTopic = topic.exceptHeadToken();
        if (!remainingTopic.isEmpty()) {
            INode inode = this.createPathRec(remainingTopic, request);
            CNode cnode = new CNode(topic.headToken());
            cnode.add(inode);
            return new INode(cnode);
        }
        return this.createLeafNodes(topic.headToken(), request);
    }

    private INode createLeafNodes(Token token, SubscriptionRequest request) {
        CNode newLeafCnode = new CNode(token);
        newLeafCnode.addSubscription(request);
        return new INode(newLeafCnode);
    }

    public void removeFromTree(UnsubscribeRequest request) {
        Action res;
        while ((res = this.remove(request.getClientId(), request.getTopicFilter(), this.root, NO_PARENT, request)) == Action.REPEAT) {
        }
    }

    private Action remove(String clientId, Topic topic, INode inode, INode iParent, UnsubscribeRequest request) {
        Optional<INode> nextInode;
        Token token = topic.headToken();
        CNode cnode = inode.mainNode();
        if (!topic.isEmpty() && (nextInode = cnode.childOf(token)).isPresent()) {
            Topic remainingTopic = topic.exceptHeadToken();
            return this.remove(clientId, remainingTopic, nextInode.get(), inode, request);
        }
        if (cnode instanceof TNode) {
            return this.cleanTomb(inode, iParent);
        }
        if (cnode.containsOnly(clientId) && topic.isEmpty() && cnode.allChildren().isEmpty()) {
            if (inode == this.root) {
                return inode.compareAndSet(cnode, inode.mainNode().copy()) ? Action.OK : Action.REPEAT;
            }
            TNode tnode = new TNode(cnode.getToken());
            return inode.compareAndSet(cnode, tnode) ? this.cleanTomb(inode, iParent) : Action.REPEAT;
        }
        if (cnode.contains(clientId) && topic.isEmpty()) {
            CNode updatedCnode = cnode.copy();
            updatedCnode.removeSubscriptionsFor(request);
            return inode.compareAndSet(cnode, updatedCnode) ? Action.OK : Action.REPEAT;
        }
        return Action.OK;
    }

    private Action cleanTomb(INode inode, INode iParent) {
        CNode origCnode = iParent.mainNode();
        CNode updatedCnode = origCnode.copy();
        INode removed = updatedCnode.remove(inode);
        if (removed == inode) {
            return iParent.compareAndSet(origCnode, updatedCnode) ? Action.OK : Action.REPEAT;
        }
        return Action.OK;
    }

    public int size() {
        SubscriptionCounterVisitor visitor = new SubscriptionCounterVisitor();
        this.dfsVisit(this.root, visitor, 0);
        return visitor.getResult();
    }

    public String dumpTree() {
        DumpTreeVisitor visitor = new DumpTreeVisitor();
        this.dfsVisit(this.root, visitor, 0);
        return visitor.getResult();
    }

    private void dfsVisit(INode node, IVisitor<?> visitor, int deep) {
        if (node == null) {
            return;
        }
        visitor.visit(node.mainNode(), deep);
        ++deep;
        for (INode child : node.mainNode().allChildren()) {
            this.dfsVisit(child, visitor, deep);
        }
    }

    static enum NavigationAction {
        MATCH,
        GODEEP,
        STOP;

    }

    private static enum Action {
        OK,
        REPEAT,
        OK_NEW;

    }

    static interface IVisitor<T> {
        public void visit(CNode var1, int var2);

        public T getResult();
    }

    public static final class UnsubscribeRequest {
        private final Topic topicFilter;
        private final String clientId;
        private boolean shared = false;
        private ShareName shareName;

        private UnsubscribeRequest(String clientId, Topic topicFilter) {
            this.topicFilter = topicFilter;
            this.clientId = clientId;
        }

        public static UnsubscribeRequest buildNonShared(String clientId, Topic topicFilter) {
            return new UnsubscribeRequest(clientId, topicFilter);
        }

        public static UnsubscribeRequest buildShared(ShareName shareName, Topic topicFilter, String clientId) {
            if (topicFilter.headToken().name().startsWith("$share")) {
                throw new IllegalArgumentException("Topic filter of a shared subscription can't contains $share and share name");
            }
            UnsubscribeRequest request = new UnsubscribeRequest(clientId, topicFilter);
            request.shared = true;
            request.shareName = shareName;
            return request;
        }

        public Topic getTopicFilter() {
            return this.topicFilter;
        }

        public boolean isShared() {
            return this.shared;
        }

        public ShareName getSharedName() {
            return this.shareName;
        }

        public String getClientId() {
            return this.clientId;
        }
    }

    public static final class SubscriptionRequest {
        private final Topic topicFilter;
        private final String clientId;
        private final MqttSubscriptionOption option;
        private boolean shared = false;
        private ShareName shareName;
        private Optional<SubscriptionIdentifier> subscriptionIdOpt;

        private SubscriptionRequest(String clientId, Topic topicFilter, MqttSubscriptionOption option, SubscriptionIdentifier subscriptionId) {
            this.topicFilter = topicFilter;
            this.clientId = clientId;
            this.option = option;
            this.subscriptionIdOpt = Optional.of(subscriptionId);
        }

        private SubscriptionRequest(String clientId, Topic topicFilter, MqttSubscriptionOption option) {
            this.topicFilter = topicFilter;
            this.clientId = clientId;
            this.option = option;
            this.subscriptionIdOpt = Optional.empty();
        }

        public static SubscriptionRequest buildNonShared(Subscription subscription) {
            return SubscriptionRequest.buildNonShared(subscription.clientId, subscription.topicFilter, subscription.option());
        }

        public static SubscriptionRequest buildNonShared(String clientId, Topic topicFilter, MqttSubscriptionOption option) {
            return new SubscriptionRequest(clientId, topicFilter, option);
        }

        public static SubscriptionRequest buildNonShared(String clientId, Topic topicFilter, MqttSubscriptionOption option, SubscriptionIdentifier subscriptionId) {
            Objects.requireNonNull(subscriptionId, "SubscriptionId param can't be null");
            return new SubscriptionRequest(clientId, topicFilter, option, subscriptionId);
        }

        public static SubscriptionRequest buildShared(ShareName shareName, Topic topicFilter, String clientId, MqttSubscriptionOption option, SubscriptionIdentifier subscriptionId) {
            Objects.requireNonNull(subscriptionId, "SubscriptionId param can't be null");
            return SubscriptionRequest.buildSharedHelper(shareName, topicFilter, () -> new SubscriptionRequest(clientId, topicFilter, option, subscriptionId));
        }

        public static SubscriptionRequest buildShared(ShareName shareName, Topic topicFilter, String clientId, MqttSubscriptionOption option) {
            return SubscriptionRequest.buildSharedHelper(shareName, topicFilter, () -> SubscriptionRequest.buildNonShared(clientId, topicFilter, option));
        }

        private static SubscriptionRequest buildSharedHelper(ShareName shareName, Topic topicFilter, Supplier<SubscriptionRequest> instantiator) {
            if (topicFilter.headToken().name().startsWith("$share")) {
                throw new IllegalArgumentException("Topic filter of a shared subscription can't contains $share and share name");
            }
            SubscriptionRequest request = instantiator.get();
            request.shared = true;
            request.shareName = shareName;
            return request;
        }

        public Topic getTopicFilter() {
            return this.topicFilter;
        }

        public MqttSubscriptionOption getOption() {
            return this.option;
        }

        public Subscription subscription() {
            return this.subscriptionIdOpt.map(subscriptionIdentifier -> new Subscription(this.clientId, this.topicFilter, this.option, (SubscriptionIdentifier)subscriptionIdentifier)).orElseGet(() -> new Subscription(this.clientId, this.topicFilter, this.option));
        }

        public SharedSubscription sharedSubscription() {
            return this.subscriptionIdOpt.map(subId -> new SharedSubscription(this.shareName, this.topicFilter, this.clientId, this.option, (SubscriptionIdentifier)subId)).orElseGet(() -> new SharedSubscription(this.shareName, this.topicFilter, this.clientId, this.option));
        }

        public boolean isShared() {
            return this.shared;
        }

        public ShareName getSharedName() {
            return this.shareName;
        }

        public String getClientId() {
            return this.clientId;
        }

        public boolean hasSubscriptionIdentifier() {
            return this.subscriptionIdOpt.isPresent();
        }

        public SubscriptionIdentifier getSubscriptionIdentifier() {
            return this.subscriptionIdOpt.get();
        }
    }
}

