/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.protocol.airgap;

import java.io.IOException;
import java.util.HashMap;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.pipe.sink.protocol.IoTDBAirGapSink;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionWritePlanEvent;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferDataNodeHandshakeV1Req;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferDataNodeHandshakeV2Req;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferPlanNodeReq;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;

public abstract class IoTDBDataNodeAirGapSink
extends IoTDBAirGapSink {
    protected boolean mayNeedHandshakeWhenFail() {
        return false;
    }

    protected byte[] generateHandShakeV1Payload() throws IOException {
        return PipeTransferDataNodeHandshakeV1Req.toTPipeTransferBytes(CommonDescriptor.getInstance().getConfig().getTimestampPrecision());
    }

    protected byte[] generateHandShakeV2Payload() throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("clusterID", IoTDBDescriptor.getInstance().getConfig().getClusterId());
        params.put("timestampPrecision", CommonDescriptor.getInstance().getConfig().getTimestampPrecision());
        params.put("convertOnTypeMismatch", Boolean.toString(this.shouldReceiverConvertOnTypeMismatch));
        params.put("loadTsFileStrategy", this.loadTsFileStrategy);
        params.put("username", this.username);
        params.put("password", this.password);
        params.put("validateTsFile", Boolean.toString(this.loadTsFileValidation));
        params.put("markAsPipeRequest", Boolean.toString(this.shouldMarkAsPipeRequest));
        return PipeTransferDataNodeHandshakeV2Req.toTPipeTransferBytes(params);
    }

    protected void doTransferWrapper(IoTDBAirGapSink.AirGapSocket socket, PipeSchemaRegionWritePlanEvent pipeSchemaRegionWritePlanEvent) throws PipeException, IOException {
        if (!pipeSchemaRegionWritePlanEvent.increaseReferenceCount(IoTDBDataNodeAirGapSink.class.getName())) {
            return;
        }
        try {
            this.doTransfer(socket, pipeSchemaRegionWritePlanEvent);
        }
        finally {
            pipeSchemaRegionWritePlanEvent.decreaseReferenceCount(IoTDBDataNodeAirGapSink.class.getName(), false);
        }
    }

    private void doTransfer(IoTDBAirGapSink.AirGapSocket socket, PipeSchemaRegionWritePlanEvent pipeSchemaRegionWritePlanEvent) throws PipeException, IOException {
        if (!this.send(pipeSchemaRegionWritePlanEvent.getPipeName(), pipeSchemaRegionWritePlanEvent.getCreationTime(), socket, PipeTransferPlanNodeReq.toTPipeTransferBytes(pipeSchemaRegionWritePlanEvent.getPlanNode()))) {
            String errorMessage = String.format("Transfer data node write plan %s error. Socket: %s.", new Object[]{pipeSchemaRegionWritePlanEvent.getPlanNode().getType(), socket});
            this.receiverStatusHandler.handle(new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(errorMessage), errorMessage, pipeSchemaRegionWritePlanEvent.toString(), true);
        }
    }
}

