/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import org.apache.iotdb.db.utils.datastructure.TVList;

public class QuickSort {
    protected final TVList tvList;

    public QuickSort(TVList tvList) {
        this.tvList = tvList;
    }

    public int compare(int idx1, int idx2) {
        long t1 = this.tvList.getTime(idx1);
        long t2 = this.tvList.getTime(idx2);
        return Long.compare(t1, t2);
    }

    public void swap(int p, int q) {
        int valueIndexP = this.tvList.getValueIndex(p);
        long timeP = this.tvList.getTime(p);
        int valueIndexQ = this.tvList.getValueIndex(q);
        long timeQ = this.tvList.getTime(q);
        this.tvList.set(p, timeQ, valueIndexQ);
        this.tvList.set(q, timeP, valueIndexP);
    }

    public int partition(int lo, int hi) {
        int pIndex = (lo + hi) / 2;
        int gIndex = lo;
        while (this.compare(gIndex, pIndex) == -1) {
            ++gIndex;
        }
        for (int i = gIndex; i <= hi; ++i) {
            if (this.compare(i, pIndex) != -1) continue;
            this.swap(gIndex, i);
            if (pIndex == gIndex) {
                pIndex = i;
            }
            ++gIndex;
        }
        if (gIndex != pIndex) {
            this.swap(gIndex, pIndex);
            pIndex = gIndex;
        }
        return pIndex;
    }

    public void qsort(int lo, int hi) {
        if (lo < hi) {
            int pivotIndex = this.partition(lo, hi);
            this.qsort(lo, pivotIndex - 1);
            this.qsort(pivotIndex + 1, hi);
        }
    }
}

