/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.twostage.combiner;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.processor.twostage.combiner.PipeCombineHandler;
import org.apache.iotdb.db.pipe.processor.twostage.exchange.payload.CombineRequest;
import org.apache.iotdb.db.pipe.processor.twostage.exchange.payload.FetchCombineResultRequest;
import org.apache.iotdb.db.pipe.processor.twostage.exchange.payload.FetchCombineResultResponse;
import org.apache.iotdb.db.pipe.processor.twostage.operator.Operator;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeCombineHandlerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeCombineHandlerManager.class);
    private final ConcurrentMap<String, PipeCombineHandler> pipeId2CombineHandler = new ConcurrentHashMap<String, PipeCombineHandler>();
    private final ConcurrentMap<String, AtomicInteger> pipeId2ReferenceCount = new ConcurrentHashMap<String, AtomicInteger>();
    private final ConcurrentMap<String, Object> pipeId2LastCombinedValue = new ConcurrentHashMap<String, Object>();

    public synchronized void register(String pipeName, long creationTime, Function<String, Operator> operatorConstructor) {
        String pipeId = PipeCombineHandlerManager.generatePipeId(pipeName, creationTime);
        this.pipeId2CombineHandler.putIfAbsent(pipeId, new PipeCombineHandler(pipeName, creationTime, operatorConstructor));
        this.pipeId2ReferenceCount.putIfAbsent(pipeId, new AtomicInteger(0));
        ((AtomicInteger)this.pipeId2ReferenceCount.get(pipeId)).incrementAndGet();
    }

    public synchronized void deregister(String pipeName, long creationTime) {
        String pipeId = PipeCombineHandlerManager.generatePipeId(pipeName, creationTime);
        if (this.pipeId2ReferenceCount.containsKey(pipeId) && ((AtomicInteger)this.pipeId2ReferenceCount.get(pipeId)).decrementAndGet() <= 0) {
            this.pipeId2LastCombinedValue.remove(pipeId);
            this.pipeId2ReferenceCount.remove(pipeId);
            try {
                ((PipeCombineHandler)this.pipeId2CombineHandler.remove(pipeId)).close();
            }
            catch (Exception e) {
                LOGGER.warn("Error occurred when closing CombineHandler(id = {})", (Object)pipeId, (Object)e);
            }
        }
    }

    public Object getLastCombinedValue(String pipeName, long creationTime) {
        return this.pipeId2LastCombinedValue.get(PipeCombineHandlerManager.generatePipeId(pipeName, creationTime));
    }

    public void updateLastCombinedValue(String pipeName, long creationTime, Object lastCombinedValue) {
        this.pipeId2LastCombinedValue.put(PipeCombineHandlerManager.generatePipeId(pipeName, creationTime), lastCombinedValue);
    }

    public synchronized Set<Integer> getExpectedDataNodeIdSet(String pipeName, long creationTime) {
        PipeCombineHandler handler = (PipeCombineHandler)this.pipeId2CombineHandler.get(PipeCombineHandlerManager.generatePipeId(pipeName, creationTime));
        return Objects.isNull(handler) ? Collections.emptySet() : handler.getExpectedDataNodeIdSet();
    }

    public TPipeTransferResp handle(CombineRequest combineRequest) {
        String pipeId = PipeCombineHandlerManager.generatePipeId(combineRequest.getPipeName(), combineRequest.getCreationTime());
        PipeCombineHandler handler = (PipeCombineHandler)this.pipeId2CombineHandler.get(pipeId);
        if (Objects.isNull(handler)) {
            throw new PipeException("CombineHandler not found for pipeId = " + pipeId);
        }
        return new TPipeTransferResp().setStatus(handler.combine(combineRequest.getRegionId(), combineRequest.getCombineId(), combineRequest.getState()));
    }

    public FetchCombineResultResponse handle(FetchCombineResultRequest fetchCombineResultRequest) throws IOException {
        String pipeId = PipeCombineHandlerManager.generatePipeId(fetchCombineResultRequest.getPipeName(), fetchCombineResultRequest.getCreationTime());
        PipeCombineHandler handler = (PipeCombineHandler)this.pipeId2CombineHandler.get(pipeId);
        if (Objects.isNull(handler)) {
            throw new PipeException("CombineHandler not found for pipeId = " + pipeId);
        }
        return handler.fetchCombineResult(fetchCombineResultRequest.getCombineIdList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchExpectedRegionIdSetAndCleanOutdatedCombiner() {
        HashMap<String, PipeCombineHandler> pipeId2CombineHandlerSnapshot;
        PipeCombineHandlerManager pipeCombineHandlerManager = this;
        synchronized (pipeCombineHandlerManager) {
            pipeId2CombineHandlerSnapshot = new HashMap<String, PipeCombineHandler>(this.pipeId2CombineHandler);
        }
        pipeId2CombineHandlerSnapshot.forEach((pipeId, handler) -> {
            handler.fetchAndUpdateExpectedRegionId2DataNodeIdMap();
            handler.cleanOutdatedCombiner();
        });
    }

    private static String generatePipeId(String pipeName, long creationTime) {
        return pipeName + "-" + creationTime;
    }

    private PipeCombineHandlerManager() {
        PipeDataNodeAgent.runtime().registerPeriodicalJob("CombineHandlerManager#fetchExpectedRegionIdSetAndCleanOutdatedCombiner", this::fetchExpectedRegionIdSetAndCleanOutdatedCombiner, PipeConfig.getInstance().getTwoStageAggregateDataRegionInfoCacheTimeInMs() / 1000L / 2L);
    }

    public static PipeCombineHandlerManager getInstance() {
        return CombineHandlerManagerHolder.INSTANCE;
    }

    private static class CombineHandlerManagerHolder {
        private static final PipeCombineHandlerManager INSTANCE = new PipeCombineHandlerManager();

        private CombineHandlerManagerHolder() {
        }
    }
}

