/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.iotdb.common.rpc.thrift.Model;
import org.apache.iotdb.commons.auth.entity.User;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.auth.AccessDeniedException;
import org.apache.iotdb.commons.executable.ExecutableManager;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.pipe.agent.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.commons.schema.table.TreeViewSchema;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TimeColumnSchema;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.execution.warnings.WarningCollector;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.CreateFunctionTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.CreatePipePluginTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.DropFunctionTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.DropPipePluginTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.RemoveAINodeTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.RemoveConfigNodeTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.RemoveDataNodeTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowClusterIdTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowClusterTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowFunctionsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowPipePluginsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowRegionTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowVariablesTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ai.CreateModelTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ai.CreateTrainingTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ai.DropModelTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ai.LoadModelTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ai.ShowAIDevicesTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ai.ShowLoadedModelsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ai.ShowModelsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ai.UnloadModelTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.region.ExtendRegionTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.region.MigrateRegionTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.region.ReconstructRegionTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.region.RemoveRegionTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.AlterDBTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.AlterTableAddColumnTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.AlterTableCommentColumnTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.AlterTableCommentTableTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.AlterTableDropColumnTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.AlterTableRenameColumnTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.AlterTableRenameTableTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.AlterTableSetPropertiesTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.ClearCacheTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.CreateDBTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.CreateTableTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.CreateTableViewTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.DeleteDeviceTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.DescribeTableDetailsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.DescribeTableTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.DropDBTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.DropTableTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.RelationalAuthorizerTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.ShowAINodesTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.ShowConfigNodesTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.ShowCreateTableTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.ShowCreateViewTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.ShowDBTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.ShowDataNodesTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.ShowTablesDetailsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.ShowTablesTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.UseDBTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.session.SetSqlDialectTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.session.ShowCurrentDatabaseTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.session.ShowCurrentSqlDialectTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.session.ShowCurrentTimestampTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.session.ShowCurrentUserTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.session.ShowVersionTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.FlushTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.KillQueryTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.LoadConfigurationTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.SetConfigurationTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.SetSystemStatusTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.StartRepairDataTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.StopRepairDataTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.pipe.AlterPipeTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.pipe.CreatePipeTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.pipe.DropPipeTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.pipe.ShowPipeTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.pipe.StartPipeTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.pipe.StopPipeTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.subscription.CreateTopicTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.subscription.DropSubscriptionTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.subscription.DropTopicTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.subscription.ShowSubscriptionsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.subscription.ShowTopicsTask;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analyzer;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.StatementAnalyzerFactory;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.TableHeaderSchemaValidator;
import org.apache.iotdb.db.queryengine.plan.relational.security.AccessControl;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AddColumn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AlterDB;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AlterPipe;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ClearCache;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ColumnDefinition;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateDB;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateFunction;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateModel;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreatePipe;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreatePipePlugin;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateTable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateTopic;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateTraining;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateView;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DataType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DatabaseStatement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DeleteDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DescribeTable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropColumn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropDB;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropFunction;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropModel;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropPipe;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropPipePlugin;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropSubscription;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropTable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropTopic;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ExtendRegion;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Flush;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.KillQuery;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LoadConfiguration;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LoadModel;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.MigrateRegion;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Property;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ReconstructRegion;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RelationalAuthorStatement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RemoveAINode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RemoveConfigNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RemoveDataNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RemoveRegion;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RenameColumn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RenameTable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SetColumnComment;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SetConfiguration;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SetProperties;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SetSqlDialect;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SetSystemStatus;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SetTableComment;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowAIDevices;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowAINodes;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowCluster;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowClusterId;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowConfigNodes;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowCurrentDatabase;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowCurrentSqlDialect;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowCurrentTimestamp;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowCurrentUser;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowDB;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowDataNodes;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowFunctions;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowLoadedModels;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowModels;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowPipePlugins;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowPipes;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowRegions;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowSubscriptions;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowTables;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowTopics;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowVariables;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowVersion;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StartPipe;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StartRepairData;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StopPipe;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StopRepairData;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.UnloadModel;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Use;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ViewFieldDefinition;
import org.apache.iotdb.db.queryengine.plan.relational.sql.rewrite.StatementRewrite;
import org.apache.iotdb.db.queryengine.plan.relational.type.AuthorRType;
import org.apache.iotdb.db.queryengine.plan.relational.type.InternalTypeManager;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeNotFoundException;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeSignatureTranslator;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DatabaseSchemaStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.RemoveAINodeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.RemoveConfigNodeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.RemoveDataNodeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowClusterStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowRegionStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.FlushStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.LoadConfigurationStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.SetConfigurationStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.SetSystemStatusStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.StartRepairDataStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.StopRepairDataStatement;
import org.apache.iotdb.db.utils.DataNodeAuthUtils;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;

public class TableConfigTaskVisitor
extends AstVisitor<IConfigTask, MPPQueryContext> {
    public static final String DATABASE_NOT_SPECIFIED = "database is not specified";
    private final IClientSession clientSession;
    private final Metadata metadata;
    private final AccessControl accessControl;

    public TableConfigTaskVisitor(IClientSession clientSession, Metadata metadata, AccessControl accessControl) {
        this.clientSession = clientSession;
        this.metadata = metadata;
        this.accessControl = accessControl;
    }

    @Override
    protected IConfigTask visitNode(Node node, MPPQueryContext context) {
        throw new UnsupportedOperationException("Unsupported statement type: " + node.getClass().getName());
    }

    @Override
    protected IConfigTask visitCreateDB(CreateDB node, MPPQueryContext context) {
        this.accessControl.checkCanCreateDatabase(context.getSession().getUserName(), node.getDbName());
        return this.visitDatabaseStatement(node, context);
    }

    @Override
    protected IConfigTask visitAlterDB(AlterDB node, MPPQueryContext context) {
        this.accessControl.checkCanAlterDatabase(context.getSession().getUserName(), node.getDbName());
        return this.visitDatabaseStatement(node, context);
    }

    private IConfigTask visitDatabaseStatement(DatabaseStatement node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        TDatabaseSchema schema = new TDatabaseSchema();
        schema.setIsTableModel(true);
        String dbName = node.getDbName();
        TableConfigTaskVisitor.validateDatabaseName(dbName);
        schema.setName(dbName);
        block22: for (Property property : node.getProperties()) {
            String key = property.getName().getValue().toLowerCase(Locale.ENGLISH);
            if (property.isSetToDefault()) {
                switch (key) {
                    case "time_partition_interval": 
                    case "schema_region_group_num": 
                    case "data_region_group_num": {
                        continue block22;
                    }
                    case "ttl": {
                        if (node.getType() != DatabaseSchemaStatement.DatabaseSchemaStatementType.ALTER) continue block22;
                        schema.setTTL(Long.MAX_VALUE);
                        continue block22;
                    }
                }
                throw new SemanticException("Unsupported database property key: " + key);
            }
            Expression value = property.getNonDefaultValue();
            switch (key) {
                case "ttl": {
                    Optional<String> strValue = this.parseStringFromLiteralIfBinary(value);
                    if (strValue.isPresent()) {
                        if (!strValue.get().equalsIgnoreCase("INF")) {
                            throw new SemanticException("ttl value must be 'INF' or a long literal, but now is: " + value);
                        }
                        if (node.getType() != DatabaseSchemaStatement.DatabaseSchemaStatementType.ALTER) continue block22;
                        schema.setTTL(Long.MAX_VALUE);
                        continue block22;
                    }
                    schema.setTTL(this.parseLongFromLiteral(value, "ttl"));
                    continue block22;
                }
                case "time_partition_interval": {
                    schema.setTimePartitionInterval(this.parseLongFromLiteral(value, "time_partition_interval"));
                    continue block22;
                }
                case "schema_region_group_num": {
                    schema.setMinSchemaRegionGroupNum(this.parseIntFromLiteral(value, "schema_region_group_num"));
                    continue block22;
                }
                case "data_region_group_num": {
                    schema.setMinDataRegionGroupNum(this.parseIntFromLiteral(value, "data_region_group_num"));
                    continue block22;
                }
            }
            throw new SemanticException("Unsupported database property key: " + key);
        }
        return node.getType() == DatabaseSchemaStatement.DatabaseSchemaStatementType.CREATE ? new CreateDBTask(schema, node.exists()) : new AlterDBTask(schema, node.exists());
    }

    @Override
    protected IConfigTask visitUse(Use node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkCanShowOrUseDatabase(context.getSession().getUserName(), node.getDatabaseId().getValue());
        return new UseDBTask(node, this.clientSession);
    }

    @Override
    protected IConfigTask visitDropDB(DropDB node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkCanDropDatabase(context.getSession().getUserName(), node.getDbName().getValue());
        return new DropDBTask(node, this.clientSession);
    }

    @Override
    protected IConfigTask visitShowDB(ShowDB node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        return new ShowDBTask(node, databaseName -> TableConfigTaskVisitor.canShowDB(this.accessControl, context.getSession().getUserName(), databaseName));
    }

    public static boolean canShowDB(AccessControl accessControl, String userName, String databaseName) {
        try {
            accessControl.checkCanShowOrUseDatabase(userName, databaseName);
            return true;
        }
        catch (AccessDeniedException e) {
            return false;
        }
    }

    @Override
    protected IConfigTask visitShowCluster(ShowCluster showCluster, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        ShowClusterStatement treeStatement = new ShowClusterStatement();
        treeStatement.setDetails(showCluster.getDetails().orElse(false));
        return new ShowClusterTask(treeStatement);
    }

    @Override
    protected IConfigTask visitShowRegions(ShowRegions showRegions, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        ShowRegionStatement treeStatement = new ShowRegionStatement();
        treeStatement.setRegionType(showRegions.getRegionType());
        treeStatement.setDatabases(Objects.nonNull(showRegions.getDatabase()) ? Collections.singletonList(new PartialPath(new String[]{showRegions.getDatabase()})) : null);
        treeStatement.setNodeIds(showRegions.getNodeIds());
        return new ShowRegionTask(treeStatement, true);
    }

    @Override
    protected IConfigTask visitRemoveDataNode(RemoveDataNode removeDataNode, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        RemoveDataNodeStatement treeStatement = new RemoveDataNodeStatement(removeDataNode.getNodeIds());
        return new RemoveDataNodeTask(treeStatement);
    }

    @Override
    protected IConfigTask visitRemoveConfigNode(RemoveConfigNode removeConfigNode, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        RemoveConfigNodeStatement treeStatement = new RemoveConfigNodeStatement(removeConfigNode.getNodeId());
        return new RemoveConfigNodeTask(treeStatement);
    }

    @Override
    protected IConfigTask visitRemoveAINode(RemoveAINode removeAINode, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new RemoveAINodeTask(new RemoveAINodeStatement());
    }

    @Override
    protected IConfigTask visitShowDataNodes(ShowDataNodes showDataNodesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new ShowDataNodesTask();
    }

    @Override
    protected IConfigTask visitShowConfigNodes(ShowConfigNodes showConfigNodesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new ShowConfigNodesTask();
    }

    @Override
    protected IConfigTask visitShowAINodes(ShowAINodes showAINodesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new ShowAINodesTask();
    }

    @Override
    protected IConfigTask visitClearCache(ClearCache clearCacheStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new ClearCacheTask(clearCacheStatement);
    }

    @Override
    protected IConfigTask visitCreateTable(CreateTable node, MPPQueryContext context) {
        Pair<String, TsTable> databaseTablePair = this.parseTable4CreateTableOrView(node, context);
        return new CreateTableTask((TsTable)databaseTablePair.getRight(), (String)databaseTablePair.getLeft(), node.isIfNotExists());
    }

    @Override
    protected IConfigTask visitCreateView(CreateView node, MPPQueryContext context) {
        Pair<String, TsTable> databaseTablePair = this.parseTable4CreateTableOrView(node, context);
        TsTable table = (TsTable)databaseTablePair.getRight();
        this.accessControl.checkCanCreateViewFromTreePath(context.getSession().getUserName(), node.getPrefixPath());
        String msg = TreeViewSchema.setPathPattern((TsTable)table, (PartialPath)node.getPrefixPath());
        if (Objects.nonNull(msg)) {
            throw new SemanticException(msg);
        }
        if (node.isRestrict()) {
            TreeViewSchema.setRestrict((TsTable)table);
        }
        return new CreateTableViewTask((TsTable)databaseTablePair.getRight(), (String)databaseTablePair.getLeft(), node.isReplace());
    }

    private Pair<String, TsTable> parseTable4CreateTableOrView(CreateTable node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Pair<String, String> databaseTablePair = this.splitQualifiedName(node.getName());
        String database = (String)databaseTablePair.getLeft();
        String tableName = (String)databaseTablePair.getRight();
        this.accessControl.checkCanCreateTable(context.getSession().getUserName(), new QualifiedObjectName(database, tableName));
        TsTable table = new TsTable(tableName);
        table.setProps(this.convertPropertiesToMap(node.getProperties(), false));
        if (Objects.nonNull(node.getComment())) {
            table.addProp("__comment", node.getComment());
        }
        boolean hasTimeColumn = false;
        HashSet<String> sourceNameSet = new HashSet<String>();
        for (ColumnDefinition columnDefinition : node.getElements()) {
            String comment;
            TSDataType dataType;
            String columnName;
            TsTableColumnCategory category = columnDefinition.getColumnCategory();
            if (this.checkTimeColumnIdempotent(category, columnName = columnDefinition.getName().getValue(), dataType = this.getDataType(columnDefinition.getType()), comment = columnDefinition.getComment(), table) && !hasTimeColumn) {
                hasTimeColumn = true;
                continue;
            }
            if (table.getColumnSchema(columnName) != null) {
                throw new SemanticException(String.format("Columns in table shall not share the same name %s.", columnName));
            }
            TsTableColumnSchema schema = TableHeaderSchemaValidator.generateColumnSchema(category, columnName, dataType, comment, columnDefinition instanceof ViewFieldDefinition && Objects.nonNull(((ViewFieldDefinition)columnDefinition).getFrom()) ? ((ViewFieldDefinition)columnDefinition).getFrom().getValue() : null);
            if (!sourceNameSet.add(TreeViewSchema.getSourceName((TsTableColumnSchema)schema))) {
                throw new SemanticException(String.format("The duplicated source measurement %s is unsupported yet.", TreeViewSchema.getSourceName((TsTableColumnSchema)schema)));
            }
            table.addColumnSchema(schema);
        }
        return new Pair((Object)database, (Object)table);
    }

    private boolean checkTimeColumnIdempotent(TsTableColumnCategory category, String columnName, TSDataType dataType, String comment, TsTable table) {
        if (category == TsTableColumnCategory.TIME || columnName.equals("time")) {
            if (category == TsTableColumnCategory.TIME && columnName.equals("time") && dataType == TSDataType.TIMESTAMP) {
                if (Objects.nonNull(comment)) {
                    TimeColumnSchema columnSchema = new TimeColumnSchema("time", TSDataType.TIMESTAMP);
                    columnSchema.getProps().put("__comment", comment);
                    table.addColumnSchema((TsTableColumnSchema)columnSchema);
                }
                return true;
            }
            if (dataType == TSDataType.TIMESTAMP) {
                throw new SemanticException("The time column category shall be bounded with column name 'time'.");
            }
            throw new SemanticException("The time column's type shall be 'timestamp'.");
        }
        return false;
    }

    @Override
    protected IConfigTask visitRenameTable(RenameTable node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Pair<String, String> databaseTablePair = this.splitQualifiedName(node.getSource());
        String database = (String)databaseTablePair.getLeft();
        String tableName = (String)databaseTablePair.getRight();
        this.accessControl.checkCanAlterTable(context.getSession().getUserName(), new QualifiedObjectName(database, tableName));
        String newName = node.getTarget().getValue();
        if (tableName.equals(newName)) {
            throw new SemanticException("The table's old name shall not be equal to the new one.");
        }
        return new AlterTableRenameTableTask(database, tableName, context.getQueryId().getId(), node.getTarget().getValue(), node.tableIfExists(), node.isView());
    }

    @Override
    protected IConfigTask visitAddColumn(AddColumn node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Pair<String, String> databaseTablePair = this.splitQualifiedName(node.getTableName());
        String database = (String)databaseTablePair.getLeft();
        String tableName = (String)databaseTablePair.getRight();
        this.accessControl.checkCanAlterTable(context.getSession().getUserName(), new QualifiedObjectName(database, tableName));
        ColumnDefinition definition = node.getColumn();
        return new AlterTableAddColumnTask(database, tableName, Collections.singletonList(TableHeaderSchemaValidator.generateColumnSchema(definition.getColumnCategory(), definition.getName().getValue(), this.getDataType(definition.getType()), definition.getComment(), definition instanceof ViewFieldDefinition && Objects.nonNull(((ViewFieldDefinition)definition).getFrom()) ? ((ViewFieldDefinition)definition).getFrom().getValue() : null)), context.getQueryId().getId(), node.tableIfExists(), node.columnIfNotExists(), node.isView());
    }

    @Override
    protected IConfigTask visitRenameColumn(RenameColumn node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Pair<String, String> databaseTablePair = this.splitQualifiedName(node.getTable());
        String database = (String)databaseTablePair.getLeft();
        String tableName = (String)databaseTablePair.getRight();
        this.accessControl.checkCanAlterTable(context.getSession().getUserName(), new QualifiedObjectName(database, tableName));
        String oldName = node.getSource().getValue();
        String newName = node.getTarget().getValue();
        if (oldName.equals(newName)) {
            throw new SemanticException("The column's old name shall not be equal to the new one.");
        }
        return new AlterTableRenameColumnTask(database, tableName, node.getSource().getValue(), node.getTarget().getValue(), context.getQueryId().getId(), node.tableIfExists(), node.columnIfExists(), node.isView());
    }

    @Override
    protected IConfigTask visitDropColumn(DropColumn node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Pair<String, String> databaseTablePair = this.splitQualifiedName(node.getTable());
        String database = (String)databaseTablePair.getLeft();
        String tableName = (String)databaseTablePair.getRight();
        this.accessControl.checkCanAlterTable(context.getSession().getUserName(), new QualifiedObjectName(database, tableName));
        return new AlterTableDropColumnTask(database, tableName, node.getField().getValue(), context.getQueryId().getId(), node.tableIfExists(), node.columnIfExists(), node.isView());
    }

    @Override
    protected IConfigTask visitSetProperties(SetProperties node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Pair<String, String> databaseTablePair = this.splitQualifiedName(node.getName());
        String database = (String)databaseTablePair.getLeft();
        String tableName = (String)databaseTablePair.getRight();
        this.accessControl.checkCanAlterTable(context.getSession().getUserName(), new QualifiedObjectName(database, tableName));
        return new AlterTableSetPropertiesTask(database, tableName, this.convertPropertiesToMap(node.getProperties(), true), context.getQueryId().getId(), node.ifExists(), node.getType() == SetProperties.Type.TREE_VIEW);
    }

    @Override
    protected IConfigTask visitSetTableComment(SetTableComment node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Pair<String, String> databaseTablePair = this.splitQualifiedName(node.getTableName());
        String database = (String)databaseTablePair.getLeft();
        String tableName = (String)databaseTablePair.getRight();
        this.accessControl.checkCanAlterTable(context.getSession().getUserName(), new QualifiedObjectName(database, tableName));
        return new AlterTableCommentTableTask(database, tableName, context.getQueryId().getId(), node.ifExists(), node.getComment(), node.isView());
    }

    @Override
    protected IConfigTask visitSetColumnComment(SetColumnComment node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Pair<String, String> databaseTablePair = this.splitQualifiedName(node.getTable());
        String database = (String)databaseTablePair.getLeft();
        String tableName = (String)databaseTablePair.getRight();
        this.accessControl.checkCanAlterTable(context.getSession().getUserName(), new QualifiedObjectName(database, tableName));
        return new AlterTableCommentColumnTask(database, tableName, node.getField().getValue(), context.getQueryId().getId(), node.tableIfExists(), node.columnIfExists(), node.getComment());
    }

    public static void validateDatabaseName(String dbName) throws SemanticException {
        if (dbName.contains(".") || !IoTDBConfig.STORAGE_GROUP_PATTERN.matcher(dbName).matches() || dbName.length() > 64) {
            throw new SemanticException(new IllegalPathException(dbName, dbName.length() > 64 ? "the length of database name shall not exceed 64" : "the database name can only contain english or chinese characters, numbers, backticks and underscores."));
        }
    }

    public Pair<String, String> splitQualifiedName(QualifiedName name) {
        String database = this.clientSession.getDatabaseName();
        if (name.getPrefix().isPresent()) {
            database = name.getPrefix().get().toString();
        }
        if (database == null) {
            throw new SemanticException(DATABASE_NOT_SPECIFIED);
        }
        return new Pair((Object)database, (Object)name.getSuffix());
    }

    private Map<String, String> convertPropertiesToMap(List<Property> propertyList, boolean serializeDefault) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Property property : propertyList) {
            String key = property.getName().getValue().toLowerCase(Locale.ENGLISH);
            if (TsTable.TABLE_ALLOWED_PROPERTIES.contains(key)) {
                if (!property.isSetToDefault()) {
                    Expression value = property.getNonDefaultValue();
                    Optional<String> strValue = this.parseStringFromLiteralIfBinary(value);
                    if (strValue.isPresent()) {
                        if (!strValue.get().equalsIgnoreCase("INF")) {
                            throw new SemanticException("ttl value must be 'INF' or a long literal, but now is: " + value);
                        }
                        map.put(key, strValue.get().toUpperCase(Locale.ENGLISH));
                        continue;
                    }
                    map.put(key, String.valueOf(this.parseLongFromLiteral(value, "ttl")));
                    continue;
                }
                if (!serializeDefault) continue;
                map.put(key, null);
                continue;
            }
            throw new SemanticException("Table property '" + key + "' is currently not allowed.");
        }
        return map;
    }

    private TSDataType getDataType(DataType dataType) {
        try {
            return InternalTypeManager.getTSDataType(this.metadata.getType(TypeSignatureTranslator.toTypeSignature(dataType)));
        }
        catch (TypeNotFoundException e) {
            throw new SemanticException(String.format("Unknown type: %s", dataType));
        }
    }

    @Override
    protected IConfigTask visitDropTable(DropTable node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Pair<String, String> databaseTablePair = this.splitQualifiedName(node.getTableName());
        String database = (String)databaseTablePair.getLeft();
        String tableName = (String)databaseTablePair.getRight();
        this.accessControl.checkCanDropTable(context.getSession().getUserName(), new QualifiedObjectName(database, tableName));
        return new DropTableTask(database, tableName, context.getQueryId().getId(), node.isExists(), node.isView());
    }

    @Override
    protected IConfigTask visitDeleteDevice(DeleteDevice node, MPPQueryContext context) {
        new Analyzer(context, context.getSession(), new StatementAnalyzerFactory(this.metadata, null, this.accessControl), Collections.emptyList(), Collections.emptyMap(), StatementRewrite.NOOP, WarningCollector.NOOP).analyze(node);
        this.accessControl.checkCanDeleteFromTable(context.getSession().getUserName(), new QualifiedObjectName(node.getDatabase(), node.getTableName()));
        return new DeleteDeviceTask(node, context.getQueryId().getId(), context.getSession());
    }

    @Override
    protected IConfigTask visitShowTables(ShowTables node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        String database = this.clientSession.getDatabaseName();
        if (node.getDbName().isPresent()) {
            database = node.getDbName().get().getValue();
        }
        if (database == null) {
            throw new SemanticException(DATABASE_NOT_SPECIFIED);
        }
        String finalDatabase = database;
        Predicate<String> checkCanShowTable = tableName -> TableConfigTaskVisitor.canShowTable(this.accessControl, context.getSession().getUserName(), finalDatabase, tableName);
        return node.isDetails() ? new ShowTablesDetailsTask(database, checkCanShowTable) : new ShowTablesTask(database, checkCanShowTable);
    }

    public static boolean canShowTable(AccessControl accessControl, String userName, String databaseName, String tableName) {
        try {
            accessControl.checkCanShowOrDescTable(userName, new QualifiedObjectName(databaseName, tableName));
            return true;
        }
        catch (AccessDeniedException e) {
            return false;
        }
    }

    @Override
    protected IConfigTask visitDescribeTable(DescribeTable node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        Pair<String, String> databaseTablePair = this.splitQualifiedName(node.getTable());
        String database = (String)databaseTablePair.getLeft();
        String tableName = (String)databaseTablePair.getRight();
        this.accessControl.checkCanShowOrDescTable(context.getSession().getUserName(), new QualifiedObjectName(database, tableName));
        if (Boolean.TRUE.equals(node.getShowCreateView())) {
            return new ShowCreateViewTask(database, tableName);
        }
        if (Boolean.FALSE.equals(node.getShowCreateView())) {
            return new ShowCreateTableTask(database, tableName);
        }
        return node.isDetails() ? new DescribeTableDetailsTask(database, tableName) : new DescribeTableTask(database, tableName);
    }

    @Override
    protected IConfigTask visitFlush(Flush node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new FlushTask((FlushStatement)node.getInnerTreeStatement());
    }

    @Override
    protected IConfigTask visitSetConfiguration(SetConfiguration node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new SetConfigurationTask((SetConfigurationStatement)node.getInnerTreeStatement());
    }

    @Override
    protected IConfigTask visitStartRepairData(StartRepairData node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new StartRepairDataTask((StartRepairDataStatement)node.getInnerTreeStatement());
    }

    @Override
    protected IConfigTask visitStopRepairData(StopRepairData node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new StopRepairDataTask((StopRepairDataStatement)node.getInnerTreeStatement());
    }

    @Override
    protected IConfigTask visitLoadConfiguration(LoadConfiguration node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new LoadConfigurationTask((LoadConfigurationStatement)node.getInnerTreeStatement());
    }

    @Override
    protected IConfigTask visitSetSystemStatus(SetSystemStatus node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new SetSystemStatusTask((SetSystemStatusStatement)node.getInnerTreeStatement());
    }

    private Optional<String> parseStringFromLiteralIfBinary(Object value) {
        return value instanceof Literal && ((Literal)value).getTsValue() instanceof Binary ? Optional.of(((Binary)((Literal)value).getTsValue()).getStringValue(TSFileConfig.STRING_CHARSET)) : Optional.empty();
    }

    private long parseLongFromLiteral(Object value, String name) {
        if (!(value instanceof LongLiteral)) {
            throw new SemanticException(name + " value must be a LongLiteral, but now is " + (Objects.nonNull(value) ? value.getClass().getSimpleName() : null) + ", value: " + value);
        }
        long parsedValue = ((LongLiteral)value).getParsedValue();
        if (parsedValue < 0L) {
            throw new SemanticException(name + " value must be equal to or greater than 0, but now is: " + value);
        }
        return parsedValue;
    }

    private int parseIntFromLiteral(Object value, String name) {
        if (!(value instanceof LongLiteral)) {
            throw new SemanticException(name + " value must be a LongLiteral, but now is " + (Objects.nonNull(value) ? value.getClass().getSimpleName() : null) + ", value: " + value);
        }
        long parsedValue = ((LongLiteral)value).getParsedValue();
        if (parsedValue < 0L) {
            throw new SemanticException(name + " value must be equal to or greater than 0, but now is: " + value);
        }
        if (parsedValue > Integer.MAX_VALUE) {
            throw new SemanticException(name + " value must be lower than " + Integer.MAX_VALUE + ", but now is: " + value);
        }
        return (int)parsedValue;
    }

    @Override
    protected IConfigTask visitCreatePipe(CreatePipe node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        String userName = context.getSession().getUserName();
        this.accessControl.checkUserIsAdmin(userName);
        Map<String, String> extractorAttributes = node.getExtractorAttributes();
        String pipeName = node.getPipeName();
        for (String ExtractorAttribute : extractorAttributes.keySet()) {
            if (!ExtractorAttribute.startsWith("__system")) continue;
            throw new SemanticException(String.format("Failed to create pipe %s, setting %s is not allowed.", node.getPipeName(), ExtractorAttribute));
        }
        extractorAttributes.put("__system.sql-dialect", "table");
        TableConfigTaskVisitor.checkAndEnrichSourceUserName(pipeName, extractorAttributes, userName, false);
        TableConfigTaskVisitor.checkAndEnrichSinkUserName(pipeName, node.getConnectorAttributes(), userName, false);
        TableConfigTaskVisitor.mayChangeSourcePattern(extractorAttributes);
        return new CreatePipeTask(node);
    }

    public static void checkAndEnrichSourceUserName(String pipeName, Map<String, String> replacedExtractorAttributes, String userName, boolean isAlter) {
        PipeParameters extractorParameters = new PipeParameters(replacedExtractorAttributes);
        String pluginName = extractorParameters.getStringOrDefault(Arrays.asList("extractor", "source"), BuiltinPipePlugin.IOTDB_EXTRACTOR.getPipePluginName()).toLowerCase();
        if (!pluginName.equals(BuiltinPipePlugin.IOTDB_EXTRACTOR.getPipePluginName()) && !pluginName.equals(BuiltinPipePlugin.IOTDB_SOURCE.getPipePluginName())) {
            return;
        }
        if (!extractorParameters.hasAnyAttributes(new String[]{"extractor.user", "source.user", "extractor.username", "source.username"})) {
            replacedExtractorAttributes.put("source.username", userName);
        } else if (!extractorParameters.hasAnyAttributes(new String[]{"extractor.password", "source.password"})) {
            throw new SemanticException(String.format("Failed to %s pipe %s, in iotdb-source, password must be set when the username is specified.", isAlter ? "alter" : "create", pipeName));
        }
    }

    private static void mayChangeSourcePattern(Map<String, String> extractorAttributes) {
        PipeParameters extractorParameters = new PipeParameters(extractorAttributes);
        String pluginName = extractorParameters.getStringOrDefault(Arrays.asList("extractor", "source"), BuiltinPipePlugin.IOTDB_EXTRACTOR.getPipePluginName()).toLowerCase();
        if (!pluginName.equals(BuiltinPipePlugin.IOTDB_EXTRACTOR.getPipePluginName()) && !pluginName.equals(BuiltinPipePlugin.IOTDB_SOURCE.getPipePluginName())) {
            return;
        }
        extractorParameters.computeAttributeIfExists((k, v) -> v.toLowerCase(Locale.ENGLISH), new String[]{"extractor.database", "source.database", "extractor.database-name", "source.database-name"});
        extractorParameters.computeAttributeIfExists((k, v) -> v.toLowerCase(Locale.ENGLISH), new String[]{"extractor.table", "source.table", "extractor.table-name", "source.table-name"});
    }

    public static void checkAndEnrichSinkUserName(String pipeName, Map<String, String> connectorAttributes, String userName, boolean isAlter) {
        PipeParameters connectorParameters = new PipeParameters(connectorAttributes);
        String pluginName = connectorParameters.getStringOrDefault(Arrays.asList("connector", "sink"), BuiltinPipePlugin.IOTDB_THRIFT_SINK.getPipePluginName()).toLowerCase();
        if (!pluginName.equals(BuiltinPipePlugin.WRITE_BACK_CONNECTOR.getPipePluginName()) && !pluginName.equals(BuiltinPipePlugin.WRITE_BACK_SINK.getPipePluginName())) {
            return;
        }
        if (!connectorParameters.hasAnyAttributes(new String[]{"connector.user", "sink.user", "connector.username", "sink.username"})) {
            connectorAttributes.put("sink.username", userName);
        } else if (!connectorParameters.hasAnyAttributes(new String[]{"connector.password", "sink.password"})) {
            throw new SemanticException(String.format("Failed to %s pipe %s, in write-back-sink, password must be set when the username is specified.", isAlter ? "alter" : "create", pipeName));
        }
    }

    @Override
    protected IConfigTask visitAlterPipe(AlterPipe node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        String userName = context.getSession().getUserName();
        this.accessControl.checkUserIsAdmin(userName);
        String pipeName = node.getPipeName();
        Map<String, String> extractorAttributes = node.getExtractorAttributes();
        for (String extractorAttributeKey : extractorAttributes.keySet()) {
            if (!extractorAttributeKey.startsWith("__system")) continue;
            throw new SemanticException(String.format("Failed to alter pipe %s, modifying %s is not allowed.", pipeName, extractorAttributeKey));
        }
        if (node.isReplaceAllExtractorAttributes()) {
            extractorAttributes.put("__system.sql-dialect", "table");
            TableConfigTaskVisitor.checkAndEnrichSourceUserName(pipeName, extractorAttributes, userName, true);
        }
        TableConfigTaskVisitor.mayChangeSourcePattern(extractorAttributes);
        if (node.isReplaceAllConnectorAttributes()) {
            TableConfigTaskVisitor.checkAndEnrichSinkUserName(pipeName, node.getConnectorAttributes(), userName, true);
        }
        return new AlterPipeTask(node, userName);
    }

    @Override
    protected IConfigTask visitDropPipe(DropPipe node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new DropPipeTask(node);
    }

    @Override
    protected IConfigTask visitStartPipe(StartPipe node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new StartPipeTask(node);
    }

    @Override
    protected IConfigTask visitStopPipe(StopPipe node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new StopPipeTask(node);
    }

    @Override
    protected IConfigTask visitShowPipes(ShowPipes node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new ShowPipeTask(node);
    }

    @Override
    protected IConfigTask visitCreatePipePlugin(CreatePipePlugin node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        if (node.getUriString() != null && ExecutableManager.isUriTrusted((String)node.getUriString())) {
            return new CreatePipePluginTask(node);
        }
        throw new SemanticException(ExecutableManager.getUnTrustedUriErrorMsg((String)node.getUriString()));
    }

    @Override
    protected IConfigTask visitDropPipePlugin(DropPipePlugin node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new DropPipePluginTask(node);
    }

    @Override
    protected IConfigTask visitShowPipePlugins(ShowPipePlugins node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        return new ShowPipePluginsTask(node);
    }

    @Override
    protected IConfigTask visitCreateTopic(CreateTopic node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        node.getTopicAttributes().put("__system.sql-dialect", "table");
        return new CreateTopicTask(node);
    }

    @Override
    protected IConfigTask visitDropTopic(DropTopic node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new DropTopicTask(node);
    }

    @Override
    protected IConfigTask visitShowTopics(ShowTopics node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new ShowTopicsTask(node);
    }

    @Override
    protected IConfigTask visitShowSubscriptions(ShowSubscriptions node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new ShowSubscriptionsTask(node);
    }

    @Override
    protected IConfigTask visitDropSubscription(DropSubscription node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new DropSubscriptionTask(node);
    }

    @Override
    protected IConfigTask visitShowCurrentUser(ShowCurrentUser node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        return new ShowCurrentUserTask(context.getSession().getUserName());
    }

    @Override
    protected IConfigTask visitShowCurrentSqlDialect(ShowCurrentSqlDialect node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        return new ShowCurrentSqlDialectTask(context.getSession().getSqlDialect().name());
    }

    @Override
    protected IConfigTask visitSetSqlDialect(SetSqlDialect node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        return new SetSqlDialectTask(node.getSqlDialect());
    }

    @Override
    protected IConfigTask visitShowCurrentDatabase(ShowCurrentDatabase node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        return new ShowCurrentDatabaseTask(context.getSession().getDatabaseName().orElse(null));
    }

    @Override
    protected IConfigTask visitShowVersion(ShowVersion node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        return new ShowVersionTask();
    }

    @Override
    protected IConfigTask visitShowVariables(ShowVariables node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new ShowVariablesTask();
    }

    @Override
    protected IConfigTask visitShowClusterId(ShowClusterId node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new ShowClusterIdTask();
    }

    @Override
    protected IConfigTask visitShowCurrentTimestamp(ShowCurrentTimestamp node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        return new ShowCurrentTimestampTask();
    }

    @Override
    protected IConfigTask visitRelationalAuthorPlan(RelationalAuthorStatement node, MPPQueryContext context) {
        this.accessControl.checkUserCanRunRelationalAuthorStatement(context.getSession().getUserName(), node);
        context.setQueryType(node.getQueryType());
        if (node.getAuthorType() == AuthorRType.UPDATE_USER) {
            this.visitUpdateUser(node);
        }
        return new RelationalAuthorizerTask(node);
    }

    private void visitUpdateUser(RelationalAuthorStatement node) {
        User user = AuthorityChecker.getAuthorityFetcher().getUser(node.getUserName());
        if (user == null) {
            throw new SemanticException("User " + node.getUserName() + " not found");
        }
        node.setOldPassword(user.getPassword());
        DataNodeAuthUtils.verifyPasswordReuse(node.getUserName(), node.getPassword());
    }

    @Override
    protected IConfigTask visitKillQuery(KillQuery node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new KillQueryTask(node);
    }

    @Override
    protected IConfigTask visitCreateFunction(CreateFunction node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        if (node.getUriString().map(ExecutableManager::isUriTrusted).orElse(true).booleanValue()) {
            return new CreateFunctionTask(node);
        }
        throw new SemanticException(ExecutableManager.getUnTrustedUriErrorMsg((String)node.getUriString().get()));
    }

    @Override
    protected IConfigTask visitShowFunctions(ShowFunctions node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        return new ShowFunctionsTask(Model.TABLE);
    }

    @Override
    protected IConfigTask visitDropFunction(DropFunction node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new DropFunctionTask(Model.TABLE, node.getUdfName());
    }

    @Override
    protected IConfigTask visitMigrateRegion(MigrateRegion migrateRegion, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new MigrateRegionTask(migrateRegion);
    }

    @Override
    protected IConfigTask visitReconstructRegion(ReconstructRegion reconstructRegion, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new ReconstructRegionTask(reconstructRegion);
    }

    @Override
    protected IConfigTask visitExtendRegion(ExtendRegion extendRegion, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new ExtendRegionTask(extendRegion);
    }

    @Override
    protected IConfigTask visitRemoveRegion(RemoveRegion removeRegion, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        this.accessControl.checkUserIsAdmin(context.getSession().getUserName());
        return new RemoveRegionTask(removeRegion);
    }

    @Override
    protected IConfigTask visitCreateTraining(CreateTraining node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        return new CreateTrainingTask(node.getModelId(), node.getParameters(), node.getExistingModelId(), node.getTargetSql());
    }

    @Override
    protected IConfigTask visitCreateModel(CreateModel node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        String uri = node.getUri();
        if (uri != null && ExecutableManager.isUriTrusted((String)uri)) {
            return new CreateModelTask(node.getModelId(), uri);
        }
        throw new SemanticException(ExecutableManager.getUnTrustedUriErrorMsg((String)uri));
    }

    @Override
    protected IConfigTask visitShowModels(ShowModels node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        return new ShowModelsTask(node.getModelId());
    }

    @Override
    protected IConfigTask visitDropModel(DropModel node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        return new DropModelTask(node.getModelId());
    }

    @Override
    protected IConfigTask visitShowLoadedModels(ShowLoadedModels node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        return new ShowLoadedModelsTask(node.getDeviceIdList());
    }

    @Override
    protected IConfigTask visitShowAIDevices(ShowAIDevices node, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        return new ShowAIDevicesTask();
    }

    @Override
    protected IConfigTask visitLoadModel(LoadModel node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        return new LoadModelTask(node.getModelId(), node.getDeviceIdList());
    }

    @Override
    protected IConfigTask visitUnloadModel(UnloadModel node, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        return new UnloadModelTask(node.getModelId(), node.getDeviceIdList());
    }
}

