/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.IAnalysis;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.UpdateAssignment;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegionPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.SchemaRegionPlanType;
import org.apache.iotdb.db.schemaengine.schemaregion.SchemaRegionPlanVisitor;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TableDeviceAttributeUpdateNode
extends WritePlanNode
implements ISchemaRegionPlan {
    protected String database;
    protected String tableName;
    protected List<ColumnHeader> columnHeaderList;
    protected TRegionReplicaSet schemaRegionReplicaSet;
    protected final List<List<SchemaFilter>> tagDeterminedPredicateList;
    protected final Expression tagFuzzyPredicate;
    private final List<UpdateAssignment> assignments;
    private final SessionInfo sessionInfo;
    public static final TableDeviceAttributeUpdateNode MOCK_INSTANCE = new TableDeviceAttributeUpdateNode(new PlanNodeId(""), null, null, null, null, null, null, null, null);

    public TableDeviceAttributeUpdateNode(PlanNodeId planNodeId, String database, String tableName, List<List<SchemaFilter>> tagDeterminedPredicateList, Expression tagFuzzyPredicate, List<ColumnHeader> columnHeaderList, TRegionReplicaSet schemaRegionReplicaSet, List<UpdateAssignment> assignments, SessionInfo sessionInfo) {
        super(planNodeId);
        this.database = database;
        this.tableName = tableName;
        this.columnHeaderList = columnHeaderList;
        this.schemaRegionReplicaSet = schemaRegionReplicaSet;
        this.tagDeterminedPredicateList = tagDeterminedPredicateList;
        this.tagFuzzyPredicate = tagFuzzyPredicate;
        this.assignments = assignments;
        this.sessionInfo = sessionInfo;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<ColumnHeader> getColumnHeaderList() {
        return this.columnHeaderList;
    }

    public List<List<SchemaFilter>> getTagDeterminedFilterList() {
        return this.tagDeterminedPredicateList;
    }

    public Expression getTagFuzzyPredicate() {
        return this.tagFuzzyPredicate;
    }

    public List<UpdateAssignment> getAssignments() {
        return this.assignments;
    }

    public SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableDeviceAttributeUpdate(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        this.getType().serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.database, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.tableName, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.tagDeterminedPredicateList.size(), (ByteBuffer)byteBuffer);
        for (List<SchemaFilter> filterList : this.tagDeterminedPredicateList) {
            ReadWriteIOUtils.write((int)filterList.size(), (ByteBuffer)byteBuffer);
            for (SchemaFilter filter : filterList) {
                SchemaFilter.serialize((SchemaFilter)filter, (ByteBuffer)byteBuffer);
            }
        }
        ReadWriteIOUtils.write((byte)(this.tagFuzzyPredicate == null ? (byte)0 : 1), (ByteBuffer)byteBuffer);
        if (this.tagFuzzyPredicate != null) {
            Expression.serialize(this.tagFuzzyPredicate, byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.columnHeaderList.size(), (ByteBuffer)byteBuffer);
        for (ColumnHeader columnHeader : this.columnHeaderList) {
            columnHeader.serialize(byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.assignments.size(), (ByteBuffer)byteBuffer);
        for (UpdateAssignment assignment : this.assignments) {
            assignment.serialize(byteBuffer);
        }
        ReadWriteIOUtils.write((Boolean)Objects.nonNull(this.sessionInfo), (ByteBuffer)byteBuffer);
        if (Objects.nonNull(this.sessionInfo)) {
            this.sessionInfo.serialize(byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        this.getType().serialize(stream);
        ReadWriteIOUtils.write((String)this.database, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.tableName, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.tagDeterminedPredicateList.size(), (OutputStream)stream);
        for (List<SchemaFilter> filterList : this.tagDeterminedPredicateList) {
            ReadWriteIOUtils.write((int)filterList.size(), (OutputStream)stream);
            for (SchemaFilter filter : filterList) {
                SchemaFilter.serialize((SchemaFilter)filter, (DataOutputStream)stream);
            }
        }
        ReadWriteIOUtils.write((byte)(this.tagFuzzyPredicate == null ? (byte)0 : 1), (OutputStream)stream);
        if (this.tagFuzzyPredicate != null) {
            Expression.serialize(this.tagFuzzyPredicate, stream);
        }
        ReadWriteIOUtils.write((int)this.columnHeaderList.size(), (OutputStream)stream);
        for (ColumnHeader columnHeader : this.columnHeaderList) {
            columnHeader.serialize(stream);
        }
        ReadWriteIOUtils.write((int)this.assignments.size(), (OutputStream)stream);
        for (UpdateAssignment assignment : this.assignments) {
            assignment.serialize(stream);
        }
        ReadWriteIOUtils.write((Boolean)Objects.nonNull(this.sessionInfo), (OutputStream)stream);
        if (Objects.nonNull(this.sessionInfo)) {
            this.sessionInfo.serialize(stream);
        }
    }

    public static PlanNode deserialize(ByteBuffer buffer) {
        String database = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        String tableName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        ArrayList<List<SchemaFilter>> idDeterminedFilterList = new ArrayList<List<SchemaFilter>>(size);
        for (int i = 0; i < size; ++i) {
            int singleSize = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
            idDeterminedFilterList.add(new ArrayList(singleSize));
            for (int k = 0; k < singleSize; ++k) {
                ((List)idDeterminedFilterList.get(i)).add(SchemaFilter.deserialize((ByteBuffer)buffer));
            }
        }
        Expression idFuzzyFilter = null;
        if (buffer.get() == 1) {
            idFuzzyFilter = Expression.deserialize(buffer);
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        ArrayList<ColumnHeader> columnHeaderList = new ArrayList<ColumnHeader>(size);
        for (int i = 0; i < size; ++i) {
            columnHeaderList.add(ColumnHeader.deserialize((ByteBuffer)buffer));
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        ArrayList<UpdateAssignment> assignments = new ArrayList<UpdateAssignment>(size);
        for (int i = 0; i < size; ++i) {
            assignments.add(UpdateAssignment.deserialize(buffer));
        }
        SessionInfo sessionInfo = null;
        if (ReadWriteIOUtils.readBool((ByteBuffer)buffer)) {
            sessionInfo = SessionInfo.deserializeFrom(buffer);
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(buffer);
        return new TableDeviceAttributeUpdateNode(planNodeId, database, tableName, idDeterminedFilterList, idFuzzyFilter, columnHeaderList, null, assignments, sessionInfo);
    }

    @Override
    public List<PlanNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.TABLE_DEVICE_ATTRIBUTE_UPDATE;
    }

    @Override
    public PlanNode clone() {
        return new TableDeviceAttributeUpdateNode(this.getPlanNodeId(), this.database, this.tableName, this.tagDeterminedPredicateList, this.tagFuzzyPredicate, this.columnHeaderList, this.schemaRegionReplicaSet, this.assignments, this.sessionInfo);
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.columnHeaderList.stream().map(ColumnHeader::getColumnName).collect(Collectors.toList());
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.columnHeaderList.stream().map(columnHeader -> new Symbol(columnHeader.getColumnName())).collect(Collectors.toList());
    }

    public String toString() {
        return "TableDeviceAttributeUpdateNode{assignments=" + this.assignments + ", database='" + this.database + '\'' + ", tableName='" + this.tableName + '\'' + ", idDeterminedPredicateList=" + this.tagDeterminedPredicateList + ", idFuzzyPredicate=" + this.tagFuzzyPredicate + ", columnHeaderList=" + this.columnHeaderList + ", schemaRegionReplicaSet=" + this.schemaRegionReplicaSet + "}";
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.schemaRegionReplicaSet;
    }

    @Override
    public List<WritePlanNode> splitByPartition(IAnalysis analysis) {
        return new HashSet(((Map)analysis.getSchemaPartitionInfo().getSchemaPartitionMap().get(this.database)).values()).stream().map(replicaSet -> new TableDeviceAttributeUpdateNode(this.getPlanNodeId(), this.database, this.tableName, this.tagDeterminedPredicateList, this.tagFuzzyPredicate, this.columnHeaderList, (TRegionReplicaSet)replicaSet, this.assignments, this.sessionInfo)).collect(Collectors.toList());
    }

    @Override
    public SchemaRegionPlanType getPlanType() {
        return SchemaRegionPlanType.UPDATE_TABLE_DEVICE_ATTRIBUTE;
    }

    @Override
    public <R, C> R accept(SchemaRegionPlanVisitor<R, C> visitor, C context) {
        return visitor.visitUpdateTableDeviceAttribute(this, context);
    }
}

