/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.BatchCompactionCannotAlignedException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.ChunkWriterFlushCallback;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.CompactChunkPlan;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.CompactPagePlan;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.write.PageException;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.file.metadata.statistics.TimeStatistics;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.tsfile.write.chunk.IChunkWriter;
import org.apache.tsfile.write.chunk.TimeChunkWriter;
import org.apache.tsfile.write.chunk.ValueChunkWriter;
import org.apache.tsfile.write.page.TimePageWriter;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.writer.TsFileIOWriter;

public class FollowingBatchCompactionAlignedChunkWriter
extends AlignedChunkWriterImpl {
    private int currentPage = 0;
    private CompactChunkPlan compactChunkPlan;
    private ChunkWriterFlushCallback afterChunkWriterFlushCallback;

    public FollowingBatchCompactionAlignedChunkWriter(IMeasurementSchema timeSchema, List<IMeasurementSchema> valueSchemaList, CompactChunkPlan compactChunkPlan) {
        this.timeChunkWriter = new FollowingBatchCompactionTimeChunkWriter();
        this.valueChunkWriterList = new ArrayList(valueSchemaList.size());
        for (int i = 0; i < valueSchemaList.size(); ++i) {
            this.valueChunkWriterList.add(new ValueChunkWriter(valueSchemaList.get(i).getMeasurementName(), valueSchemaList.get(i).getCompressor(), valueSchemaList.get(i).getType(), valueSchemaList.get(i).getEncodingType(), valueSchemaList.get(i).getValueEncoder()));
        }
        this.valueIndex = 0;
        this.compactChunkPlan = compactChunkPlan;
    }

    protected boolean checkPageSizeAndMayOpenANewPage() {
        long endTime = ((FollowingBatchCompactionTimeChunkWriter)this.timeChunkWriter).chunkStatistics.getEndTime();
        return endTime == this.compactChunkPlan.getPageRecords().get(this.currentPage).getTimeRange().getMax();
    }

    public void sealCurrentPage() {
        this.writePageToPageBuffer();
    }

    protected void writePageToPageBuffer() {
        FollowingBatchCompactionTimeChunkWriter followingBatchCompactionTimeChunkWriter = (FollowingBatchCompactionTimeChunkWriter)this.timeChunkWriter;
        TimeStatistics pageStatistics = followingBatchCompactionTimeChunkWriter.pageStatistics;
        if (pageStatistics.isEmpty()) {
            return;
        }
        CompactPagePlan alignedTimePage = this.compactChunkPlan.getPageRecords().get(this.currentPage);
        if (alignedTimePage.getTimeRange().getMax() != pageStatistics.getEndTime()) {
            throw new BatchCompactionCannotAlignedException((Statistics)pageStatistics, this.compactChunkPlan, this.currentPage);
        }
        super.writePageToPageBuffer();
        ++this.currentPage;
    }

    public void writePageHeaderAndDataIntoTimeBuff(ByteBuffer data, PageHeader header) throws PageException {
        if (this.currentPage >= this.compactChunkPlan.getPageRecords().size() || header.getStatistics().getStartTime() != this.compactChunkPlan.getPageRecords().get(this.currentPage).getTimeRange().getMin()) {
            throw new BatchCompactionCannotAlignedException(header, this.compactChunkPlan, this.currentPage);
        }
        super.writePageHeaderAndDataIntoTimeBuff(data, header);
        ++this.currentPage;
    }

    public void writeToFileWriter(TsFileIOWriter tsfileWriter) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        for (ValueChunkWriter valueChunkWriter : this.valueChunkWriterList) {
            valueChunkWriter.writeToFileWriter(tsfileWriter);
        }
        if (this.afterChunkWriterFlushCallback != null) {
            this.afterChunkWriterFlushCallback.call((IChunkWriter)this);
        }
    }

    public boolean checkIsChunkSizeOverThreshold(long size, long pointNum, boolean returnTrueIfChunkEmpty) {
        if (this.compactChunkPlan.isCompactedByDirectlyFlush()) {
            return true;
        }
        return this.currentPage >= this.compactChunkPlan.getPageRecords().size() || ((FollowingBatchCompactionTimeChunkWriter)this.timeChunkWriter).chunkStatistics.getEndTime() == this.compactChunkPlan.getTimeRange().getMax();
    }

    public boolean isEmpty() {
        return this.timeChunkWriter.getPointNum() == 0L;
    }

    public boolean checkIsUnsealedPageOverThreshold(long size, long pointNum, boolean returnTrueIfPageEmpty) {
        if (this.currentPage >= this.compactChunkPlan.getPageRecords().size()) {
            return true;
        }
        CompactPagePlan compactPagePlan = this.compactChunkPlan.getPageRecords().get(this.currentPage);
        if (compactPagePlan.isCompactedByDirectlyFlush()) {
            return true;
        }
        long endTime = ((FollowingBatchCompactionTimeChunkWriter)this.timeChunkWriter).pageStatistics.getEndTime();
        return endTime == this.compactChunkPlan.getPageRecords().get(this.currentPage).getTimeRange().getMax();
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCompactChunkPlan(CompactChunkPlan compactChunkPlan) {
        this.compactChunkPlan = compactChunkPlan;
        this.currentPage = 0;
        this.timeChunkWriter = new FollowingBatchCompactionTimeChunkWriter();
    }

    public void registerAfterFlushChunkWriterCallback(ChunkWriterFlushCallback flushChunkWriterCallback) {
        this.afterChunkWriterFlushCallback = flushChunkWriterCallback;
    }

    public static class FollowingBatchCompactionTimeChunkWriter
    extends TimeChunkWriter {
        private TimeStatistics chunkStatistics = new TimeStatistics();
        private TimeStatistics pageStatistics = new TimeStatistics();

        public void write(long time) {
            this.chunkStatistics.update(time);
            this.pageStatistics.update(time);
        }

        public void write(long[] timestamps, int batchSize, int arrayOffset) {
            throw new RuntimeException("unimplemented");
        }

        public boolean checkPageSizeAndMayOpenANewPage() {
            throw new RuntimeException("unimplemented");
        }

        public long getRemainingPointNumberForCurrentPage() {
            throw new RuntimeException("unimplemented");
        }

        public void writePageToPageBuffer() {
            this.pageStatistics = new TimeStatistics();
        }

        public void writePageHeaderAndDataIntoBuff(ByteBuffer data, PageHeader header) throws PageException {
            if (data == null || header.getStatistics() == null || header.getStatistics().isEmpty()) {
                return;
            }
            this.chunkStatistics.mergeStatistics(header.getStatistics());
        }

        public void writeToFileWriter(TsFileIOWriter tsfileWriter) throws IOException {
            this.chunkStatistics = new TimeStatistics();
            this.pageStatistics = new TimeStatistics();
        }

        public long getCurrentChunkSize() {
            throw new RuntimeException("unimplemented");
        }

        public void sealCurrentPage() {
            this.pageStatistics = new TimeStatistics();
        }

        public void clearPageWriter() {
            this.pageStatistics = new TimeStatistics();
        }

        public TSDataType getDataType() {
            return super.getDataType();
        }

        public long getPointNum() {
            return this.chunkStatistics == null ? 0L : (long)this.chunkStatistics.getCount();
        }

        public void writeAllPagesOfChunkToTsFile(TsFileIOWriter writer) throws IOException {
            this.chunkStatistics = new TimeStatistics();
            this.pageStatistics = new TimeStatistics();
        }

        public PublicBAOS getPageBuffer() {
            throw new RuntimeException("unimplemented");
        }

        public TimePageWriter getPageWriter() {
            throw new RuntimeException("unimplemented");
        }

        public boolean checkIsUnsealedPageOverThreshold(long size, long pointNum) {
            throw new RuntimeException("unimplemented");
        }

        public TimeStatistics getChunkStatistics() {
            return this.chunkStatistics;
        }
    }
}

