/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.windowing.handler;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.iotdb.db.utils.windowing.api.Evaluator;
import org.apache.iotdb.db.utils.windowing.configuration.SlidingTimeWindowConfiguration;
import org.apache.iotdb.db.utils.windowing.exception.WindowingException;
import org.apache.iotdb.db.utils.windowing.handler.SlidingWindowEvaluationHandler;
import org.apache.iotdb.db.utils.windowing.runtime.WindowEvaluationTask;
import org.apache.iotdb.db.utils.windowing.window.WindowImpl;

public class SlidingTimeWindowEvaluationHandler
extends SlidingWindowEvaluationHandler {
    private final long timeInterval;
    private final long slidingStep;
    private final Queue<Integer> windowBeginIndexQueue;
    private long currentWindowEndTime;
    private long nextWindowBeginTime;

    public SlidingTimeWindowEvaluationHandler(SlidingTimeWindowConfiguration configuration, Evaluator evaluator) throws WindowingException {
        super(configuration, evaluator);
        this.timeInterval = configuration.getTimeInterval();
        this.slidingStep = configuration.getSlidingStep();
        this.windowBeginIndexQueue = new LinkedList<Integer>();
    }

    @Override
    protected void createEvaluationTaskIfNecessary(long timestamp) {
        if (this.data.size() == 1) {
            this.windowBeginIndexQueue.add(0);
            this.currentWindowEndTime = timestamp + this.timeInterval;
            this.nextWindowBeginTime = timestamp + this.slidingStep;
            return;
        }
        while (this.nextWindowBeginTime <= timestamp) {
            this.windowBeginIndexQueue.add(this.data.size() - 1);
            this.nextWindowBeginTime += this.slidingStep;
        }
        while (this.currentWindowEndTime <= timestamp) {
            int windowBeginIndex = this.windowBeginIndexQueue.remove();
            TASK_POOL_MANAGER.submit(new WindowEvaluationTask(this.evaluator, new WindowImpl(this.data, windowBeginIndex, this.data.size() - 1 - windowBeginIndex)));
            this.data.setEvictionUpperBound(windowBeginIndex);
            this.currentWindowEndTime += this.slidingStep;
        }
    }
}

