/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.agent.task.meta;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.agent.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeType;
import org.apache.iotdb.commons.pipe.datastructure.visibility.Visibility;
import org.apache.iotdb.commons.pipe.datastructure.visibility.VisibilityUtils;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PipeStaticMeta {
    private String pipeName;
    private long creationTime;
    private PipeParameters sourceParameters;
    private PipeParameters processorParameters;
    private PipeParameters sinkParameters;
    public static final String SYSTEM_PIPE_PREFIX = "__";
    public static final String SUBSCRIPTION_PIPE_PREFIX = "__subscription.";
    public static final String CONSENSUS_PIPE_PREFIX = "__consensus.";

    private PipeStaticMeta() {
    }

    public PipeStaticMeta(String pipeName, long creationTime, Map<String, String> extractorAttributes, Map<String, String> processorAttributes, Map<String, String> connectorAttributes) {
        this.pipeName = pipeName;
        this.creationTime = creationTime;
        this.sourceParameters = new PipeParameters(extractorAttributes);
        this.processorParameters = new PipeParameters(processorAttributes);
        this.sinkParameters = new PipeParameters(connectorAttributes);
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public PipeParameters getSourceParameters() {
        return this.sourceParameters;
    }

    public PipeParameters getProcessorParameters() {
        return this.processorParameters;
    }

    public PipeParameters getSinkParameters() {
        return this.sinkParameters;
    }

    public PipeType getPipeType() {
        return PipeType.getPipeType(this.pipeName);
    }

    public boolean isSourceExternal() {
        return !BuiltinPipePlugin.BUILTIN_SOURCES.contains(this.sourceParameters.getStringOrDefault(Arrays.asList("extractor", "source"), BuiltinPipePlugin.IOTDB_EXTRACTOR.getPipePluginName()).toLowerCase());
    }

    public ByteBuffer serialize() throws IOException {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        this.serialize(outputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
    }

    public void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((String)this.pipeName, (OutputStream)outputStream);
        ReadWriteIOUtils.write((long)this.creationTime, (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.sourceParameters.getAttribute().size(), (OutputStream)outputStream);
        for (Map.Entry entry : this.sourceParameters.getAttribute().entrySet()) {
            ReadWriteIOUtils.write((String)((String)entry.getKey()), (OutputStream)outputStream);
            ReadWriteIOUtils.write((String)((String)entry.getValue()), (OutputStream)outputStream);
        }
        ReadWriteIOUtils.write((int)this.processorParameters.getAttribute().size(), (OutputStream)outputStream);
        for (Map.Entry entry : this.processorParameters.getAttribute().entrySet()) {
            ReadWriteIOUtils.write((String)((String)entry.getKey()), (OutputStream)outputStream);
            ReadWriteIOUtils.write((String)((String)entry.getValue()), (OutputStream)outputStream);
        }
        ReadWriteIOUtils.write((int)this.sinkParameters.getAttribute().size(), (OutputStream)outputStream);
        for (Map.Entry entry : this.sinkParameters.getAttribute().entrySet()) {
            ReadWriteIOUtils.write((String)((String)entry.getKey()), (OutputStream)outputStream);
            ReadWriteIOUtils.write((String)((String)entry.getValue()), (OutputStream)outputStream);
        }
    }

    public static PipeStaticMeta deserialize(InputStream inputStream) throws IOException {
        String value;
        String key;
        int i;
        PipeStaticMeta pipeStaticMeta = new PipeStaticMeta();
        pipeStaticMeta.pipeName = ReadWriteIOUtils.readString((InputStream)inputStream);
        pipeStaticMeta.creationTime = ReadWriteIOUtils.readLong((InputStream)inputStream);
        pipeStaticMeta.sourceParameters = new PipeParameters(new HashMap());
        pipeStaticMeta.processorParameters = new PipeParameters(new HashMap());
        pipeStaticMeta.sinkParameters = new PipeParameters(new HashMap());
        int size = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString((InputStream)inputStream);
            value = ReadWriteIOUtils.readString((InputStream)inputStream);
            pipeStaticMeta.sourceParameters.getAttribute().put(key, value);
        }
        size = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString((InputStream)inputStream);
            value = ReadWriteIOUtils.readString((InputStream)inputStream);
            pipeStaticMeta.processorParameters.getAttribute().put(key, value);
        }
        size = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString((InputStream)inputStream);
            value = ReadWriteIOUtils.readString((InputStream)inputStream);
            pipeStaticMeta.sinkParameters.getAttribute().put(key, value);
        }
        return pipeStaticMeta;
    }

    public static PipeStaticMeta deserialize(ByteBuffer byteBuffer) {
        String value;
        String key;
        int i;
        PipeStaticMeta pipeStaticMeta = new PipeStaticMeta();
        pipeStaticMeta.pipeName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        pipeStaticMeta.creationTime = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        pipeStaticMeta.sourceParameters = new PipeParameters(new HashMap());
        pipeStaticMeta.processorParameters = new PipeParameters(new HashMap());
        pipeStaticMeta.sinkParameters = new PipeParameters(new HashMap());
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            value = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            pipeStaticMeta.sourceParameters.getAttribute().put(key, value);
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            value = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            pipeStaticMeta.processorParameters.getAttribute().put(key, value);
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            value = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            pipeStaticMeta.sinkParameters.getAttribute().put(key, value);
        }
        return pipeStaticMeta;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PipeStaticMeta that = (PipeStaticMeta)obj;
        return this.pipeName.equals(that.pipeName) && this.creationTime == that.creationTime && this.sourceParameters.equals((Object)that.sourceParameters) && this.processorParameters.equals((Object)that.processorParameters) && this.sinkParameters.equals((Object)that.sinkParameters);
    }

    public int hashCode() {
        return Objects.hash(this.pipeName, this.creationTime, this.sourceParameters, this.processorParameters, this.sinkParameters);
    }

    public String toString() {
        return "PipeStaticMeta{pipeName='" + this.pipeName + "', creationTime=" + this.creationTime + ", sourceParameters=" + this.sourceParameters + ", processorParameters=" + this.processorParameters + ", sinkParameters=" + this.sinkParameters + "}";
    }

    public static String generateSubscriptionPipeName(String topicName, String consumerGroupId) {
        return SUBSCRIPTION_PIPE_PREFIX + topicName + "_" + consumerGroupId;
    }

    public static boolean isSubscriptionPipe(String pipeName) {
        return Objects.nonNull(pipeName) && pipeName.startsWith(SUBSCRIPTION_PIPE_PREFIX);
    }

    public boolean visibleUnder(boolean isTableModel) {
        Visibility visibility = VisibilityUtils.calculateFromExtractorParameters(this.sourceParameters);
        return VisibilityUtils.isCompatible(visibility, isTableModel);
    }
}

