/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.james.jdkim.api.PublicKeyRecordRetriever;
import org.apache.james.jdkim.exceptions.PermFailException;
import org.apache.james.jdkim.exceptions.TempFailException;

public class MockPublicKeyRecordRetriever
implements PublicKeyRecordRetriever {
    private static final String _DOMAINKEY = "._domainkey.";
    private final Map<String, List<String>> records = new HashMap<String, List<String>>();

    public void addRecord(String selector, String token, String record) {
        String key = selector + _DOMAINKEY + token;
        List<String> l = this.records.get(key);
        if (l == null) {
            l = new LinkedList<String>();
            this.records.put(key, l);
        }
        if (record != null) {
            l.add(record);
        }
    }

    public MockPublicKeyRecordRetriever() {
    }

    public MockPublicKeyRecordRetriever(String record, CharSequence selector, CharSequence token) {
        this.addRecord(selector.toString(), token.toString(), record);
    }

    public List<String> getRecords(CharSequence methodAndOptions, CharSequence selector, CharSequence token) throws TempFailException, PermFailException {
        if ("dns/txt".equals(methodAndOptions)) {
            String search = selector + _DOMAINKEY + token;
            List<String> res = this.records.get(search);
            if (res == null || res.size() > 0) {
                return res;
            }
            throw new TempFailException("Timout or servfail");
        }
        throw new PermFailException("Unsupported method");
    }
}

