/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.james.jdkim.api.PublicKeyRecordRetriever;
import org.apache.james.jdkim.exceptions.PermFailException;
import org.apache.james.jdkim.exceptions.TempFailException;

public class MockPublicKeyRecordRetriever
implements PublicKeyRecordRetriever {
    private static final String _DOMAINKEY = "._domainkey.";
    private final Map<String, List<String>> records = new HashMap<String, List<String>>();

    public void addRecord(String selector, String domain, String record) {
        String key = selector + _DOMAINKEY + domain;
        List l = this.records.computeIfAbsent(key, k -> new LinkedList());
        if (record != null) {
            l.add(record);
        }
    }

    public MockPublicKeyRecordRetriever() {
    }

    public MockPublicKeyRecordRetriever(String record, CharSequence selector, CharSequence token) {
        this.addRecord(selector.toString(), token.toString(), record);
    }

    public MockPublicKeyRecordRetriever(Record ... records) {
        Arrays.stream(records).forEach(this::addRecord);
    }

    private void addRecord(Record record) {
        String key = record.selector + _DOMAINKEY + record.domain;
        List l = this.records.computeIfAbsent(key, k -> new LinkedList());
        l.add(record.record);
    }

    public List<String> getRecords(CharSequence methodAndOptions, CharSequence selector, CharSequence token) throws TempFailException, PermFailException {
        if ("dns/txt".equals(methodAndOptions)) {
            String search = selector + _DOMAINKEY + token;
            List<String> res = this.records.get(search);
            if (res == null || res.size() > 0) {
                return res;
            }
            throw new TempFailException("Timout or servfail");
        }
        throw new PermFailException("Unsupported method");
    }

    public static class Record {
        String selector;
        String domain;
        String record;

        public Record(String selector, String domain, String record) {
            assert (selector != null) : "selector cannot be null";
            assert (domain != null) : "domain cannot be null";
            assert (record != null) : "record cannot be null";
            this.selector = selector;
            this.domain = domain;
            this.record = record;
        }

        public static Record of(String selector, String domain, String record) {
            return new Record(selector, domain, record);
        }
    }
}

