/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;

public class TestKeys {
    public static final PrivateKey privateKey = TestKeys.loadPrivateKey("org/apache/james/jdkim/keys/private.key");
    public static final PublicKey publicKey = TestKeys.loadPublicKey("org/apache/james/jdkim/keys/public.pem");
    public static final KeyPair keyPair = new KeyPair(publicKey, privateKey);
    public static final PrivateKey privateKey_2 = TestKeys.loadPrivateKey("org/apache/james/jdkim/keys/private.2.key");
    public static final PublicKey publicKey_2 = TestKeys.loadPublicKey("org/apache/james/jdkim/keys/public.2.pem");
    public static final KeyPair keyPair_2 = new KeyPair(publicKey, privateKey);

    private static PublicKey loadPublicKey(String uri) {
        try {
            String keyText = TestKeys.readFileContent(uri).replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").replaceAll(System.lineSeparator(), "");
            byte[] encoded = Base64.decodeBase64((String)keyText);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encoded);
            return keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String readFileContent(String uri) throws URISyntaxException, IOException {
        URL resource = TestKeys.class.getClassLoader().getResource(uri);
        File file = new File(resource.toURI());
        return new String(Files.readAllBytes(file.toPath()), Charset.defaultCharset());
    }

    private static PrivateKey loadPrivateKey(String uri) {
        try {
            String keyText = TestKeys.readFileContent(uri).replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll(System.lineSeparator(), "");
            byte[] encoded = Base64.decodeBase64((String)keyText);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
            return keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

