/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.io;

import java.io.IOException;
import org.apache.james.mime4j.io.EOLConvertingInputStream;
import org.apache.james.mime4j.io.InputStreams;
import org.apache.james.mime4j.util.ContentUtil;
import org.junit.Assert;
import org.junit.Test;

public class EOLConvertingInputStreamTest {
    @Test
    public void testRead() throws IOException {
        this.testConvertBoth("Line 1\r\nLine 2\r\n", "Line 1\r\nLine 2\r\n");
        this.testConvertCR("Line 1\r\nLine 2\r\n", "Line 1\r\nLine 2\r\n");
        this.testConvertLF("Line 1\r\nLine 2\r\n", "Line 1\r\nLine 2\r\n");
        this.testConvertBoth("Line 1\n\rLine 2\n\r", "Line 1\r\n\r\nLine 2\r\n\r\n");
        this.testConvertCR("Line 1\n\rLine 2\n\r", "Line 1\n\r\nLine 2\n\r\n");
        this.testConvertLF("Line 1\n\rLine 2\n\r", "Line 1\r\n\rLine 2\r\n\r");
        this.testConvertBoth("Line 1\nLine 2\n", "Line 1\r\nLine 2\r\n");
        this.testConvertCR("Line 1\nLine 2\n", "Line 1\nLine 2\n");
        this.testConvertLF("Line 1\nLine 2\n", "Line 1\r\nLine 2\r\n");
        this.testConvertBoth("Line 1\rLine 2\r", "Line 1\r\nLine 2\r\n");
        this.testConvertCR("Line 1\rLine 2\r", "Line 1\r\nLine 2\r\n");
        this.testConvertLF("Line 1\rLine 2\r", "Line 1\rLine 2\r");
        this.testConvertBoth("\r\n", "\r\n");
        this.testConvertCR("\r\n", "\r\n");
        this.testConvertLF("\r\n", "\r\n");
        this.testConvertBoth("\n", "\r\n");
        this.testConvertCR("\n", "\n");
        this.testConvertLF("\n", "\r\n");
        this.testConvertBoth("\r", "\r\n");
        this.testConvertCR("\r", "\r\n");
        this.testConvertLF("\r", "\r");
        this.testConvertBoth("", "");
        this.testConvertCR("", "");
        this.testConvertLF("", "");
    }

    private void testConvertBoth(String s1, String s2) throws IOException {
        byte[] bytes = new byte[1024];
        EOLConvertingInputStream in = new EOLConvertingInputStream(InputStreams.createAscii((CharSequence)s1), 3);
        int n = in.read(bytes);
        Assert.assertEquals((Object)s2, (Object)ContentUtil.toAsciiString((byte[])bytes, (int)0, (int)Math.max(n, 0)));
        in.close();
    }

    private void testConvertCR(String s1, String s2) throws IOException {
        byte[] bytes = new byte[1024];
        EOLConvertingInputStream in = new EOLConvertingInputStream(InputStreams.createAscii((CharSequence)s1), 1);
        int n = in.read(bytes);
        Assert.assertEquals((Object)s2, (Object)ContentUtil.toAsciiString((byte[])bytes, (int)0, (int)Math.max(n, 0)));
        in.close();
    }

    private void testConvertLF(String s1, String s2) throws IOException {
        byte[] bytes = new byte[1024];
        EOLConvertingInputStream in = new EOLConvertingInputStream(InputStreams.createAscii((CharSequence)s1), 2);
        int n = in.read(bytes);
        Assert.assertEquals((Object)s2, (Object)ContentUtil.toAsciiString((byte[])bytes, (int)0, (int)Math.max(n, 0)));
        in.close();
    }
}

