/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.results;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.AggregatorUtils;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.results.ScalarDerivativeResult;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.util.SampleBuffer;
import org.openjdk.jmh.util.Statistics;

public class SampleTimeResult
extends Result<SampleTimeResult> {
    private static final long serialVersionUID = -295298353763294757L;
    private final SampleBuffer buffer;
    private final TimeUnit outputTimeUnit;

    public SampleTimeResult(ResultRole role, String label, SampleBuffer buffer, TimeUnit outputTimeUnit) {
        this(role, label, buffer, TimeValue.tuToString(outputTimeUnit) + "/op", outputTimeUnit);
    }

    SampleTimeResult(ResultRole role, String label, SampleBuffer buffer, String unit, TimeUnit outputTimeUnit) {
        super(role, label, SampleTimeResult.of(buffer, outputTimeUnit), unit, AggregationPolicy.AVG);
        this.buffer = buffer;
        this.outputTimeUnit = outputTimeUnit;
    }

    private static Statistics of(SampleBuffer buffer, TimeUnit outputTimeUnit) {
        double tuMultiplier = 1.0 * (double)outputTimeUnit.convert(1L, TimeUnit.DAYS) / (double)TimeUnit.NANOSECONDS.convert(1L, TimeUnit.DAYS);
        return buffer.getStatistics(tuMultiplier);
    }

    @Override
    protected Collection<? extends Result> getDerivativeResults() {
        return Arrays.asList(new ScalarDerivativeResult(this.label + "\u00b7" + "p0.00", this.statistics.getPercentile(0.0), this.getScoreUnit(), AggregationPolicy.AVG), new ScalarDerivativeResult(this.label + "\u00b7" + "p0.50", this.statistics.getPercentile(50.0), this.getScoreUnit(), AggregationPolicy.AVG), new ScalarDerivativeResult(this.label + "\u00b7" + "p0.90", this.statistics.getPercentile(90.0), this.getScoreUnit(), AggregationPolicy.AVG), new ScalarDerivativeResult(this.label + "\u00b7" + "p0.95", this.statistics.getPercentile(95.0), this.getScoreUnit(), AggregationPolicy.AVG), new ScalarDerivativeResult(this.label + "\u00b7" + "p0.99", this.statistics.getPercentile(99.0), this.getScoreUnit(), AggregationPolicy.AVG), new ScalarDerivativeResult(this.label + "\u00b7" + "p0.999", this.statistics.getPercentile(99.9), this.getScoreUnit(), AggregationPolicy.AVG), new ScalarDerivativeResult(this.label + "\u00b7" + "p0.9999", this.statistics.getPercentile(99.99), this.getScoreUnit(), AggregationPolicy.AVG), new ScalarDerivativeResult(this.label + "\u00b7" + "p1.00", this.statistics.getPercentile(100.0), this.getScoreUnit(), AggregationPolicy.AVG));
    }

    @Override
    public String extendedInfo() {
        return this.distributionExtendedInfo();
    }

    @Override
    protected Aggregator<SampleTimeResult> getThreadAggregator() {
        return new JoiningAggregator();
    }

    @Override
    protected Aggregator<SampleTimeResult> getIterationAggregator() {
        return new JoiningAggregator();
    }

    static class JoiningAggregator
    implements Aggregator<SampleTimeResult> {
        JoiningAggregator() {
        }

        @Override
        public SampleTimeResult aggregate(Collection<SampleTimeResult> results) {
            SampleBuffer buffer = new SampleBuffer();
            TimeUnit tu = null;
            for (SampleTimeResult r : results) {
                buffer.addAll(r.buffer);
                if (tu == null) {
                    tu = r.outputTimeUnit;
                    continue;
                }
                if (tu.equals((Object)r.outputTimeUnit)) continue;
                throw new IllegalStateException("Combining the results with different timeunits");
            }
            return new SampleTimeResult(AggregatorUtils.aggregateRoles(results), AggregatorUtils.aggregateLabels(results), buffer, AggregatorUtils.aggregateUnits(results), tu);
        }
    }
}

