/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.results;

import java.util.Collection;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.AggregatorUtils;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.util.ListStatistics;
import org.openjdk.jmh.util.Statistics;

public class ScalarResult
extends Result<ScalarResult> {
    private static final long serialVersionUID = 3407232747805728586L;

    public ScalarResult(String label, double n, String unit, AggregationPolicy policy) {
        this(label, ScalarResult.of(n), unit, policy);
    }

    ScalarResult(String label, Statistics s, String unit, AggregationPolicy policy) {
        super(ResultRole.SECONDARY, label, s, unit, policy);
    }

    @Override
    protected Aggregator<ScalarResult> getThreadAggregator() {
        return new ScalarResultAggregator();
    }

    @Override
    protected Aggregator<ScalarResult> getIterationAggregator() {
        return new ScalarResultAggregator();
    }

    @Override
    protected ScalarResult getZeroResult() {
        return new ScalarResult(this.label, 0.0, this.unit, this.policy);
    }

    static class ScalarResultAggregator
    implements Aggregator<ScalarResult> {
        ScalarResultAggregator() {
        }

        @Override
        public ScalarResult aggregate(Collection<ScalarResult> results) {
            ListStatistics stats = new ListStatistics();
            for (ScalarResult r : results) {
                stats.addValue(r.getScore());
            }
            return new ScalarResult(AggregatorUtils.aggregateLabels(results), stats, AggregatorUtils.aggregateUnits(results), AggregatorUtils.aggregatePolicies(results));
        }
    }
}

