/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.jmap.draft.methods.Method;
import org.apache.james.jmap.draft.model.SetError;

public class SetVacationResponse
implements Method.Response {
    private final Optional<List<String>> updated;
    private final Optional<Map<String, SetError>> notUpdated;

    public static Builder builder() {
        return new Builder();
    }

    private SetVacationResponse(Optional<List<String>> updated, Optional<Map<String, SetError>> notUpdated) {
        this.updated = updated;
        this.notUpdated = notUpdated;
    }

    public Optional<List<String>> getUpdated() {
        return this.updated;
    }

    public Optional<Map<String, SetError>> getNotUpdated() {
        return this.notUpdated;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetVacationResponse that = (SetVacationResponse)o;
        return Objects.equals(this.updated, that.updated) && Objects.equals(this.notUpdated, that.notUpdated);
    }

    public int hashCode() {
        return Objects.hash(this.updated, this.notUpdated);
    }

    public static class Builder {
        private Optional<String> updatedId = Optional.empty();
        private Optional<String> notUpdatedId = Optional.empty();
        private Optional<SetError> setError = Optional.empty();

        public Builder updatedId(String updatedId) {
            Preconditions.checkNotNull((Object)updatedId);
            this.updatedId = Optional.of(updatedId);
            return this;
        }

        public Builder notUpdated(String id, SetError setError) {
            Preconditions.checkNotNull((Object)id);
            Preconditions.checkNotNull((Object)setError);
            this.notUpdatedId = Optional.of(id);
            this.setError = Optional.of(setError);
            return this;
        }

        public SetVacationResponse build() {
            return new SetVacationResponse(this.updatedId.map(ImmutableList::of), this.notUpdatedId.map(id -> ImmutableMap.of((Object)id, (Object)this.setError.get())));
        }
    }
}

