/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.hybrid;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.DeterministicAead;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.aead.AeadConfig;
import com.google.crypto.tink.daead.DeterministicAeadConfig;
import com.google.crypto.tink.hybrid.subtle.AeadOrDaead;
import com.google.crypto.tink.proto.AesCtrHmacAeadKey;
import com.google.crypto.tink.proto.AesCtrHmacAeadKeyFormat;
import com.google.crypto.tink.proto.AesCtrKey;
import com.google.crypto.tink.proto.AesGcmKey;
import com.google.crypto.tink.proto.AesGcmKeyFormat;
import com.google.crypto.tink.proto.AesSivKey;
import com.google.crypto.tink.proto.AesSivKeyFormat;
import com.google.crypto.tink.proto.HmacKey;
import com.google.crypto.tink.proto.KeyTemplate;
import com.google.crypto.tink.subtle.EciesAeadHkdfDemHelper;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.security.GeneralSecurityException;
import java.util.Arrays;

class RegistryEciesAeadHkdfDemHelper
implements EciesAeadHkdfDemHelper {
    private final String demKeyTypeUrl;
    private final int symmetricKeySize;
    private AesGcmKey aesGcmKey;
    private AesCtrHmacAeadKey aesCtrHmacAeadKey;
    private int aesCtrKeySize;
    private AesSivKey aesSivKey;

    RegistryEciesAeadHkdfDemHelper(KeyTemplate demTemplate) throws GeneralSecurityException {
        this.demKeyTypeUrl = demTemplate.getTypeUrl();
        if (this.demKeyTypeUrl.equals(AeadConfig.AES_GCM_TYPE_URL)) {
            try {
                AesGcmKeyFormat gcmKeyFormat = AesGcmKeyFormat.parseFrom(demTemplate.getValue(), ExtensionRegistryLite.getEmptyRegistry());
                this.aesGcmKey = (AesGcmKey)Registry.newKey(demTemplate);
                this.symmetricKeySize = gcmKeyFormat.getKeySize();
            }
            catch (InvalidProtocolBufferException e) {
                throw new GeneralSecurityException("invalid KeyFormat protobuf, expected AesGcmKeyFormat", e);
            }
        } else if (this.demKeyTypeUrl.equals(AeadConfig.AES_CTR_HMAC_AEAD_TYPE_URL)) {
            try {
                AesCtrHmacAeadKeyFormat aesCtrHmacAeadKeyFormat = AesCtrHmacAeadKeyFormat.parseFrom(demTemplate.getValue(), ExtensionRegistryLite.getEmptyRegistry());
                this.aesCtrHmacAeadKey = (AesCtrHmacAeadKey)Registry.newKey(demTemplate);
                this.aesCtrKeySize = aesCtrHmacAeadKeyFormat.getAesCtrKeyFormat().getKeySize();
                int hmacKeySize = aesCtrHmacAeadKeyFormat.getHmacKeyFormat().getKeySize();
                this.symmetricKeySize = this.aesCtrKeySize + hmacKeySize;
            }
            catch (InvalidProtocolBufferException e) {
                throw new GeneralSecurityException("invalid KeyFormat protobuf, expected AesCtrHmacAeadKeyFormat", e);
            }
        } else if (this.demKeyTypeUrl.equals(DeterministicAeadConfig.AES_SIV_TYPE_URL)) {
            try {
                AesSivKeyFormat aesSivKeyFormat = AesSivKeyFormat.parseFrom(demTemplate.getValue(), ExtensionRegistryLite.getEmptyRegistry());
                this.aesSivKey = (AesSivKey)Registry.newKey(demTemplate);
                this.symmetricKeySize = aesSivKeyFormat.getKeySize();
            }
            catch (InvalidProtocolBufferException e) {
                throw new GeneralSecurityException("invalid KeyFormat protobuf, expected AesCtrHmacAeadKeyFormat", e);
            }
        } else {
            throw new GeneralSecurityException("unsupported AEAD DEM key type: " + this.demKeyTypeUrl);
        }
    }

    @Override
    public int getSymmetricKeySizeInBytes() {
        return this.symmetricKeySize;
    }

    @Override
    public AeadOrDaead getAeadOrDaead(byte[] symmetricKeyValue) throws GeneralSecurityException {
        if (symmetricKeyValue.length != this.getSymmetricKeySizeInBytes()) {
            throw new GeneralSecurityException("Symmetric key has incorrect length");
        }
        if (this.demKeyTypeUrl.equals(AeadConfig.AES_GCM_TYPE_URL)) {
            AesGcmKey aeadKey = AesGcmKey.newBuilder().mergeFrom(this.aesGcmKey).setKeyValue(ByteString.copyFrom((byte[])symmetricKeyValue, (int)0, (int)this.symmetricKeySize)).build();
            return new AeadOrDaead(Registry.getPrimitive(this.demKeyTypeUrl, (MessageLite)aeadKey, Aead.class));
        }
        if (this.demKeyTypeUrl.equals(AeadConfig.AES_CTR_HMAC_AEAD_TYPE_URL)) {
            byte[] aesCtrKeyValue = Arrays.copyOfRange(symmetricKeyValue, 0, this.aesCtrKeySize);
            byte[] hmacKeyValue = Arrays.copyOfRange(symmetricKeyValue, this.aesCtrKeySize, this.symmetricKeySize);
            AesCtrKey aesCtrKey = AesCtrKey.newBuilder().mergeFrom(this.aesCtrHmacAeadKey.getAesCtrKey()).setKeyValue(ByteString.copyFrom((byte[])aesCtrKeyValue)).build();
            HmacKey hmacKey = HmacKey.newBuilder().mergeFrom(this.aesCtrHmacAeadKey.getHmacKey()).setKeyValue(ByteString.copyFrom((byte[])hmacKeyValue)).build();
            AesCtrHmacAeadKey aeadKey = AesCtrHmacAeadKey.newBuilder().setVersion(this.aesCtrHmacAeadKey.getVersion()).setAesCtrKey(aesCtrKey).setHmacKey(hmacKey).build();
            return new AeadOrDaead(Registry.getPrimitive(this.demKeyTypeUrl, (MessageLite)aeadKey, Aead.class));
        }
        if (this.demKeyTypeUrl.equals(DeterministicAeadConfig.AES_SIV_TYPE_URL)) {
            AesSivKey daeadKey = AesSivKey.newBuilder().mergeFrom(this.aesSivKey).setKeyValue(ByteString.copyFrom((byte[])symmetricKeyValue, (int)0, (int)this.symmetricKeySize)).build();
            return new AeadOrDaead(Registry.getPrimitive(this.demKeyTypeUrl, (MessageLite)daeadKey, DeterministicAead.class));
        }
        throw new GeneralSecurityException("unknown DEM key type");
    }
}

