/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventListener;
import org.apache.james.events.Registration;
import org.apache.james.events.RegistrationKey;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.api.change.TypeStateFactory;
import org.apache.james.jmap.change.AccountIdRegistrationKey$;
import org.apache.james.jmap.change.StateChangeListener;
import org.apache.james.jmap.core.OutboundMessage;
import org.apache.james.jmap.core.PingMessage;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.core.StateChange;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.http.UserProvisioning;
import org.apache.james.jmap.json.PushSerializer;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.routes.ClientContext;
import org.apache.james.jmap.routes.EventSourceOptions;
import org.apache.james.jmap.routes.EventSourceOptionsFactory;
import org.apache.james.mailbox.MailboxSession;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import play.api.libs.json.Json$;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Uf\u0001\u0002\b\u0010\u0001iA\u0001b\n\u0001\u0003\u0006\u0004%\t\u0001\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005S!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007\u0003\u00055\u0001\t\u0005\t\u0015!\u00036\u0011!9\u0005A!A!\u0002\u0013A\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u000b]\u0003A\u0011\u0001-\t\u000bA\u0001A\u0011\t5\t\u000bQ\u0004A\u0011B;\t\u000f\u0005\u001d\u0002\u0001\"\u0003\u0002*!9\u0011q\f\u0001\u0005\n\u0005\u0005\u0004bBAD\u0001\u0011%\u0011\u0011\u0012\u0005\b\u0003K\u0003A\u0011BAT\u0005E)e/\u001a8u'>,(oY3S_V$Xm\u001d\u0006\u0003!E\taA]8vi\u0016\u001c(B\u0001\n\u0014\u0003\u0011QW.\u00199\u000b\u0005Q)\u0012!\u00026b[\u0016\u001c(B\u0001\f\u0018\u0003\u0019\t\u0007/Y2iK*\t\u0001$A\u0002pe\u001e\u001c\u0001aE\u0002\u00017\r\u0002\"\u0001H\u0011\u000e\u0003uQ!AH\u0010\u0002\t1\fgn\u001a\u0006\u0002A\u0005!!.\u0019<b\u0013\t\u0011SD\u0001\u0004PE*,7\r\u001e\t\u0003I\u0015j\u0011!E\u0005\u0003ME\u0011!BS'B!J{W\u000f^3t\u00035\tW\u000f\u001e5f]RL7-\u0019;peV\t\u0011\u0006\u0005\u0002+[5\t1F\u0003\u0002-#\u0005!\u0001\u000e\u001e;q\u0013\tq3FA\u0007BkRDWM\u001c;jG\u0006$xN]\u0001\u000fCV$\b.\u001a8uS\u000e\fGo\u001c:!\u0003=)8/\u001a:Qe>4\u0018n]5p]\u0016\u0014\bC\u0001\u00163\u0013\t\u00194F\u0001\tVg\u0016\u0014\bK]8wSNLwN\\5oO\u0006AQM^3oi\n+8\u000f\u0005\u00027s5\tqG\u0003\u00029'\u00051QM^3oiNL!AO\u001c\u0003\u0011\u00153XM\u001c;CkNDC\u0001\u0002\u001fE\u000bB\u0011QHQ\u0007\u0002})\u0011q\bQ\u0001\u0007S:TWm\u0019;\u000b\u0003\u0005\u000bQA[1wCbL!a\u0011 \u0003\u000b9\u000bW.\u001a3\u0002\u000bY\fG.^3\"\u0003\u0019\u000bAAS'B!\u0006q\u0001/^:i'\u0016\u0014\u0018.\u00197ju\u0016\u0014\bCA%M\u001b\u0005Q%BA&\u0012\u0003\u0011Q7o\u001c8\n\u00055S%A\u0004)vg\"\u001cVM]5bY&TXM]\u0001\u0011if\u0004Xm\u0015;bi\u00164\u0015m\u0019;pef\u0004\"\u0001U+\u000e\u0003ES!AU*\u0002\r\rD\u0017M\\4f\u0015\t!\u0016#A\u0002ba&L!AV)\u0003!QK\b/Z*uCR,g)Y2u_JL\u0018A\u0002\u001fj]&$h\b\u0006\u0004Z7~\u0003'm\u0019\t\u00035\u0002i\u0011a\u0004\u0005\u0006O\u001d\u0001\r!\u000b\u0015\u00057r\"U,I\u0001_\u0003!\u0011fiQ\u00179mI\n\u0004\"\u0002\u0019\b\u0001\u0004\t\u0004\"\u0002\u001b\b\u0001\u0004)\u0004\u0006\u00021=\t\u0016CQaR\u0004A\u0002!CQAT\u0004A\u0002=C#aB3\u0011\u0005u2\u0017BA4?\u0005\u0019IeN[3diR\t\u0011\u000eE\u0002k_Fl\u0011a\u001b\u0006\u0003Y6\faa\u001d;sK\u0006l'B\u00018 \u0003\u0011)H/\u001b7\n\u0005A\\'AB*ue\u0016\fW\u000e\u0005\u0002%e&\u00111/\u0005\u0002\n\u00156\u000b\u0005KU8vi\u0016\f\u0011\u0002[1oI2,7kU#\u0015\u000bY\f9!!\b\u0011\t]t\u0018\u0011A\u0007\u0002q*\u0011\u0011P_\u0001\naV\u0014G.[:iKJT!a\u001f?\u0002\t\r|'/\u001a\u0006\u0002{\u00069!/Z1di>\u0014\u0018BA@y\u0005\u0011iuN\\8\u0011\u0007q\t\u0019!C\u0002\u0002\u0006u\u0011AAV8jI\"9\u0011\u0011B\u0005A\u0002\u0005-\u0011a\u0002:fcV,7\u000f\u001e\t\u0005\u0003\u001b\tI\"\u0004\u0002\u0002\u0010)!\u0011\u0011CA\n\u0003\u0019\u0019XM\u001d<fe*\u0019A&!\u0006\u000b\u0007\u0005]A0A\u0003oKR$\u00180\u0003\u0003\u0002\u001c\u0005=!!\u0005%uiB\u001cVM\u001d<feJ+\u0017/^3ti\"9\u0011qD\u0005A\u0002\u0005\u0005\u0012\u0001\u0003:fgB|gn]3\u0011\t\u00055\u00111E\u0005\u0005\u0003K\tyA\u0001\nIiR\u00048+\u001a:wKJ\u0014Vm\u001d9p]N,\u0017a\u0003:fO&\u001cH/\u001a:T'\u0016#\u0002\"a\u000b\u0002D\u0005\u0015\u0013Q\u000b\t\u0007\u0003[\t)$!\u000f\u000e\u0005\u0005=\"bA=\u00022)\u0019\u00111\u0007>\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005]\u0012q\u0006\u0002\u0006'6{gn\u001c\t\u0005\u0003w\ty$\u0004\u0002\u0002>)\u0011\u00111G\u0005\u0005\u0003\u0003\niD\u0001\u0003V]&$\bbBA\u0010\u0015\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003\u000fR\u0001\u0019AA%\u0003\u001d\u0019Xm]:j_:\u0004B!a\u0013\u0002R5\u0011\u0011Q\n\u0006\u0004\u0003\u001f\u001a\u0012aB7bS2\u0014w\u000e_\u0005\u0005\u0003'\niE\u0001\bNC&d'm\u001c=TKN\u001c\u0018n\u001c8\t\u000f\u0005]#\u00021\u0001\u0002Z\u00059q\u000e\u001d;j_:\u001c\bc\u0001.\u0002\\%\u0019\u0011QL\b\u0003%\u00153XM\u001c;T_V\u00148-Z(qi&|gn]\u0001\u000bCN\u001c6+R#wK:$H\u0003BA2\u0003s\u0002B!!\u001a\u0002t9!\u0011qMA8!\u0011\tI'!\u0010\u000e\u0005\u0005-$bAA73\u00051AH]8pizJA!!\u001d\u0002>\u00051\u0001K]3eK\u001aLA!!\u001e\u0002x\t11\u000b\u001e:j]\u001eTA!!\u001d\u0002>!9\u00111P\u0006A\u0002\u0005u\u0014aD8vi\n|WO\u001c3NKN\u001c\u0018mZ3\u0011\t\u0005}\u00141Q\u0007\u0003\u0003\u0003S!a_\t\n\t\u0005\u0015\u0015\u0011\u0011\u0002\u0010\u001fV$(m\\;oI6+7o]1hK\u0006\u0011\u0003.\u00198eY\u0016\u001cuN\u001c8fGRLwN\\#ti\u0006\u0014G.[:i[\u0016tG/\u0012:s_J$b!a#\u0002\u000e\u0006\r\u0006CBA\u0017\u0003k\t\t\u0001C\u0004\u0002\u00102\u0001\r!!%\u0002\u0013QD'o\\<bE2,\u0007\u0003BAJ\u0003;sA!!&\u0002\u001a:!\u0011\u0011NAL\u0013\t\t\u0019$\u0003\u0003\u0002\u001c\u0006u\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003?\u000b\tKA\u0005UQJ|w/\u00192mK*!\u00111TA\u001f\u0011\u001d\ty\u0002\u0004a\u0001\u0003C\taB]3ta>tG\rR3uC&d7\u000f\u0006\u0004\u0002\f\u0006%\u00161\u0016\u0005\b\u0003?i\u0001\u0019AA\u0011\u0011\u001d\ti+\u0004a\u0001\u0003_\u000bq\u0001Z3uC&d7\u000f\u0005\u0003\u0002\u0000\u0005E\u0016\u0002BAZ\u0003\u0003\u0013a\u0002\u0015:pE2,W\u000eR3uC&d7\u000f")
public class EventSourceRoutes
implements JMAPRoutes {
    private final Authenticator authenticator;
    private final UserProvisioning userProvisioner;
    @Named(value="JMAP")
    private final EventBus eventBus;
    private final PushSerializer pushSerializer;
    private final TypeStateFactory typeStateFactory;

    public Mono<Void> handleInternalError(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleInternalError(x$1, x$2, x$3);
    }

    public Mono<Void> handleBadRequest(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleBadRequest(x$1, x$2, x$3);
    }

    public Mono<Void> handleAuthenticationFailure(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleAuthenticationFailure(x$1, x$2, x$3);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.GET, "/eventSource")).action((request, response) -> this.handleSSE(request, response)).corsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.OPTIONS, "/eventSource")).action(JMAPRoutes.CORS_CONTROL).corsHeaders()});
    }

    private Mono<Void> handleSSE(HttpServerRequest request, HttpServerResponse response) {
        return ((SMono)new EventSourceOptionsFactory(this.typeStateFactory).forRequest(request).fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)e), (Function1 & Serializable)options -> SMono$.MODULE$.apply((Publisher)this.authenticator().authenticate(request)).flatMap((Function1 & Serializable)mailboxSession -> $this.userProvisioner.provisionUser((MailboxSession)mailboxSession).then().then(this.registerSSE(response, (MailboxSession)mailboxSession, (EventSourceOptions)options))))).onErrorResume((Function1 & Serializable)throwable -> this.handleConnectionEstablishmentError((Throwable)throwable, response)).subscribeOn(Schedulers.elastic()).asJava().then();
    }

    private SMono<BoxedUnit> registerSSE(HttpServerResponse response, MailboxSession session, EventSourceOptions options) {
        Sinks.Many sink = Sinks.many().unicast().onBackpressureBuffer();
        ClientContext context = new ClientContext((Sinks.Many<OutboundMessage>)sink, new AtomicReference<Registration>(), session);
        SFlux<PingMessage> qual$1 = options.pingPolicy().asFlux();
        Function1 & Serializable x$1 = (Function1 & Serializable)ping -> {
            EventSourceRoutes.$anonfun$registerSSE$1(context, ping);
            return BoxedUnit.UNIT;
        };
        Option x$2 = qual$1.subscribe$default$2();
        Option x$3 = qual$1.subscribe$default$3();
        Disposable pingDisposable = qual$1.subscribe((Function1)x$1, x$2, x$3);
        SMono$.MODULE$.apply(this.eventBus.register((EventListener.ReactiveEventListener)new StateChangeListener(options.types(), context.outbound()), (RegistrationKey)AccountIdRegistrationKey$.MODULE$.of(session.getUser()))).doOnNext((Function1 & Serializable)newRegistration -> {
            context.withRegistration(newRegistration);
            return BoxedUnit.UNIT;
        }).subscribeOn(Schedulers.elastic()).subscribe();
        return SMono$.MODULE$.apply((Publisher)response.addHeader((CharSequence)"Connection", (CharSequence)"keep-alive").sse().sendString((Publisher)options.closeAfter().applyOn((SFlux<OutboundMessage>)SFlux$.MODULE$.apply((Publisher)sink.asFlux())).map((Function1 & Serializable)outboundMessage -> this.asSSEEvent((OutboundMessage)outboundMessage)), StandardCharsets.UTF_8).then().doFinally(x$5 -> context.clean()).doFinally(x$6 -> pingDisposable.dispose()).then()).then();
    }

    private String asSSEEvent(OutboundMessage outboundMessage) {
        String string2;
        OutboundMessage outboundMessage2 = outboundMessage;
        if (outboundMessage2 instanceof PingMessage) {
            string2 = "ping";
        } else if (outboundMessage2 instanceof StateChange) {
            string2 = "state";
        } else {
            throw new MatchError((Object)outboundMessage2);
        }
        String event = string2;
        return new StringBuilder(16).append("event: ").append(event).append("\ndata: ").append(Json$.MODULE$.stringify(this.pushSerializer.serializeSSE(outboundMessage))).append("\n\n").toString();
    }

    private SMono<Void> handleConnectionEstablishmentError(Throwable throwable, HttpServerResponse response) {
        Throwable throwable2 = throwable;
        if (throwable2 instanceof UnauthorizedException) {
            UnauthorizedException unauthorizedException = (UnauthorizedException)throwable2;
            return this.respondDetails(unauthorizedException.addHeaders(response), ProblemDetails$.MODULE$.forThrowable(throwable));
        }
        return this.respondDetails(response, ProblemDetails$.MODULE$.forThrowable(throwable));
    }

    private SMono<Void> respondDetails(HttpServerResponse response, ProblemDetails details) {
        return SMono$.MODULE$.fromPublisher((Publisher)response.status(details.status()).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").sendString((Publisher)SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details).toString()), StandardCharsets.UTF_8).then());
    }

    public static final /* synthetic */ void $anonfun$registerSSE$1(ClientContext context$1, PingMessage ping) {
        context$1.outbound().emitNext((Object)ping, Sinks.EmitFailureHandler.FAIL_FAST);
    }

    @Inject
    public EventSourceRoutes(@Named(value="RFC-8621") Authenticator authenticator, UserProvisioning userProvisioner, @Named(value="JMAP") EventBus eventBus, PushSerializer pushSerializer, TypeStateFactory typeStateFactory) {
        this.authenticator = authenticator;
        this.userProvisioner = userProvisioner;
        this.eventBus = eventBus;
        this.pushSerializer = pushSerializer;
        this.typeStateFactory = typeStateFactory;
    }
}

