/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.memory.upload;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BucketName;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.model.Upload;
import org.apache.james.jmap.api.model.UploadId;
import org.apache.james.jmap.api.model.UploadMetaData;
import org.apache.james.jmap.api.model.UploadNotFoundException;
import org.apache.james.jmap.api.upload.UploadRepository;
import org.apache.james.mailbox.model.ContentType;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import scala.Function0;

public class InMemoryUploadRepository
implements UploadRepository {
    private static final Map<UploadId, ImmutablePair<Username, UploadMetaData>> uploadStore = new HashMap<UploadId, ImmutablePair<Username, UploadMetaData>>();
    private final BlobStore blobStore;
    private final BucketName bucketName;

    @Inject
    public InMemoryUploadRepository(BlobStore blobStore) {
        this.blobStore = blobStore;
        this.bucketName = blobStore.getDefaultBucketName();
    }

    @Override
    public Publisher<UploadMetaData> upload(InputStream data, ContentType contentType, Username user) {
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkNotNull((Object)contentType);
        Preconditions.checkNotNull((Object)user);
        byte[] dataAsByte = this.toByteArray(data);
        return Mono.from((Publisher)this.blobStore.save(this.bucketName, dataAsByte, BlobStore.StoragePolicy.LOW_COST)).map(blobId -> {
            UploadId uploadId = UploadId.random();
            uploadStore.put(uploadId, (ImmutablePair<Username, UploadMetaData>)new ImmutablePair((Object)user, (Object)UploadMetaData.from(uploadId, contentType, dataAsByte.length, blobId)));
            return UploadMetaData.from(uploadId, contentType, dataAsByte.length, blobId);
        });
    }

    @Override
    public Publisher<Upload> retrieve(UploadId id, Username user) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)user);
        return Mono.justOrEmpty(uploadStore.get(id)).filter(pair -> user.equals(pair.left)).flatMap(userAndMetaData -> this.retrieveUpload((UploadMetaData)userAndMetaData.right)).switchIfEmpty(Mono.error(() -> new UploadNotFoundException(id)));
    }

    private Mono<Upload> retrieveUpload(UploadMetaData uploadMetaData) {
        return Mono.from((Publisher)this.blobStore.readBytes(this.bucketName, uploadMetaData.blobId())).map(content -> Upload.from(uploadMetaData, (Function0<InputStream>)((Function0)() -> new ByteArrayInputStream((byte[])content))));
    }

    private byte[] toByteArray(InputStream inputStream) {
        try {
            return IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

