/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum CollectSupportDataSecurityLevel {
    NONE("none"),
    OBSCURE_SECRETS("obscure-secrets"),
    MAXIMUM("maximum");

    @NotNull
    private final String name;

    private CollectSupportDataSecurityLevel(String name) {
        this.name = name;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public static CollectSupportDataSecurityLevel forName(@NotNull String name) {
        String normalizedName = StaticUtils.toLowerCase(name).replace('_', '-');
        for (CollectSupportDataSecurityLevel l : CollectSupportDataSecurityLevel.values()) {
            if (!normalizedName.equals(l.name)) continue;
            return l;
        }
        return null;
    }

    @NotNull
    public String toString() {
        return this.name;
    }
}

