/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.io.FileNotFoundException;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.blob.export.file.LocalFileBlobExportMechanism;
import org.apache.james.modules.mailbox.ConfigurationComponent;
import org.apache.james.utils.PropertiesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileBlobExportMechanismModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalFileBlobExportMechanismModule.class);

    protected void configure() {
    }

    @Singleton
    @Provides
    LocalFileBlobExportMechanism.Configuration localFileExportConfiguration(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            Configuration configuration = propertiesProvider.getConfigurations(ConfigurationComponent.NAMES);
            return LocalFileBlobExportMechanism.Configuration.from((Configuration)configuration).orElseGet(() -> {
                LOGGER.warn("Missing LocalFileBlobExportMechanism configuration, using default localFile blob exporting configuration");
                return LocalFileBlobExportMechanism.Configuration.DEFAULT_CONFIGURATION;
            });
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not find blob configuration file, using default localFile blob exporting configuration");
            return LocalFileBlobExportMechanism.Configuration.DEFAULT_CONFIGURATION;
        }
    }
}

