/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.james.jmap.draft.methods.Method;
import org.apache.james.jmap.draft.model.MailboxCreationId;
import org.apache.james.jmap.draft.model.SetError;
import org.apache.james.jmap.draft.model.mailbox.Mailbox;
import org.apache.james.mailbox.model.MailboxId;

public class SetMailboxesResponse
implements Method.Response {
    private final ImmutableMap<MailboxCreationId, Mailbox> created;
    private final ImmutableList<MailboxId> updated;
    private final ImmutableList<MailboxId> destroyed;
    private final ImmutableMap<MailboxCreationId, SetError> notCreated;
    private final ImmutableMap<MailboxId, SetError> notUpdated;
    private final ImmutableMap<MailboxId, SetError> notDestroyed;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    SetMailboxesResponse(ImmutableMap<MailboxCreationId, Mailbox> created, ImmutableList<MailboxId> updated, ImmutableList<MailboxId> destroyed, ImmutableMap<MailboxCreationId, SetError> notCreated, ImmutableMap<MailboxId, SetError> notUpdated, ImmutableMap<MailboxId, SetError> notDestroyed) {
        this.created = created;
        this.updated = updated;
        this.destroyed = destroyed;
        this.notCreated = notCreated;
        this.notUpdated = notUpdated;
        this.notDestroyed = notDestroyed;
    }

    public ImmutableMap<MailboxCreationId, Mailbox> getCreated() {
        return this.created;
    }

    public ImmutableList<MailboxId> getUpdated() {
        return this.updated;
    }

    public ImmutableList<MailboxId> getDestroyed() {
        return this.destroyed;
    }

    public Map<MailboxCreationId, SetError> getNotCreated() {
        return this.notCreated;
    }

    public ImmutableMap<MailboxId, SetError> getNotUpdated() {
        return this.notUpdated;
    }

    public ImmutableMap<MailboxId, SetError> getNotDestroyed() {
        return this.notDestroyed;
    }

    public Builder mergeInto(Builder responseBuilder) {
        return responseBuilder.created(this.getCreated()).updated((List<MailboxId>)this.getUpdated()).destroyed(this.getDestroyed()).notCreated(this.getNotCreated()).notUpdated((Map<MailboxId, SetError>)this.getNotUpdated()).notDestroyed(this.getNotDestroyed());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.created, this.notCreated, this.destroyed, this.notDestroyed});
    }

    public boolean equals(Object obj) {
        if (obj instanceof SetMailboxesResponse) {
            SetMailboxesResponse other = (SetMailboxesResponse)obj;
            return Objects.equal(this.created, other.created) && Objects.equal(this.updated, other.updated) && Objects.equal(this.destroyed, other.destroyed) && Objects.equal(this.notCreated, other.notCreated) && Objects.equal(this.notUpdated, other.notUpdated) && Objects.equal(this.notDestroyed, other.notDestroyed);
        }
        return false;
    }

    public static class Builder {
        private final ImmutableMap.Builder<MailboxCreationId, Mailbox> created = ImmutableMap.builder();
        private final ImmutableList.Builder<MailboxId> updated = ImmutableList.builder();
        private final ImmutableList.Builder<MailboxId> destroyed = ImmutableList.builder();
        private final ImmutableMap.Builder<MailboxCreationId, SetError> notCreated = ImmutableMap.builder();
        private final ImmutableMap.Builder<MailboxId, SetError> notUpdated = ImmutableMap.builder();
        private final ImmutableMap.Builder<MailboxId, SetError> notDestroyed = ImmutableMap.builder();

        private Builder() {
        }

        public Builder created(MailboxCreationId creationId, Mailbox mailbox) {
            this.created.put((Object)creationId, (Object)mailbox);
            return this;
        }

        public Builder created(ImmutableMap<MailboxCreationId, Mailbox> created) {
            this.created.putAll(created);
            return this;
        }

        public Builder updated(MailboxId mailboxId) {
            this.updated.add((Object)mailboxId);
            return this;
        }

        public Builder updated(List<MailboxId> mailboxIds) {
            this.updated.addAll(mailboxIds);
            return this;
        }

        public Builder destroyed(MailboxId mailboxId) {
            this.destroyed.add((Object)mailboxId);
            return this;
        }

        public Builder destroyed(ImmutableList<MailboxId> destroyed) {
            this.destroyed.addAll(destroyed);
            return this;
        }

        public Builder notCreated(Map<MailboxCreationId, SetError> notCreated) {
            this.notCreated.putAll(notCreated);
            return this;
        }

        public Builder notCreated(MailboxCreationId mailboxCreationId, SetError setError) {
            this.notCreated.put((Object)mailboxCreationId, (Object)setError);
            return this;
        }

        public Builder notUpdated(MailboxId mailboxId, SetError setError) {
            this.notUpdated.put((Object)mailboxId, (Object)setError);
            return this;
        }

        public Builder notUpdated(Map<MailboxId, SetError> notUpdated) {
            this.notUpdated.putAll(notUpdated);
            return this;
        }

        public Builder notDestroyed(MailboxId mailboxId, SetError setError) {
            this.notDestroyed.put((Object)mailboxId, (Object)setError);
            return this;
        }

        public Builder notDestroyed(ImmutableMap<MailboxId, SetError> notDestroyed) {
            this.notDestroyed.putAll(notDestroyed);
            return this;
        }

        public SetMailboxesResponse build() {
            return new SetMailboxesResponse((ImmutableMap<MailboxCreationId, Mailbox>)this.created.build(), (ImmutableList<MailboxId>)this.updated.build(), (ImmutableList<MailboxId>)this.destroyed.build(), (ImmutableMap<MailboxCreationId, SetError>)this.notCreated.build(), (ImmutableMap<MailboxId, SetError>)this.notUpdated.build(), (ImmutableMap<MailboxId, SetError>)this.notDestroyed.build());
        }
    }
}

