/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.apache.james.webadmin.dto.ValidatedQuotaDTO;

public class GlobalQuotaService {
    private final MaxQuotaManager maxQuotaManager;

    @Inject
    public GlobalQuotaService(MaxQuotaManager maxQuotaManager) {
        this.maxQuotaManager = maxQuotaManager;
    }

    public void defineQuota(ValidatedQuotaDTO quota) throws MailboxException {
        Optional<QuotaCountLimit> count = quota.getCount();
        if (count.isPresent()) {
            this.maxQuotaManager.setGlobalMaxMessage(count.get());
        } else {
            this.maxQuotaManager.removeGlobalMaxMessage();
        }
        Optional<QuotaSizeLimit> size = quota.getSize();
        if (size.isPresent()) {
            this.maxQuotaManager.setGlobalMaxStorage(size.get());
        } else {
            this.maxQuotaManager.removeGlobalMaxStorage();
        }
    }

    public ValidatedQuotaDTO getQuota() throws MailboxException {
        return ValidatedQuotaDTO.builder().count(this.maxQuotaManager.getGlobalMaxMessage()).size(this.maxQuotaManager.getGlobalMaxStorage()).build();
    }

    public Optional<QuotaSizeLimit> getMaxSizeQuota() throws MailboxException {
        return this.maxQuotaManager.getGlobalMaxStorage();
    }

    public void defineMaxSizeQuota(QuotaSizeLimit quotaRequest) throws MailboxException {
        this.maxQuotaManager.setGlobalMaxStorage(quotaRequest);
    }

    public void deleteMaxSizeQuota() throws MailboxException {
        this.maxQuotaManager.removeGlobalMaxStorage();
    }

    public Optional<QuotaCountLimit> getMaxCountQuota() throws MailboxException {
        return this.maxQuotaManager.getGlobalMaxMessage();
    }

    public void defineMaxCountQuota(QuotaCountLimit value) throws MailboxException {
        this.maxQuotaManager.setGlobalMaxMessage(value);
    }

    public void deleteMaxCountQuota() throws MailboxException {
        this.maxQuotaManager.removeGlobalMaxMessage();
    }
}

