/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.james.events.EventBus;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.api.message.request.ImapRequest;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SearchResUtil;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.AbstractImapRequest;
import org.apache.james.imap.message.request.AbstractMailboxSelectionRequest;
import org.apache.james.imap.message.response.ExistsResponse;
import org.apache.james.imap.message.response.RecentResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.EnableProcessor;
import org.apache.james.imap.processor.PermitEnableCapabilityProcessor;
import org.apache.james.imap.processor.base.SelectedMailboxImpl;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.metrics.api.MetricFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractSelectionProcessor<R extends AbstractMailboxSelectionRequest>
extends AbstractMailboxProcessor<R>
implements PermitEnableCapabilityProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSelectionProcessor.class);
    private static final List<Capability> CAPS = ImmutableList.of((Object)ImapConstants.SUPPORTS_QRESYNC, (Object)ImapConstants.SUPPORTS_CONDSTORE);
    private final StatusResponseFactory statusResponseFactory;
    private final boolean openReadOnly;
    private final EventBus eventBus;

    public AbstractSelectionProcessor(Class<R> acceptableClass, ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory statusResponseFactory, boolean openReadOnly, MetricFactory metricFactory, EventBus eventBus) {
        super(acceptableClass, next, mailboxManager, statusResponseFactory, metricFactory);
        this.statusResponseFactory = statusResponseFactory;
        this.openReadOnly = openReadOnly;
        this.eventBus = eventBus;
    }

    @Override
    protected void processRequest(R request, ImapSession session, ImapProcessor.Responder responder) {
        String mailboxName = ((AbstractMailboxSelectionRequest)request).getMailboxName();
        try {
            MailboxPath fullMailboxPath = PathConverter.forSession(session).buildFullPath(mailboxName);
            this.respond(session, fullMailboxPath, (AbstractMailboxSelectionRequest)request, responder);
        }
        catch (MailboxNotFoundException e) {
            LOGGER.debug("Select failed as mailbox does not exist {}", (Object)mailboxName, (Object)e);
            responder.respond(this.statusResponseFactory.taggedNo(((AbstractImapRequest)request).getTag(), ((AbstractImapRequest)request).getCommand(), HumanReadableText.FAILURE_NO_SUCH_MAILBOX));
        }
        catch (MailboxException e) {
            LOGGER.error("Select failed for mailbox {}", (Object)mailboxName, (Object)e);
            this.no((ImapRequest)request, responder, HumanReadableText.SELECT);
        }
    }

    private void respond(ImapSession session, MailboxPath fullMailboxPath, AbstractMailboxSelectionRequest request, ImapProcessor.Responder responder) throws MailboxException {
        AbstractMailboxSelectionRequest.ClientSpecifiedUidValidity lastKnownUidValidity = request.getLastKnownUidValidity();
        Long modSeq = request.getKnownModSeq();
        IdRange[] knownSequences = request.getKnownSequenceSet();
        UidRange[] knownUids = request.getKnownUidSet();
        if (!lastKnownUidValidity.isUnknown() && !EnableProcessor.getEnabledCapabilities(session).contains(ImapConstants.SUPPORTS_QRESYNC)) {
            this.taggedBad(request, responder, HumanReadableText.QRESYNC_NOT_ENABLED);
            return;
        }
        MessageManager.MailboxMetaData metaData = this.selectMailbox(fullMailboxPath, session);
        SelectedMailbox selected = session.getSelected();
        MessageUid firstUnseen = metaData.getFirstUnseen();
        this.flags(responder, selected);
        this.exists(responder, metaData);
        this.recent(responder, selected);
        this.uidValidity(responder, metaData);
        int retryCount = 0;
        while (!this.unseen(responder, firstUnseen, selected)) {
            if (retryCount == 5) {
                LOGGER.info("Unable to uid for unseen message {} in mailbox {}", (Object)firstUnseen, (Object)selected.getMailboxId().serialize());
                break;
            }
            firstUnseen = this.selectMailbox(fullMailboxPath, session).getFirstUnseen();
            ++retryCount;
        }
        this.permanentFlags(responder, metaData, selected);
        this.highestModSeq(responder, metaData);
        this.uidNext(responder, metaData);
        if (request.getCondstore()) {
            this.condstoreEnablingCommand(session, responder, metaData, false);
        }
        if (metaData.isModSeqPermanent() && !lastKnownUidValidity.isUnknown()) {
            if (lastKnownUidValidity.correspondsTo(metaData.getUidValidity())) {
                MessageUid uidNext;
                MailboxManager mailboxManager = this.getMailboxManager();
                MailboxSession mailboxSession = session.getMailboxSession();
                MessageManager mailbox = mailboxManager.getMailbox(fullMailboxPath, mailboxSession);
                UidRange[] uidSet = request.getUidSet();
                if (uidSet == null && !(uidNext = metaData.getUidNext()).isFirst()) {
                    uidSet = new UidRange[]{new UidRange(MessageUid.MIN_VALUE, uidNext.previous())};
                }
                if (uidSet != null) {
                    this.respondVanished(session, responder, modSeq, knownSequences, knownUids, metaData, selected, mailboxSession, mailbox, uidSet);
                }
                this.taggedOk(responder, request, metaData, HumanReadableText.SELECT);
            } else {
                this.taggedOk(responder, request, metaData, HumanReadableText.QRESYNC_UIDVALIDITY_MISMATCH);
            }
        } else {
            this.taggedOk(responder, request, metaData, HumanReadableText.SELECT);
        }
        SearchResUtil.resetSavedSequenceSet(session);
    }

    private void respondVanished(ImapSession session, ImapProcessor.Responder responder, Long modSeq, IdRange[] knownSequences, UidRange[] knownUids, MessageManager.MailboxMetaData metaData, SelectedMailbox selected, MailboxSession mailboxSession, MessageManager mailbox, UidRange[] uidSet) throws MailboxException {
        if (knownSequences != null && knownUids != null) {
            uidSet = this.recomputeUidSet(knownSequences, knownUids, selected, uidSet);
        }
        ArrayList<MessageRange> ranges = new ArrayList<MessageRange>();
        for (UidRange range : uidSet) {
            MessageRange messageSet = range.toMessageRange();
            if (messageSet == null) continue;
            MessageRange normalizedMessageSet = this.normalizeMessageRange(session.getSelected(), messageSet);
            ranges.add(normalizedMessageSet);
        }
        this.respondVanished(selected, ranges, modSeq, metaData, responder);
    }

    @VisibleForTesting
    UidRange[] recomputeUidSet(IdRange[] knownSequences, UidRange[] knownUids, SelectedMailbox selected, UidRange[] uidSet) {
        ArrayList<MessageUid> knownUidsList = new ArrayList<MessageUid>();
        for (UidRange range : knownUids) {
            for (MessageUid uid : range) {
                knownUidsList.add(uid);
            }
        }
        MessageUid firstUid = MessageUid.MIN_VALUE;
        int index = 0;
        for (IdRange knownSequence : knownSequences) {
            boolean done = false;
            for (Long msn : knownSequence) {
                if (knownUidsList.size() > index) {
                    int msnAsInt = msn.intValue();
                    MessageUid knownUid = (MessageUid)knownUidsList.get(index);
                    done = selected.uid(msnAsInt).filter(selectedUid -> selectedUid.equals((Object)knownUid)).isPresent();
                    if (done) break;
                    firstUid = knownUid;
                    ++index;
                    continue;
                }
                done = true;
                break;
            }
            if (!done) continue;
            firstUid = firstUid.next();
            ArrayList<UidRange> filteredUidSet = new ArrayList<UidRange>();
            for (UidRange r : uidSet) {
                if (r.getLowVal().compareTo(firstUid) < 0) {
                    if (r.getHighVal().compareTo(firstUid) <= 0) continue;
                    filteredUidSet.add(new UidRange(firstUid, r.getHighVal()));
                    continue;
                }
                filteredUidSet.add(r);
            }
            uidSet = (UidRange[])filteredUidSet.toArray(UidRange[]::new);
            break;
        }
        return uidSet;
    }

    private void highestModSeq(ImapProcessor.Responder responder, MessageManager.MailboxMetaData metaData) {
        StatusResponse untaggedOk;
        if (metaData.isModSeqPermanent()) {
            ModSeq highestModSeq = metaData.getHighestModSeq();
            untaggedOk = this.statusResponseFactory.untaggedOk(HumanReadableText.HIGHEST_MOD_SEQ, StatusResponse.ResponseCode.highestModSeq(highestModSeq));
        } else {
            untaggedOk = this.statusResponseFactory.untaggedOk(HumanReadableText.NO_MOD_SEQ, StatusResponse.ResponseCode.noModSeq());
        }
        responder.respond(untaggedOk);
    }

    private void uidNext(ImapProcessor.Responder responder, MessageManager.MailboxMetaData metaData) {
        MessageUid uid = metaData.getUidNext();
        StatusResponse untaggedOk = this.statusResponseFactory.untaggedOk(HumanReadableText.UIDNEXT, StatusResponse.ResponseCode.uidNext(uid));
        responder.respond(untaggedOk);
    }

    private void taggedOk(ImapProcessor.Responder responder, ImapRequest request, MessageManager.MailboxMetaData metaData, HumanReadableText text) {
        boolean writeable = metaData.isWriteable() && !this.openReadOnly;
        StatusResponse.ResponseCode code = writeable ? StatusResponse.ResponseCode.readWrite() : StatusResponse.ResponseCode.readOnly();
        StatusResponse taggedOk = this.statusResponseFactory.taggedOk(request.getTag(), request.getCommand(), text, code);
        responder.respond(taggedOk);
    }

    private boolean unseen(ImapProcessor.Responder responder, MessageUid firstUnseen, SelectedMailbox selected) throws MailboxException {
        if (firstUnseen != null) {
            MessageUid unseenUid = firstUnseen;
            return selected.msn(unseenUid).fold(() -> {
                LOGGER.debug("No message found with uid {} in mailbox {}", (Object)unseenUid, (Object)selected.getMailboxId().serialize());
                return false;
            }, msn -> {
                StatusResponse untaggedOk = this.statusResponseFactory.untaggedOk(HumanReadableText.unseen(msn), StatusResponse.ResponseCode.unseen(msn));
                responder.respond(untaggedOk);
                return true;
            });
        }
        return true;
    }

    private void uidValidity(ImapProcessor.Responder responder, MessageManager.MailboxMetaData metaData) {
        UidValidity uidValidity = metaData.getUidValidity();
        StatusResponse untaggedOk = this.statusResponseFactory.untaggedOk(HumanReadableText.UID_VALIDITY, StatusResponse.ResponseCode.uidValidity(uidValidity));
        responder.respond(untaggedOk);
    }

    private void recent(ImapProcessor.Responder responder, SelectedMailbox selected) {
        int recentCount = selected.recentCount();
        RecentResponse recentResponse = new RecentResponse(recentCount);
        responder.respond(recentResponse);
    }

    private void exists(ImapProcessor.Responder responder, MessageManager.MailboxMetaData metaData) {
        long messageCount = metaData.getMessageCount();
        ExistsResponse existsResponse = new ExistsResponse(messageCount);
        responder.respond(existsResponse);
    }

    private MessageManager.MailboxMetaData selectMailbox(MailboxPath mailboxPath, ImapSession session) throws MailboxException {
        SelectedMailbox sessionMailbox;
        MailboxManager mailboxManager = this.getMailboxManager();
        MailboxSession mailboxSession = session.getMailboxSession();
        MessageManager mailbox = mailboxManager.getMailbox(mailboxPath, mailboxSession);
        SelectedMailbox currentMailbox = session.getSelected();
        if (currentMailbox == null || !currentMailbox.getMailboxId().equals(mailbox.getId())) {
            if (currentMailbox != null) {
                this.getStatusResponseFactory().untaggedOk(HumanReadableText.QRESYNC_CLOSED, StatusResponse.ResponseCode.closed());
            }
            session.selected(new SelectedMailboxImpl(this.getMailboxManager(), this.eventBus, session, mailbox));
            sessionMailbox = session.getSelected();
        } else {
            sessionMailbox = currentMailbox;
        }
        MessageManager.MailboxMetaData metaData = mailbox.getMetaData(!this.openReadOnly, mailboxSession, MessageManager.MailboxMetaData.FetchGroup.FIRST_UNSEEN);
        this.addRecent(metaData, sessionMailbox);
        return metaData;
    }

    private void addRecent(MessageManager.MailboxMetaData metaData, SelectedMailbox sessionMailbox) {
        List recentUids = metaData.getRecent();
        for (MessageUid uid : recentUids) {
            sessionMailbox.addRecent(uid);
        }
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return CAPS;
    }

    @Override
    public List<Capability> getPermitEnableCapabilities(ImapSession session) {
        return CAPS;
    }

    @Override
    public void enable(ImapMessage message, ImapProcessor.Responder responder, ImapSession session, Capability capability) throws PermitEnableCapabilityProcessor.EnableException {
        if (!EnableProcessor.getEnabledCapabilities(session).contains(capability)) {
            SelectedMailbox sm = session.getSelected();
            if (capability.equals(ImapConstants.SUPPORTS_CONDSTORE) || capability.equals(ImapConstants.SUPPORTS_QRESYNC)) {
                try {
                    MessageManager.MailboxMetaData metaData = null;
                    boolean send = false;
                    if (sm != null) {
                        MessageManager mailbox = this.getSelectedMailbox(session).orElseThrow(() -> new MailboxException("Session not in SELECTED state"));
                        metaData = mailbox.getMetaData(false, session.getMailboxSession(), MessageManager.MailboxMetaData.FetchGroup.NO_COUNT);
                        send = true;
                    }
                    this.condstoreEnablingCommand(session, responder, metaData, send);
                }
                catch (MailboxException e) {
                    throw new PermitEnableCapabilityProcessor.EnableException("Unable to enable " + capability.asString(), e);
                }
            }
        }
    }
}

