/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.offheap.bytez.niobuffers;

import java.nio.ByteBuffer;
import org.nustaq.offheap.bytez.BasicBytez;

public class ByteBufferBasicBytez
implements BasicBytez {
    ByteBuffer buffer;

    public ByteBufferBasicBytez(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public byte get(long byteIndex) {
        return this.buffer.get((int)byteIndex);
    }

    @Override
    public boolean getBool(long byteIndex) {
        return this.buffer.get((int)byteIndex) != 0;
    }

    @Override
    public char getChar(long byteIndex) {
        return this.buffer.getChar((int)byteIndex);
    }

    @Override
    public short getShort(long byteIndex) {
        return this.buffer.getShort((int)byteIndex);
    }

    @Override
    public int getInt(long byteIndex) {
        return this.buffer.getInt((int)byteIndex);
    }

    @Override
    public long getLong(long byteIndex) {
        return this.buffer.getLong((int)byteIndex);
    }

    @Override
    public float getFloat(long byteIndex) {
        return this.buffer.getFloat((int)byteIndex);
    }

    @Override
    public double getDouble(long byteIndex) {
        return this.buffer.getDouble((int)byteIndex);
    }

    @Override
    public void put(long byteIndex, byte value) {
        this.buffer.put((int)byteIndex, value);
    }

    @Override
    public void putBool(long byteIndex, boolean val) {
        this.buffer.put((int)byteIndex, (byte)(val ? 1 : 0));
    }

    @Override
    public void putChar(long byteIndex, char c) {
        this.buffer.putChar((int)byteIndex, c);
    }

    @Override
    public void putShort(long byteIndex, short s2) {
        this.buffer.putShort((int)byteIndex, s2);
    }

    @Override
    public void putInt(long byteIndex, int i) {
        this.buffer.putInt((int)byteIndex, i);
    }

    @Override
    public void putLong(long byteIndex, long l) {
        this.buffer.putLong((int)byteIndex, l);
    }

    @Override
    public void putFloat(long byteIndex, float f) {
        this.buffer.putFloat((int)byteIndex, f);
    }

    @Override
    public void putDouble(long byteIndex, double d) {
        this.buffer.putDouble((int)byteIndex, d);
    }

    @Override
    public long length() {
        return this.buffer.limit();
    }

    @Override
    public void getArr(long byteIndex, byte[] target, int elemoff, int numElems) {
        int position = this.buffer.position();
        this.buffer.position((int)byteIndex);
        this.buffer.get(target, elemoff, numElems);
        this.buffer.position(position);
    }

    @Override
    public void getCharArr(long byteIndex, char[] target, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            target[i + elemoff] = this.buffer.getChar((int)(byteIndex + (long)(i * 2)));
        }
    }

    @Override
    public void getShortArr(long byteIndex, short[] target, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            target[i + elemoff] = this.buffer.getShort((int)(byteIndex + (long)(i * 2)));
        }
    }

    @Override
    public void getIntArr(long byteIndex, int[] target, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            target[i + elemoff] = this.buffer.getInt((int)(byteIndex + (long)(i * 4)));
        }
    }

    @Override
    public void getLongArr(long byteIndex, long[] target, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            target[i + elemoff] = this.buffer.getLong((int)(byteIndex + (long)(i * 8)));
        }
    }

    @Override
    public void getFloatArr(long byteIndex, float[] target, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            target[i + elemoff] = this.buffer.getFloat((int)(byteIndex + (long)(i * 4)));
        }
    }

    @Override
    public void getDoubleArr(long byteIndex, double[] target, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            target[i + elemoff] = this.buffer.getDouble((int)(byteIndex + (long)(i * 8)));
        }
    }

    @Override
    public void getBooleanArr(long byteIndex, boolean[] target, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            target[i + elemoff] = this.buffer.getInt((int)(byteIndex + (long)i)) != 0;
        }
    }

    @Override
    public void set(long byteIndex, byte[] source, int elemoff, int numElems) {
        int position = this.buffer.position();
        this.buffer.position((int)byteIndex);
        this.buffer.put(source, elemoff, numElems);
        this.buffer.position(position);
    }

    @Override
    public void setChar(long byteIndex, char[] source, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            this.buffer.putChar((int)(byteIndex + (long)(2 * i)), source[i + elemoff]);
        }
    }

    @Override
    public void setShort(long byteIndex, short[] source, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            this.buffer.putShort((int)(byteIndex + (long)(2 * i)), source[i + elemoff]);
        }
    }

    @Override
    public void setInt(long byteIndex, int[] source, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            this.buffer.putInt((int)(byteIndex + (long)(4 * i)), source[i + elemoff]);
        }
    }

    @Override
    public void setLong(long byteIndex, long[] source, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            this.buffer.putLong((int)(byteIndex + (long)(8 * i)), source[i + elemoff]);
        }
    }

    @Override
    public void setFloat(long byteIndex, float[] source, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            this.buffer.putFloat((int)(byteIndex + (long)(4 * i)), source[i + elemoff]);
        }
    }

    @Override
    public void setDouble(long byteIndex, double[] source, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            this.buffer.putDouble((int)(byteIndex + (long)(8 * i)), source[i + elemoff]);
        }
    }

    @Override
    public void setBoolean(long byteIndex, boolean[] source, int elemoff, int siz) {
        for (int i = 0; i < siz; ++i) {
            this.buffer.put((int)(byteIndex + (long)i), (byte)(source[i + elemoff] ? 1 : 0));
        }
    }

    @Override
    public void copyTo(BasicBytez other, long otherByteIndex, long myByteIndex, long lenBytes) {
        for (long i = 0L; i < lenBytes; ++i) {
            other.put(otherByteIndex + i, this.get(myByteIndex + i));
        }
    }

    @Override
    public BasicBytez newInstance(long size) {
        return new ByteBufferBasicBytez(ByteBuffer.allocate((int)size));
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }
}

