/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.serializers;

import java.io.IOException;
import java.util.ArrayList;
import org.nustaq.serialization.FSTBasicObjectSerializer;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;
import org.nustaq.serialization.util.FSTUtil;

public class FSTArrayListSerializer
extends FSTBasicObjectSerializer {
    @Override
    public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
        ArrayList col = (ArrayList)toWrite;
        int size = col.size();
        out.writeInt(size);
        Class<?> lastClz = null;
        FSTClazzInfo lastInfo = null;
        for (int i = 0; i < size; ++i) {
            Object o = col.get(i);
            if (o != null) {
                lastInfo = out.writeObjectInternal(o, o.getClass() == lastClz ? lastInfo : null, null);
                lastClz = o.getClass();
                continue;
            }
            out.writeObjectInternal(o, null, null);
        }
    }

    @Override
    public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPosition) throws Exception {
        try {
            int len = in.readInt();
            ArrayList<Object> res = new ArrayList<Object>(len);
            in.registerObject(res, streamPosition, serializationInfo, referencee);
            for (int i = 0; i < len; ++i) {
                Object o = in.readObjectInternal(null);
                res.add(o);
            }
            return res;
        }
        catch (Throwable th) {
            FSTUtil.rethrow(th);
            return null;
        }
    }
}

