/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.GeoBounds;
import org.opensearch.client.opensearch._types.query_dsl.GeoExecution;
import org.opensearch.client.opensearch._types.query_dsl.GeoValidationMethod;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class GeoBoundingBoxQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    private final GeoBounds boundingBox;
    @Nullable
    private final GeoExecution type;
    @Nullable
    private final GeoValidationMethod validationMethod;
    @Nullable
    private final Boolean ignoreUnmapped;
    public static final JsonpDeserializer<GeoBoundingBoxQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoBoundingBoxQuery::setupGeoBoundingBoxQueryDeserializer);

    private GeoBoundingBoxQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.boundingBox = ApiTypeHelper.requireNonNull(builder.boundingBox, this, "boundingBox");
        this.type = builder.type;
        this.validationMethod = builder.validationMethod;
        this.ignoreUnmapped = builder.ignoreUnmapped;
    }

    public static GeoBoundingBoxQuery of(Function<Builder, ObjectBuilder<GeoBoundingBoxQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.GeoBoundingBox;
    }

    public final String field() {
        return this.field;
    }

    public final GeoBounds boundingBox() {
        return this.boundingBox;
    }

    @Deprecated
    @Nullable
    public final GeoExecution type() {
        return this.type;
    }

    @Nullable
    public final GeoValidationMethod validationMethod() {
        return this.validationMethod;
    }

    @Nullable
    public final Boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey(this.field);
        this.boundingBox.serialize(generator, mapper);
        super.serializeInternal(generator, mapper);
        if (this.type != null) {
            generator.writeKey("type");
            this.type.serialize(generator, mapper);
        }
        if (this.validationMethod != null) {
            generator.writeKey("validation_method");
            this.validationMethod.serialize(generator, mapper);
        }
        if (this.ignoreUnmapped != null) {
            generator.writeKey("ignore_unmapped");
            generator.write(this.ignoreUnmapped.booleanValue());
        }
    }

    protected static void setupGeoBoundingBoxQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::type, GeoExecution._DESERIALIZER, "type");
        op.add(Builder::validationMethod, GeoValidationMethod._DESERIALIZER, "validation_method");
        op.add(Builder::ignoreUnmapped, JsonpDeserializer.booleanDeserializer(), "ignore_unmapped");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            builder.field((String)name);
            builder.boundingBox(GeoBounds._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoBoundingBoxQuery> {
        private String field;
        private GeoBounds boundingBox;
        @Nullable
        private GeoExecution type;
        @Nullable
        private GeoValidationMethod validationMethod;
        @Nullable
        private Boolean ignoreUnmapped;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder boundingBox(GeoBounds value) {
            this.boundingBox = value;
            return this;
        }

        public final Builder boundingBox(Function<GeoBounds.Builder, ObjectBuilder<GeoBounds>> fn) {
            return this.boundingBox(fn.apply(new GeoBounds.Builder()).build());
        }

        @Deprecated
        public final Builder type(@Nullable GeoExecution value) {
            this.type = value;
            return this;
        }

        public final Builder validationMethod(@Nullable GeoValidationMethod value) {
            this.validationMethod = value;
            return this;
        }

        public final Builder ignoreUnmapped(@Nullable Boolean value) {
            this.ignoreUnmapped = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoBoundingBoxQuery build() {
            this._checkSingleUse();
            return new GeoBoundingBoxQuery(this);
        }
    }
}

