/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.util;

import jakarta.json.stream.JsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.zip.GZIPOutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.NdJsonpSerializable;

public class OpenSearchRequestBodyBuffer {
    private static final byte[] NO_BYTES = new byte[0];
    private final OutputBuffer outputBuffer = new OutputBuffer();
    private final CompressingOutputBuffer captureBuffer;
    private final JsonpMapper mapper;
    private final JsonGenerator jsonGenerator;
    private boolean hasContent = false;
    private boolean isMulti = false;
    private boolean isClosed = false;
    private byte[] arrayMemo = null;

    public OpenSearchRequestBodyBuffer(JsonpMapper mapper, int requestCompressionSize) {
        this.captureBuffer = new CompressingOutputBuffer(this.outputBuffer, requestCompressionSize);
        this.mapper = mapper;
        this.jsonGenerator = mapper.jsonProvider().createGenerator((OutputStream)this.captureBuffer);
    }

    public void addContent(Object content) throws IOException {
        if (this.hasContent && !this.isMulti) {
            this.captureBuffer.write(10);
            this.isMulti = true;
        }
        this.hasContent = true;
        if (content instanceof NdJsonpSerializable) {
            this.isMulti = true;
            this.addNdJson((NdJsonpSerializable)content);
        } else {
            this.mapper.serialize(content, this.jsonGenerator);
            this.jsonGenerator.flush();
            if (this.isMulti) {
                this.captureBuffer.write(10);
            }
        }
    }

    private void addNdJson(NdJsonpSerializable content) throws IOException {
        Iterator<?> values = content._serializables();
        while (values.hasNext()) {
            Object value = values.next();
            if (value instanceof NdJsonpSerializable && value != content) {
                this.addNdJson((NdJsonpSerializable)value);
                continue;
            }
            this.hasContent = true;
            this.mapper.serialize(value, this.jsonGenerator);
            this.jsonGenerator.flush();
            this.captureBuffer.write(10);
        }
    }

    public boolean isCompressed() {
        return this.captureBuffer.isCompressed();
    }

    public boolean isNdJson() {
        return this.isMulti;
    }

    @CheckForNull
    public String getContentEncoding() {
        if (this.captureBuffer.isCompressed()) {
            return "gzip";
        }
        return null;
    }

    @Nonnull
    public String getContentType() {
        return "application/json";
    }

    public long getContentLength() {
        this.ensureClosed();
        return this.outputBuffer.size();
    }

    public byte[] getByteArray() {
        if (this.arrayMemo == null) {
            this.ensureClosed();
            this.arrayMemo = this.outputBuffer.size() <= 0 ? NO_BYTES : this.outputBuffer.toByteArray();
        }
        return this.arrayMemo;
    }

    public InputStream getInputStream() {
        this.ensureClosed();
        if (this.outputBuffer.size() <= 0) {
            return new ByteArrayInputStream(NO_BYTES);
        }
        return this.outputBuffer.toInputStream();
    }

    public void close() throws IOException {
        if (!this.isClosed) {
            this.isClosed = true;
            this.jsonGenerator.close();
            this.captureBuffer.close();
        }
    }

    private void ensureClosed() {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class CompressingOutputBuffer
    extends OutputStream {
        private final OutputBuffer outputBuffer;
        private final int requestCompressionSize;
        private OutputStream delegate;
        private int bytesUntilCompression;
        private boolean isCompressed;

        private CompressingOutputBuffer(OutputBuffer outputBuffer, int requestCompressionSize) {
            this.outputBuffer = outputBuffer;
            this.delegate = outputBuffer;
            this.requestCompressionSize = requestCompressionSize;
            this.bytesUntilCompression = requestCompressionSize;
            this.isCompressed = false;
        }

        public boolean isCompressed() {
            return this.isCompressed;
        }

        @Override
        public void write(byte[] b) throws IOException {
            if ((this.bytesUntilCompression -= b.length) < 0) {
                this.checkCompress();
            }
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if ((this.bytesUntilCompression -= len) < 0) {
                this.checkCompress();
            }
            this.delegate.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            if (--this.bytesUntilCompression < 0) {
                this.checkCompress();
            }
            this.delegate.write(b);
        }

        private void checkCompress() throws IOException {
            if (this.delegate == this.outputBuffer && this.requestCompressionSize < Integer.MAX_VALUE) {
                this.bytesUntilCompression = Integer.MAX_VALUE;
                byte[] uncompressed = this.outputBuffer.toByteArray();
                this.outputBuffer.reset();
                this.delegate = new GZIPOutputStream(this.outputBuffer);
                if (uncompressed.length > 0) {
                    this.delegate.write(uncompressed);
                }
                this.isCompressed = true;
            }
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
            this.delegate = ClosedOutputBuffer.INSTANCE;
        }
    }

    private static class ClosedOutputBuffer
    extends OutputStream {
        static final ClosedOutputBuffer INSTANCE = new ClosedOutputBuffer();

        private ClosedOutputBuffer() {
        }

        @Override
        public void write(int b) throws IOException {
            throw new IOException("write to closed stream");
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class OutputBuffer
    extends ByteArrayOutputStream {
        private OutputBuffer() {
        }

        InputStream toInputStream() {
            return new ByteArrayInputStream(this.buf, 0, this.count);
        }
    }
}

