/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import org.apache.activemq.artemis.utils.AbstractLatch;

public class AutomaticLatch
extends AbstractLatch {
    volatile Runnable afterCompletion;

    public AutomaticLatch() {
    }

    public AutomaticLatch(int count) {
        super(count);
    }

    public void afterCompletion(Runnable newRun) {
        this.countUp();
        if (this.afterCompletion != null) {
            Runnable oldRun = this.afterCompletion;
            this.afterCompletion = () -> {
                oldRun.run();
                newRun.run();
            };
        } else {
            this.afterCompletion = newRun;
        }
        this.countDown();
    }

    @Override
    public final void countDown() {
        if (this.control.releaseShared(1)) {
            this.doRun();
        }
    }

    private void doRun() {
        Runnable toRun = this.afterCompletion;
        this.afterCompletion = null;
        if (toRun != null) {
            toRun.run();
        }
    }

    @Override
    public final void countDown(int count) {
        if (this.control.releaseShared(count)) {
            this.doRun();
        }
    }
}

