/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.execute.ExecAggregator;
import org.apache.derby.iapi.types.DataValueDescriptor;

abstract class SystemAggregator
implements ExecAggregator {
    private boolean eliminatedNulls;

    SystemAggregator() {
    }

    @Override
    public boolean didEliminateNulls() {
        return this.eliminatedNulls;
    }

    @Override
    public void accumulate(DataValueDescriptor dataValueDescriptor, Object object) throws StandardException {
        if (dataValueDescriptor == null || dataValueDescriptor.isNull()) {
            this.eliminatedNulls = true;
            return;
        }
        this.accumulate(dataValueDescriptor);
    }

    protected abstract void accumulate(DataValueDescriptor var1) throws StandardException;

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeBoolean(this.eliminatedNulls);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.eliminatedNulls = objectInput.readBoolean();
    }

    public String toString() {
        try {
            return super.toString() + "[" + this.getResult().getString() + "]";
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }
}

