/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.jpa;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.MimeMessage;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.NoResultException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.jpa.EntityManagerUtils;
import org.apache.james.core.MailAddress;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.mailrepository.api.Initializable;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.mailrepository.jpa.MimeMessageJPASource;
import org.apache.james.mailrepository.jpa.model.JPAMail;
import org.apache.james.server.core.MailImpl;
import org.apache.james.server.core.MimeMessageSource;
import org.apache.james.server.core.MimeMessageWrapper;
import org.apache.james.util.AuditTrail;
import org.apache.james.util.streams.Iterators;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.PerRecipientHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAMailRepository
implements MailRepository,
Configurable,
Initializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JPAMailRepository.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private String repositoryName;
    private final EntityManagerFactory entityManagerFactory;

    @Inject
    public JPAMailRepository(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public JPAMailRepository(EntityManagerFactory entityManagerFactory, MailRepositoryUrl url) throws ConfigurationException {
        this.entityManagerFactory = entityManagerFactory;
        this.repositoryName = url.getPath().asString();
        if (this.repositoryName.isEmpty()) {
            throw new ConfigurationException("Malformed destinationURL - Must be of the format 'jpa://<repositoryName>'.  Was passed " + String.valueOf(url));
        }
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    protected EntityManager entityManager() {
        return this.entityManagerFactory.createEntityManager();
    }

    public void configure(HierarchicalConfiguration<ImmutableNode> configuration) throws ConfigurationException {
        LOGGER.debug("{}.configure()", (Object)this.getClass().getName());
        String destination = configuration.getString("[@destinationURL]");
        MailRepositoryUrl url = MailRepositoryUrl.from((String)destination);
        this.repositoryName = url.getPath().asString();
        if (this.repositoryName.isEmpty()) {
            throw new ConfigurationException("Malformed destinationURL - Must be of the format 'jpa://<repositoryName>'.  Was passed " + String.valueOf(url));
        }
        LOGGER.debug("Parsed URL: repositoryName = '{}'", (Object)this.repositoryName);
    }

    @PostConstruct
    public void init() throws Exception {
        LOGGER.debug("{}.initialize()", (Object)this.getClass().getName());
        this.list();
    }

    public MailKey store(Mail mail) throws MessagingException {
        MailKey key = MailKey.forMail((Mail)mail);
        EntityManager entityManager = this.entityManager();
        try {
            JPAMail jpaMail = new JPAMail();
            jpaMail.setRepositoryName(this.repositoryName);
            jpaMail.setMessageName(mail.getName());
            jpaMail.setMessageState(mail.getState());
            jpaMail.setErrorMessage(mail.getErrorMessage());
            if (!mail.getMaybeSender().isNullSender()) {
                jpaMail.setSender(mail.getMaybeSender().get().toString());
            }
            String recipients = mail.getRecipients().stream().map(MailAddress::toString).collect(Collectors.joining("\r\n"));
            jpaMail.setRecipients(recipients);
            jpaMail.setRemoteHost(mail.getRemoteHost());
            jpaMail.setRemoteAddr(mail.getRemoteAddr());
            jpaMail.setPerRecipientHeaders(this.serializePerRecipientHeaders(mail.getPerRecipientSpecificHeaders()));
            jpaMail.setLastUpdated(new Timestamp(mail.getLastUpdated().getTime()));
            jpaMail.setMessageBody(this.getBody(mail));
            jpaMail.setMessageAttributes(this.serializeAttributes(mail.attributes()));
            EntityTransaction transaction = entityManager.getTransaction();
            transaction.begin();
            jpaMail = (JPAMail)entityManager.merge((Object)jpaMail);
            transaction.commit();
            AuditTrail.entry().protocol("mailrepository").action("store").parameters((Supplier)Throwing.supplier(() -> ImmutableMap.of((Object)"mailId", (Object)mail.getName(), (Object)"mimeMessageId", (Object)Optional.ofNullable(mail.getMessage()).map(Throwing.function(MimeMessage::getMessageID)).orElse(""), (Object)"sender", (Object)mail.getMaybeSender().asString(), (Object)"recipients", (Object)StringUtils.join((Object[])new Collection[]{mail.getRecipients()})))).log("JPAMailRepository stored mail.");
            MailKey mailKey = key;
            return mailKey;
        }
        catch (MessagingException e) {
            LOGGER.error("Exception caught while storing mail {}", (Object)key, (Object)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Exception caught while storing mail {}", (Object)key, (Object)e);
            throw new MessagingException("Exception caught while storing mail " + String.valueOf(key), e);
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }

    private byte[] getBody(Mail mail) throws MessagingException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream((int)mail.getMessageSize());
        if (mail instanceof MimeMessageWrapper) {
            ((MimeMessageWrapper)mail).loadMessage();
            ((MimeMessageWrapper)mail).writeTo((OutputStream)out, (OutputStream)out, null, true);
        } else {
            mail.getMessage().writeTo((OutputStream)out);
        }
        return out.toByteArray();
    }

    private String serializeAttributes(Stream<Attribute> attributes) {
        Map map = (Map)attributes.flatMap(entry -> entry.getValue().toJson().map(value -> Pair.of((Object)entry.getName().asString(), (Object)value)).stream()).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
        return new ObjectNode(JsonNodeFactory.instance, map).toString();
    }

    private List<Attribute> deserializeAttributes(String data) {
        try {
            JsonNode jsonNode = OBJECT_MAPPER.readTree(data);
            if (jsonNode instanceof ObjectNode) {
                ObjectNode objectNode = (ObjectNode)jsonNode;
                return (List)Iterators.toStream((Iterator)objectNode.fields()).map(entry -> new Attribute(AttributeName.of((String)((String)entry.getKey())), AttributeValue.fromJson((JsonNode)((JsonNode)entry.getValue())))).collect(ImmutableList.toImmutableList());
            }
            throw new IllegalArgumentException("JSON object corresponding to mail attibutes must be a JSON object");
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Mail attributes is not a valid JSON object", e);
        }
    }

    private String serializePerRecipientHeaders(PerRecipientHeaders perRecipientHeaders) {
        if (perRecipientHeaders == null) {
            return null;
        }
        Map map = perRecipientHeaders.getHeadersByRecipient().asMap();
        if (map.isEmpty()) {
            return null;
        }
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        for (Map.Entry entry : map.entrySet()) {
            String recipient = ((MailAddress)entry.getKey()).asString();
            ObjectNode headers = node.putObject(recipient);
            ((Collection)entry.getValue()).forEach(header -> headers.put(header.getName(), header.getValue()));
        }
        return node.toString();
    }

    private PerRecipientHeaders deserializePerRecipientHeaders(String data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        PerRecipientHeaders perRecipientHeaders = new PerRecipientHeaders();
        try {
            JsonNode node = OBJECT_MAPPER.readTree(data);
            if (node instanceof ObjectNode) {
                ObjectNode objectNode = (ObjectNode)node;
                Iterators.toStream((Iterator)objectNode.fields()).forEach(entry -> this.addPerRecipientHeaders(perRecipientHeaders, (String)entry.getKey(), (JsonNode)entry.getValue()));
                return perRecipientHeaders;
            }
            throw new IllegalArgumentException("JSON object corresponding to recipient headers must be a JSON object");
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("per recipient headers is not a valid JSON object", e);
        }
    }

    private void addPerRecipientHeaders(PerRecipientHeaders perRecipientHeaders, String recipient, JsonNode headers) {
        try {
            MailAddress address = new MailAddress(recipient);
            Iterators.toStream((Iterator)headers.fields()).forEach(entry -> {
                String name = (String)entry.getKey();
                String value = ((JsonNode)entry.getValue()).textValue();
                PerRecipientHeaders.Header header = PerRecipientHeaders.Header.builder().name(name).value(value).build();
                perRecipientHeaders.addHeaderForRecipient(header, address);
            });
        }
        catch (AddressException ae) {
            throw new IllegalArgumentException("invalid recipient address", ae);
        }
    }

    public Mail retrieve(MailKey key) throws MessagingException {
        EntityManager entityManager = this.entityManager();
        try {
            JPAMail jpaMail = (JPAMail)entityManager.createNamedQuery("findMailMessage", JPAMail.class).setParameter("repositoryName", (Object)this.repositoryName).setParameter("messageName", (Object)key.asString()).getSingleResult();
            MailImpl.Builder mail = MailImpl.builder().name(key.asString());
            if (jpaMail.getMessageAttributes() != null) {
                mail.addAttributes(this.deserializeAttributes(jpaMail.getMessageAttributes()));
            }
            mail.state(jpaMail.getMessageState());
            mail.errorMessage(jpaMail.getErrorMessage());
            String sender = jpaMail.getSender();
            if (sender == null) {
                mail.sender((MailAddress)null);
            } else {
                mail.sender(new MailAddress(sender));
            }
            StringTokenizer st = new StringTokenizer(jpaMail.getRecipients(), "\r\n", false);
            while (st.hasMoreTokens()) {
                mail.addRecipient(st.nextToken());
            }
            mail.remoteHost(jpaMail.getRemoteHost());
            mail.remoteAddr(jpaMail.getRemoteAddr());
            PerRecipientHeaders perRecipientHeaders = this.deserializePerRecipientHeaders(jpaMail.getPerRecipientHeaders());
            if (perRecipientHeaders != null) {
                mail.addAllHeadersForRecipients(perRecipientHeaders);
            }
            mail.lastUpdated((Date)jpaMail.getLastUpdated());
            MimeMessageJPASource source = new MimeMessageJPASource(this, key.asString(), jpaMail.getMessageBody());
            MimeMessageWrapper message = new MimeMessageWrapper((MimeMessageSource)source);
            mail.mimeMessage((MimeMessage)message);
            MailImpl mailImpl = mail.build();
            return mailImpl;
        }
        catch (NoResultException nre) {
            LOGGER.debug("Did not find mail {} in repository {}", (Object)key, (Object)this.repositoryName);
            Mail mail = null;
            return mail;
        }
        catch (Exception e) {
            throw new MessagingException("Exception while retrieving mail: " + e.getMessage(), e);
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }

    public long size() throws MessagingException {
        EntityManager entityManager = this.entityManager();
        try {
            long l = (Long)entityManager.createNamedQuery("countMailMessages", Long.TYPE).setParameter("repositoryName", (Object)this.repositoryName).getSingleResult();
            return l;
        }
        catch (Exception me) {
            throw new MessagingException("Exception while listing messages: " + me.getMessage(), me);
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }

    public Iterator<MailKey> list() throws MessagingException {
        EntityManager entityManager = this.entityManager();
        try {
            Iterator<MailKey> iterator = entityManager.createNamedQuery("listMailMessages", String.class).setParameter("repositoryName", (Object)this.repositoryName).getResultStream().map(MailKey::new).iterator();
            return iterator;
        }
        catch (Exception me) {
            throw new MessagingException("Exception while listing messages: " + me.getMessage(), me);
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }

    public void remove(MailKey key) throws MessagingException {
        this.remove(Collections.singleton(key));
    }

    public void remove(Collection<MailKey> keys) throws MessagingException {
        Collection messageNames = keys.stream().map(MailKey::asString).collect(Collectors.toList());
        EntityManager entityManager = this.entityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        transaction.begin();
        try {
            entityManager.createNamedQuery("deleteMailMessages").setParameter("repositoryName", (Object)this.repositoryName).setParameter("messageNames", (Object)messageNames).executeUpdate();
            transaction.commit();
        }
        catch (Exception e) {
            throw new MessagingException("Exception while removing message(s): " + e.getMessage(), e);
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }

    public void removeAll() throws MessagingException {
        EntityManager entityManager = this.entityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        transaction.begin();
        try {
            entityManager.createNamedQuery("deleteAllMailMessages").setParameter("repositoryName", (Object)this.repositoryName).executeUpdate();
            transaction.commit();
        }
        catch (Exception e) {
            throw new MessagingException("Exception while removing message(s): " + e.getMessage(), e);
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof JPAMailRepository && Objects.equals(this.repositoryName, ((JPAMailRepository)obj).repositoryName);
    }

    public int hashCode() {
        return Objects.hash(this.repositoryName);
    }
}

