/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.remote.delivery;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableListMultimap;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.SendFailedException;
import jakarta.mail.Session;
import jakarta.mail.URLName;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.mailets.remote.delivery.ExecutionResult;
import org.apache.james.transport.mailets.remote.delivery.RemoteDeliveryConfiguration;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.DsnParameters;
import org.apache.mailet.HostAddress;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;
import org.apache.mailet.base.Converter7Bit;
import org.eclipse.angus.mail.smtp.SMTPMessage;
import org.eclipse.angus.mail.smtp.SMTPTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailDelivrerToHost {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailDelivrerToHost.class);
    public static final String BIT_MIME_8 = "8BITMIME";
    public static final String REQUIRE_TLS = "REQUIRETLS";
    public static final String STARTTLS = "STARTTLS";
    public static final String MT_PRIORITY = "MT-PRIORITY";
    public static final String MAIL_PRIORITY_ATTRIBUTE_NAME = "MAIL_PRIORITY";
    private static final List<String> supportedSmtpExtensionsList = List.of("MT-PRIORITY", "STARTTLS");
    private static final List<String> supportedMailAttributesList = List.of("MAIL_PRIORITY", "REQUIRETLS");
    private final RemoteDeliveryConfiguration configuration;
    private final Converter7Bit converter7Bit;
    private final ObjectPool<Session> smtpSessionPool;
    private final ObjectPool<Session> smtpsSessionPool;

    public MailDelivrerToHost(RemoteDeliveryConfiguration remoteDeliveryConfiguration, MailetContext mailetContext) {
        this.configuration = remoteDeliveryConfiguration;
        this.converter7Bit = new Converter7Bit(mailetContext);
        if (this.configuration.isSSLEnable()) {
            this.smtpSessionPool = this.createSessionPool(this.configuration.createFinalJavaxProperties());
            this.smtpsSessionPool = this.createSessionPool(this.configuration.createFinalJavaxPropertiesWithSSL());
        } else {
            this.smtpSessionPool = this.createSessionPool(this.configuration.createFinalJavaxProperties());
            this.smtpsSessionPool = this.smtpSessionPool;
        }
    }

    private ObjectPool<Session> createSessionPool(final Properties defaultConfiguration) {
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxTotal(-1);
        poolConfig.setJmxEnabled(false);
        return new GenericObjectPool((PooledObjectFactory)new BasePooledObjectFactory<Session>(this){

            public Session create() {
                return Session.getInstance((Properties)new Properties(defaultConfiguration));
            }

            public PooledObject<Session> wrap(Session session) {
                return new DefaultPooledObject((Object)session);
            }

            public void passivateObject(PooledObject<Session> p) {
                ((Session)p.getObject()).getProperties().clear();
            }
        }, poolConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResult tryDeliveryToHost(Mail mail, Collection<InternetAddress> addr, HostAddress outgoingMailServer) throws MessagingException {
        Session session = this.selectSession(outgoingMailServer);
        Properties props = this.getPropertiesForMail(mail, session);
        LOGGER.debug("Attempting delivery of {} with messageId {} to host {} at {} from {}", new Object[]{mail.getName(), this.getMessageId(mail), outgoingMailServer.getHostName(), outgoingMailServer.getHost(), props.get(this.inContext(session, "mail.smtp.from"))});
        SMTPTransport transport = null;
        try {
            transport = (SMTPTransport)session.getTransport((URLName)outgoingMailServer);
            transport.setLocalHost(props.getProperty(this.inContext(session, "mail.smtp.localhost"), this.configuration.getHeloNameProvider().getHeloName()));
            this.connect(outgoingMailServer, transport);
            if (MailDelivrerToHost.receiverDoesNotProvideNecessaryStartTls(mail, transport)) {
                ExecutionResult executionResult = ExecutionResult.permanentFailure((Exception)((Object)new SendFailedException("Mail delivery failed; the receiving server does not support STARTTLS")));
                return executionResult;
            }
            if (mail.dsnParameters().isPresent()) {
                this.sendDSNAwareEmail(mail, transport, addr);
            } else if (MailDelivrerToHost.extensionsSupported(transport)) {
                SMTPMessage smtpMessage = new SMTPMessage(this.adaptToTransport(mail.getMessage(), transport));
                transport.sendMessage((Message)this.toSmtpMessageWithExtensions(mail, smtpMessage), (Address[])addr.toArray(InternetAddress[]::new));
            } else {
                transport.sendMessage((Message)this.adaptToTransport(mail.getMessage(), transport), (Address[])addr.toArray(InternetAddress[]::new));
            }
            LOGGER.info("Mail ({}) with messageId {} sent successfully to {} at {} from {} for {}", new Object[]{mail.getName(), this.getMessageId(mail), outgoingMailServer.getHostName(), outgoingMailServer.getHost(), props.get(this.inContext(session, "mail.smtp.from")), mail.getRecipients()});
        }
        finally {
            this.closeTransport(mail, outgoingMailServer, transport);
            this.releaseSession(outgoingMailServer, session);
        }
        return ExecutionResult.success();
    }

    private String getMessageId(Mail mail) {
        try {
            return mail.getMessage().getMessageID();
        }
        catch (MessagingException e) {
            LOGGER.debug("failed to extract messageId from message {}", (Object)mail.getName(), (Object)e);
            return null;
        }
    }

    private Session selectSession(HostAddress host) throws MessagingException {
        try {
            if (host.getProtocol().equalsIgnoreCase("smtps")) {
                return (Session)this.smtpsSessionPool.borrowObject();
            }
            return (Session)this.smtpSessionPool.borrowObject();
        }
        catch (Exception e) {
            throw new MessagingException("could not create SMTP session for mail delivery", e);
        }
    }

    private void releaseSession(HostAddress host, Session session) {
        try {
            if (host.getProtocol().equalsIgnoreCase("smtps")) {
                this.smtpsSessionPool.returnObject((Object)session);
            } else {
                this.smtpSessionPool.returnObject((Object)session);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Warning: failed to release SMTP session after mail delivery", (Throwable)e);
        }
    }

    private String inContext(Session session, String name) {
        if ("true".equals(session.getProperties().getProperty("mail.smtps.ssl.enable"))) {
            return name.replace("smtp", "smtps");
        }
        return name;
    }

    private void sendDSNAwareEmail(Mail mail, SMTPTransport transport, Collection<InternetAddress> addresses) {
        ((ImmutableListMultimap)addresses.stream().map(address -> Pair.of(mail.dsnParameters().flatMap(Throwing.function(dsn -> Optional.ofNullable((DsnParameters.RecipientDsnParameters)dsn.getRcptParameters().get((Object)new MailAddress(address.toString())))).orReturn(Optional.empty())).flatMap(DsnParameters.RecipientDsnParameters::getNotifyParameter).map(this::toJavaxNotify), (Object)address)).collect(ImmutableListMultimap.toImmutableListMultimap(Pair::getKey, Pair::getValue))).asMap().forEach(Throwing.biConsumer((maybeNotify, recipients) -> {
            SMTPMessage smtpMessage = this.asSmtpMessage(mail, transport);
            maybeNotify.ifPresent(arg_0 -> ((SMTPMessage)smtpMessage).setNotifyOptions(arg_0));
            transport.sendMessage((Message)smtpMessage, (Address[])recipients.toArray(InternetAddress[]::new));
        }).sneakyThrow());
    }

    private SMTPMessage asSmtpMessage(Mail mail, SMTPTransport transport) throws MessagingException {
        SMTPMessage smtpMessage = new SMTPMessage(this.adaptToTransport(mail.getMessage(), transport));
        mail.dsnParameters().flatMap(DsnParameters::getRetParameter).map(this::toJavaxRet).ifPresent(arg_0 -> ((SMTPMessage)smtpMessage).setReturnOption(arg_0));
        mail.dsnParameters().flatMap(DsnParameters::getEnvIdParameter).ifPresent(envId -> {
            if (transport.supportsExtension("DSN")) {
                smtpMessage.setMailExtension("ENVID=" + envId.asString());
            }
        });
        if (MailDelivrerToHost.extensionsSupported(transport)) {
            return this.toSmtpMessageWithExtensions(mail, smtpMessage);
        }
        return smtpMessage;
    }

    private static boolean extensionsSupported(SMTPTransport transport) {
        return supportedSmtpExtensionsList.stream().anyMatch(arg_0 -> ((SMTPTransport)transport).supportsExtension(arg_0));
    }

    private static boolean receiverDoesNotProvideNecessaryStartTls(Mail mail, SMTPTransport transport) {
        return !transport.getLastServerResponse().contains(STARTTLS) && mail.attributesMap().containsKey(AttributeName.of((String)REQUIRE_TLS)) && MailDelivrerToHost.isRequireTlsAttribute(mail);
    }

    private static boolean isRequireTlsAttribute(Mail mail) {
        return ((Attribute)mail.attributesMap().get(AttributeName.of((String)REQUIRE_TLS))).getValue().value().equals(Boolean.TRUE);
    }

    private SMTPMessage toSmtpMessageWithExtensions(Mail mail, SMTPMessage smtpMessage) {
        mail.attributesMap().forEach((attributeName, attribute) -> {
            if (supportedMailAttributesList.contains(attributeName.asString())) {
                String existingMessageExtensions = Optional.ofNullable(smtpMessage.getMailExtension()).map(extension -> " " + extension).orElse("");
                switch (attributeName.asString()) {
                    case "MAIL_PRIORITY": {
                        smtpMessage.setMailExtension("MT-PRIORITY=" + String.valueOf(attribute.getValue().value()) + existingMessageExtensions);
                        break;
                    }
                    case "REQUIRETLS": {
                        if (!MailDelivrerToHost.isRequireTlsAttribute(mail)) break;
                        smtpMessage.setMailExtension(REQUIRE_TLS + existingMessageExtensions);
                        break;
                    }
                    default: {
                        throw new NotImplementedException("Unknown mail attribute cannot be handled: {}", attributeName.asString());
                    }
                }
            }
        });
        return smtpMessage;
    }

    private int toJavaxRet(DsnParameters.Ret ret) {
        return switch (ret) {
            case DsnParameters.Ret.FULL -> 1;
            case DsnParameters.Ret.HDRS -> 2;
            default -> throw new NotImplementedException(String.valueOf(ret) + " cannot be converted to jakarta.mail parameters");
        };
    }

    private int toJavaxNotify(EnumSet<DsnParameters.Notify> notifies) {
        return notifies.stream().mapToInt(this::toJavaxNotify).sum();
    }

    private int toJavaxNotify(DsnParameters.Notify notify) {
        return switch (notify) {
            case DsnParameters.Notify.NEVER -> -1;
            case DsnParameters.Notify.SUCCESS -> 1;
            case DsnParameters.Notify.FAILURE -> 2;
            case DsnParameters.Notify.DELAY -> 4;
            default -> throw new NotImplementedException(String.valueOf(notify) + " cannot be converted to jakarta.mail parameters");
        };
    }

    private Properties getPropertiesForMail(Mail mail, Session session) {
        Properties props = session.getProperties();
        props.put(this.inContext(session, "mail.smtp.from"), mail.getMaybeSender().asString());
        return props;
    }

    private void connect(HostAddress outgoingMailServer, SMTPTransport transport) throws MessagingException {
        if (this.configuration.getAuthUser() != null) {
            transport.connect(this.getHostName(outgoingMailServer), this.configuration.getAuthUser(), this.configuration.getAuthPass());
        } else if (this.configuration.isConnectByHostname()) {
            transport.connect(this.getHostName(outgoingMailServer), null, null);
        } else {
            transport.connect();
        }
    }

    private String getHostName(HostAddress outgoingMailServer) {
        String host = outgoingMailServer.getHostName();
        if (!host.isEmpty() && host.charAt(host.length() - 1) == '.') {
            return host.substring(0, host.length() - 1);
        }
        return host;
    }

    private MimeMessage adaptToTransport(MimeMessage message, SMTPTransport transport) throws MessagingException {
        if (this.shouldAdapt(transport)) {
            try {
                this.converter7Bit.convertTo7Bit(message);
            }
            catch (IOException e) {
                LOGGER.error("Error during the conversion to 7 bit.", (Throwable)e);
            }
        }
        return message;
    }

    private boolean shouldAdapt(SMTPTransport transport) {
        return !transport.getClass().getName().endsWith(".SMTPTransport") || !transport.supportsExtension(BIT_MIME_8);
    }

    private void closeTransport(Mail mail, HostAddress outgoingMailServer, SMTPTransport transport) {
        if (transport != null) {
            try {
                transport.close();
            }
            catch (MessagingException e) {
                LOGGER.error("Warning: could not close the SMTP transport after sending mail ({}) to {} at {} for {}; probably the server has already closed the connection. Message is considered to be delivered. Exception: {}", new Object[]{mail.getName(), outgoingMailServer.getHostName(), outgoingMailServer.getHost(), mail.getRecipients(), e.getMessage()});
            }
            transport = null;
        }
    }
}

