/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.POP3MessageCommandArguments;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;

public abstract class POP3MessageCommandDelegate {
    private final String command;

    public POP3MessageCommandDelegate(Collection<String> commands) {
        Preconditions.checkArgument((commands != null && !commands.isEmpty() ? 1 : 0) != 0, (Object)"You must provide at least one command keyword");
        this.command = commands.iterator().next();
    }

    public Response handleMessageRequest(POP3Session session, Request request) {
        if (session.getHandlerState() == 2) {
            return POP3MessageCommandArguments.fromRequest(request).map(args -> this.handleValidArgs(session, (POP3MessageCommandArguments)args)).orElseGet(this::handleSyntaxError);
        }
        return POP3Response.ERR;
    }

    private Response handleValidArgs(POP3Session session, POP3MessageCommandArguments args) {
        try {
            MessageMetaData data = this.getMetaData(session, args.getMessageNumber());
            List deletedUidList = (List)session.getAttachment(POP3Session.DELETED_UID_LIST, ProtocolSession.State.Transaction).orElse(ImmutableList.of());
            if (!deletedUidList.contains(data.getUid())) {
                return this.handleMessageExists(session, data, args);
            }
            return new POP3Response("-ERR", "Message (" + args.getMessageNumber() + ") already deleted.");
        }
        catch (IOException ioe) {
            return new POP3Response("-ERR", "Message (" + args.getMessageNumber() + ") does not exist.");
        }
    }

    private MessageMetaData getMetaData(POP3Session session, int number) throws IOException {
        if (number <= 0) {
            throw new IOException("MessageMetaData does not exist for number " + number);
        }
        return session.getAttachment(POP3Session.UID_LIST, ProtocolSession.State.Transaction).filter(uidList -> number <= uidList.size()).map(uidList -> (MessageMetaData)uidList.get(number - 1)).orElseThrow(() -> new IOException("MessageMetaData does not exist for number " + number));
    }

    protected Response handleSyntaxError() {
        return new POP3Response("-ERR", "Usage: " + this.command + " [mail number]");
    }

    protected abstract Response handleMessageExists(POP3Session var1, MessageMetaData var2, POP3MessageCommandArguments var3) throws IOException;
}

