/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.SetMetadataRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.AnnotationException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class SetMetadataProcessor
extends AbstractMailboxProcessor<SetMetadataRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetMetadataProcessor.class);
    private final ImmutableList<Capability> capabilities;
    private final PathConverter.Factory pathConverterFactory;

    @Inject
    public SetMetadataProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory, PathConverter.Factory pathConverterFactory) {
        super(SetMetadataRequest.class, mailboxManager, factory, metricFactory);
        this.pathConverterFactory = pathConverterFactory;
        this.capabilities = this.computeCapabilities();
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return this.capabilities;
    }

    private ImmutableList<Capability> computeCapabilities() {
        return Optional.ofNullable(this.getMailboxManager().getSupportedMailboxCapabilities()).map(capabilities -> capabilities.contains(MailboxManager.MailboxCapabilities.Annotation)).map(annotationCap -> ImmutableList.of((Object)ImapConstants.SUPPORTS_ANNOTATION)).orElseGet(ImmutableList::of);
    }

    @Override
    protected Mono<Void> processRequestReactive(SetMetadataRequest request, ImapSession session, ImapProcessor.Responder responder) {
        MailboxManager mailboxManager = this.getMailboxManager();
        MailboxSession mailboxSession = session.getMailboxSession();
        String mailboxName = request.getMailboxName();
        return Mono.from((Publisher)mailboxManager.updateAnnotationsReactive(this.pathConverterFactory.forSession(session).buildFullPath(mailboxName), mailboxSession, request.getMailboxAnnotations())).then(Mono.fromRunnable(() -> this.okComplete(request, responder)).then()).doOnEach(ReactorUtils.logOnError(MailboxException.class, e -> LOGGER.info("{} failed for mailbox {}", new Object[]{request.getCommand().getName(), mailboxName, e}))).onErrorResume(MailboxNotFoundException.class, error -> Mono.fromRunnable(() -> this.no(request, responder, HumanReadableText.FAILURE_NO_SUCH_MAILBOX, StatusResponse.ResponseCode.tryCreate()))).onErrorResume(AnnotationException.class, error -> Mono.fromRunnable(() -> this.no(request, responder, new HumanReadableText("org.apache.james.imap.ANNOTATION_ERROR_KEY", error.getMessage())))).onErrorResume(MailboxException.class, error -> Mono.fromRunnable(() -> this.no(request, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING)));
    }

    @Override
    protected MDCBuilder mdc(SetMetadataRequest request) {
        return MDCBuilder.create().addToContext("action", "SET_ANNOTATION").addToContext("mailbox", request.getMailboxName()).addToContext("annotations", request.getMailboxAnnotations().toString());
    }
}

