/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.matchingrules.OctetStringMatchingRule;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.ldif.LDIFRecord;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

@Mutable
@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public class Entry
implements LDIFRecord {
    @NotNull
    private static final ASN1OctetString EMPTY_OCTET_STRING = new ASN1OctetString();
    private static final long serialVersionUID = -4438809025903729197L;
    @Nullable
    private volatile DN parsedDN;
    @NotNull
    private final LinkedHashMap<String, Attribute> attributes;
    @Nullable
    private final Schema schema;
    @NotNull
    private String dn;

    protected Entry(@NotNull Entry e) {
        this.parsedDN = e.parsedDN;
        this.attributes = e.attributes;
        this.schema = e.schema;
        this.dn = e.dn;
    }

    public Entry(@NotNull String dn) {
        this(dn, (Schema)null);
    }

    public Entry(@NotNull String dn, @Nullable Schema schema) {
        Validator.ensureNotNull(dn);
        this.dn = dn;
        this.schema = schema;
        this.attributes = new LinkedHashMap(StaticUtils.computeMapCapacity(20));
    }

    public Entry(@NotNull DN dn) {
        this(dn, (Schema)null);
    }

    public Entry(@NotNull DN dn, @Nullable Schema schema) {
        Validator.ensureNotNull(dn);
        this.parsedDN = dn;
        this.dn = this.parsedDN.toString();
        this.schema = schema;
        this.attributes = new LinkedHashMap(StaticUtils.computeMapCapacity(20));
    }

    public Entry(@NotNull String dn, Attribute ... attributes) {
        this(dn, (Schema)null, attributes);
    }

    public Entry(@NotNull String dn, @Nullable Schema schema, Attribute ... attributes) {
        Validator.ensureNotNull(dn, attributes);
        this.dn = dn;
        this.schema = schema;
        this.attributes = new LinkedHashMap(StaticUtils.computeMapCapacity(attributes.length));
        for (Attribute a : attributes) {
            String name = StaticUtils.toLowerCase(a.getName());
            Attribute attr = this.attributes.get(name);
            if (attr == null) {
                this.attributes.put(name, a);
                continue;
            }
            this.attributes.put(name, Attribute.mergeAttributes(attr, a));
        }
    }

    public Entry(@NotNull DN dn, Attribute ... attributes) {
        this(dn, (Schema)null, attributes);
    }

    public Entry(@NotNull DN dn, @Nullable Schema schema, Attribute ... attributes) {
        Validator.ensureNotNull(dn, attributes);
        this.parsedDN = dn;
        this.dn = this.parsedDN.toString();
        this.schema = schema;
        this.attributes = new LinkedHashMap(StaticUtils.computeMapCapacity(attributes.length));
        for (Attribute a : attributes) {
            String name = StaticUtils.toLowerCase(a.getName());
            Attribute attr = this.attributes.get(name);
            if (attr == null) {
                this.attributes.put(name, a);
                continue;
            }
            this.attributes.put(name, Attribute.mergeAttributes(attr, a));
        }
    }

    public Entry(@NotNull String dn, @NotNull Collection<Attribute> attributes) {
        this(dn, null, attributes);
    }

    public Entry(@NotNull String dn, @Nullable Schema schema, @NotNull Collection<Attribute> attributes) {
        Validator.ensureNotNull(dn, attributes);
        this.dn = dn;
        this.schema = schema;
        this.attributes = new LinkedHashMap(StaticUtils.computeMapCapacity(attributes.size()));
        for (Attribute a : attributes) {
            String name = StaticUtils.toLowerCase(a.getName());
            Attribute attr = this.attributes.get(name);
            if (attr == null) {
                this.attributes.put(name, a);
                continue;
            }
            this.attributes.put(name, Attribute.mergeAttributes(attr, a));
        }
    }

    public Entry(@NotNull DN dn, @NotNull Collection<Attribute> attributes) {
        this(dn, null, attributes);
    }

    public Entry(@NotNull DN dn, @Nullable Schema schema, @NotNull Collection<Attribute> attributes) {
        Validator.ensureNotNull(dn, attributes);
        this.parsedDN = dn;
        this.dn = this.parsedDN.toString();
        this.schema = schema;
        this.attributes = new LinkedHashMap(StaticUtils.computeMapCapacity(attributes.size()));
        for (Attribute a : attributes) {
            String name = StaticUtils.toLowerCase(a.getName());
            Attribute attr = this.attributes.get(name);
            if (attr == null) {
                this.attributes.put(name, a);
                continue;
            }
            this.attributes.put(name, Attribute.mergeAttributes(attr, a));
        }
    }

    public Entry(String ... entryLines) throws LDIFException {
        this((Schema)null, entryLines);
    }

    public Entry(@Nullable Schema schema, String ... entryLines) throws LDIFException {
        Entry e = LDIFReader.decodeEntry(false, schema, entryLines);
        this.schema = schema;
        this.dn = e.dn;
        this.parsedDN = e.parsedDN;
        this.attributes = e.attributes;
    }

    @Override
    @NotNull
    public final String getDN() {
        return this.dn;
    }

    public void setDN(@NotNull String dn) {
        Validator.ensureNotNull(dn);
        this.dn = dn;
        this.parsedDN = null;
    }

    public void setDN(@NotNull DN dn) {
        Validator.ensureNotNull(dn);
        this.parsedDN = dn;
        this.dn = this.parsedDN.toString();
    }

    @Override
    @NotNull
    public final DN getParsedDN() throws LDAPException {
        if (this.parsedDN == null) {
            this.parsedDN = new DN(this.dn, this.schema);
        }
        return this.parsedDN;
    }

    @Nullable
    public final RDN getRDN() throws LDAPException {
        return this.getParsedDN().getRDN();
    }

    @Nullable
    public final DN getParentDN() throws LDAPException {
        if (this.parsedDN == null) {
            this.parsedDN = new DN(this.dn, this.schema);
        }
        return this.parsedDN.getParent();
    }

    @NotNull
    public final String getParentDNString() throws LDAPException {
        DN parentDN;
        if (this.parsedDN == null) {
            this.parsedDN = new DN(this.dn, this.schema);
        }
        if ((parentDN = this.parsedDN.getParent()) == null) {
            return null;
        }
        return parentDN.toString();
    }

    @Nullable
    protected Schema getSchema() {
        return this.schema;
    }

    public final boolean hasAttribute(@NotNull String attributeName) {
        return this.hasAttribute(attributeName, this.schema);
    }

    public final boolean hasAttribute(@NotNull String attributeName, @Nullable Schema schema) {
        Validator.ensureNotNull(attributeName);
        if (this.attributes.containsKey(StaticUtils.toLowerCase(attributeName))) {
            return true;
        }
        if (schema != null) {
            String options;
            String baseName;
            int semicolonPos = attributeName.indexOf(59);
            if (semicolonPos > 0) {
                baseName = attributeName.substring(0, semicolonPos);
                options = StaticUtils.toLowerCase(attributeName.substring(semicolonPos));
            } else {
                baseName = attributeName;
                options = "";
            }
            AttributeTypeDefinition at = schema.getAttributeType(baseName);
            if (at != null) {
                if (this.attributes.containsKey(StaticUtils.toLowerCase(at.getOID()) + options)) {
                    return true;
                }
                for (String name : at.getNames()) {
                    if (!this.attributes.containsKey(StaticUtils.toLowerCase(name) + options)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public final boolean hasAttribute(@NotNull Attribute attribute) {
        Validator.ensureNotNull(attribute);
        String lowerName = StaticUtils.toLowerCase(attribute.getName());
        Attribute attr = this.attributes.get(lowerName);
        return attr != null && attr.equals(attribute);
    }

    public final boolean hasAttributeValue(@NotNull String attributeName, @NotNull String attributeValue) {
        Validator.ensureNotNull(attributeName, attributeValue);
        Attribute attr = this.attributes.get(StaticUtils.toLowerCase(attributeName));
        return attr != null && attr.hasValue(attributeValue);
    }

    public final boolean hasAttributeValue(@NotNull String attributeName, @NotNull String attributeValue, @NotNull MatchingRule matchingRule) {
        Validator.ensureNotNull(attributeName, attributeValue);
        Attribute attr = this.attributes.get(StaticUtils.toLowerCase(attributeName));
        return attr != null && attr.hasValue(attributeValue, matchingRule);
    }

    public final boolean hasAttributeValue(@NotNull String attributeName, @NotNull byte[] attributeValue) {
        Validator.ensureNotNull(attributeName, attributeValue);
        Attribute attr = this.attributes.get(StaticUtils.toLowerCase(attributeName));
        return attr != null && attr.hasValue(attributeValue);
    }

    public final boolean hasAttributeValue(@NotNull String attributeName, @NotNull byte[] attributeValue, @NotNull MatchingRule matchingRule) {
        Validator.ensureNotNull(attributeName, attributeValue);
        Attribute attr = this.attributes.get(StaticUtils.toLowerCase(attributeName));
        return attr != null && attr.hasValue(attributeValue, matchingRule);
    }

    public final boolean hasObjectClass(@NotNull String objectClassName) {
        return this.hasAttributeValue("objectClass", objectClassName);
    }

    @NotNull
    public final Collection<Attribute> getAttributes() {
        return Collections.unmodifiableCollection(this.attributes.values());
    }

    @Nullable
    public final Attribute getAttribute(@NotNull String attributeName) {
        return this.getAttribute(attributeName, this.schema);
    }

    @Nullable
    public final Attribute getAttribute(@NotNull String attributeName, @Nullable Schema schema) {
        Validator.ensureNotNull(attributeName);
        Attribute a = this.attributes.get(StaticUtils.toLowerCase(attributeName));
        if (a == null && schema != null) {
            String options;
            String baseName;
            int semicolonPos = attributeName.indexOf(59);
            if (semicolonPos > 0) {
                baseName = attributeName.substring(0, semicolonPos);
                options = StaticUtils.toLowerCase(attributeName.substring(semicolonPos));
            } else {
                baseName = attributeName;
                options = "";
            }
            AttributeTypeDefinition at = schema.getAttributeType(baseName);
            if (at == null) {
                return null;
            }
            a = this.attributes.get(StaticUtils.toLowerCase(at.getOID() + options));
            if (a == null) {
                for (String name : at.getNames()) {
                    a = this.attributes.get(StaticUtils.toLowerCase(name) + options);
                    if (a == null) continue;
                    return a;
                }
            }
            return a;
        }
        return a;
    }

    @NotNull
    public final List<Attribute> getAttributesWithOptions(@NotNull String baseName, @Nullable Set<String> options) {
        Validator.ensureNotNull(baseName);
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(10);
        for (Attribute a : this.attributes.values()) {
            if (!a.getBaseName().equalsIgnoreCase(baseName)) continue;
            if (options == null || options.isEmpty()) {
                attrList.add(a);
                continue;
            }
            boolean allFound = true;
            for (String option : options) {
                if (a.hasOption(option)) continue;
                allFound = false;
                break;
            }
            if (!allFound) continue;
            attrList.add(a);
        }
        return Collections.unmodifiableList(attrList);
    }

    @Nullable
    public String getAttributeValue(@NotNull String attributeName) {
        Validator.ensureNotNull(attributeName);
        Attribute a = this.attributes.get(StaticUtils.toLowerCase(attributeName));
        if (a == null) {
            return null;
        }
        return a.getValue();
    }

    @Nullable
    public byte[] getAttributeValueBytes(@NotNull String attributeName) {
        Validator.ensureNotNull(attributeName);
        Attribute a = this.attributes.get(StaticUtils.toLowerCase(attributeName));
        if (a == null) {
            return null;
        }
        return a.getValueByteArray();
    }

    @Nullable
    public Boolean getAttributeValueAsBoolean(@NotNull String attributeName) {
        Validator.ensureNotNull(attributeName);
        Attribute a = this.attributes.get(StaticUtils.toLowerCase(attributeName));
        if (a == null) {
            return null;
        }
        return a.getValueAsBoolean();
    }

    @Nullable
    public Date getAttributeValueAsDate(@NotNull String attributeName) {
        Validator.ensureNotNull(attributeName);
        Attribute a = this.attributes.get(StaticUtils.toLowerCase(attributeName));
        if (a == null) {
            return null;
        }
        return a.getValueAsDate();
    }

    @Nullable
    public DN getAttributeValueAsDN(@NotNull String attributeName) {
        Validator.ensureNotNull(attributeName);
        Attribute a = this.attributes.get(StaticUtils.toLowerCase(attributeName));
        if (a == null) {
            return null;
        }
        return a.getValueAsDN();
    }

    @Nullable
    public Integer getAttributeValueAsInteger(@NotNull String attributeName) {
        Validator.ensureNotNull(attributeName);
        Attribute a = this.attributes.get(StaticUtils.toLowerCase(attributeName));
        if (a == null) {
            return null;
        }
        return a.getValueAsInteger();
    }

    @Nullable
    public Long getAttributeValueAsLong(@NotNull String attributeName) {
        Validator.ensureNotNull(attributeName);
        Attribute a = this.attributes.get(StaticUtils.toLowerCase(attributeName));
        if (a == null) {
            return null;
        }
        return a.getValueAsLong();
    }

    @Nullable
    public String[] getAttributeValues(@NotNull String attributeName) {
        Validator.ensureNotNull(attributeName);
        Attribute a = this.attributes.get(StaticUtils.toLowerCase(attributeName));
        if (a == null) {
            return null;
        }
        return a.getValues();
    }

    @Nullable
    public byte[][] getAttributeValueByteArrays(@NotNull String attributeName) {
        Validator.ensureNotNull(attributeName);
        Attribute a = this.attributes.get(StaticUtils.toLowerCase(attributeName));
        if (a == null) {
            return null;
        }
        return a.getValueByteArrays();
    }

    @Nullable
    public final Attribute getObjectClassAttribute() {
        return this.getAttribute("objectClass");
    }

    @Nullable
    public final String[] getObjectClassValues() {
        return this.getAttributeValues("objectClass");
    }

    public boolean addAttribute(@NotNull Attribute attribute) {
        Validator.ensureNotNull(attribute);
        String lowerName = StaticUtils.toLowerCase(attribute.getName());
        Attribute attr = this.attributes.get(lowerName);
        if (attr == null) {
            this.attributes.put(lowerName, attribute);
            return true;
        }
        Attribute newAttr = Attribute.mergeAttributes(attr, attribute);
        this.attributes.put(lowerName, newAttr);
        return attr.getRawValues().length != newAttr.getRawValues().length;
    }

    public boolean addAttribute(@NotNull String attributeName, @NotNull String attributeValue) {
        Validator.ensureNotNull(attributeName, attributeValue);
        return this.addAttribute(new Attribute(attributeName, this.schema, attributeValue));
    }

    public boolean addAttribute(@NotNull String attributeName, @NotNull byte[] attributeValue) {
        Validator.ensureNotNull(attributeName, attributeValue);
        return this.addAttribute(new Attribute(attributeName, this.schema, (byte[][])new byte[][]{attributeValue}));
    }

    public boolean addAttribute(@NotNull String attributeName, String ... attributeValues) {
        Validator.ensureNotNull(attributeName, attributeValues);
        return this.addAttribute(new Attribute(attributeName, this.schema, attributeValues));
    }

    public boolean addAttribute(@NotNull String attributeName, byte[] ... attributeValues) {
        Validator.ensureNotNull(attributeName, attributeValues);
        return this.addAttribute(new Attribute(attributeName, this.schema, attributeValues));
    }

    public boolean addAttribute(@NotNull String attributeName, @NotNull Collection<String> attributeValues) {
        Validator.ensureNotNull(attributeName, attributeValues);
        return this.addAttribute(new Attribute(attributeName, this.schema, attributeValues));
    }

    public boolean removeAttribute(@NotNull String attributeName) {
        Validator.ensureNotNull(attributeName);
        if (this.schema == null) {
            return this.attributes.remove(StaticUtils.toLowerCase(attributeName)) != null;
        }
        Attribute a = this.getAttribute(attributeName, this.schema);
        if (a == null) {
            return false;
        }
        this.attributes.remove(StaticUtils.toLowerCase(a.getName()));
        return true;
    }

    public boolean removeAttributeValue(@NotNull String attributeName, @NotNull String attributeValue) {
        return this.removeAttributeValue(attributeName, attributeValue, null);
    }

    public boolean removeAttributeValue(@NotNull String attributeName, @NotNull String attributeValue, @Nullable MatchingRule matchingRule) {
        Validator.ensureNotNull(attributeName, attributeValue);
        Attribute attr = this.getAttribute(attributeName, this.schema);
        if (attr == null) {
            return false;
        }
        String lowerName = StaticUtils.toLowerCase(attr.getName());
        Attribute newAttr = Attribute.removeValues(attr, new Attribute(attributeName, attributeValue), matchingRule);
        if (newAttr.hasValue()) {
            this.attributes.put(lowerName, newAttr);
        } else {
            this.attributes.remove(lowerName);
        }
        return attr.getRawValues().length != newAttr.getRawValues().length;
    }

    public boolean removeAttributeValue(@NotNull String attributeName, @NotNull byte[] attributeValue) {
        return this.removeAttributeValue(attributeName, attributeValue, null);
    }

    public boolean removeAttributeValue(@NotNull String attributeName, @NotNull byte[] attributeValue, @Nullable MatchingRule matchingRule) {
        Validator.ensureNotNull(attributeName, attributeValue);
        Attribute attr = this.getAttribute(attributeName, this.schema);
        if (attr == null) {
            return false;
        }
        String lowerName = StaticUtils.toLowerCase(attr.getName());
        Attribute newAttr = Attribute.removeValues(attr, new Attribute(attributeName, attributeValue), matchingRule);
        if (newAttr.hasValue()) {
            this.attributes.put(lowerName, newAttr);
        } else {
            this.attributes.remove(lowerName);
        }
        return attr.getRawValues().length != newAttr.getRawValues().length;
    }

    public boolean removeAttributeValues(@NotNull String attributeName, String ... attributeValues) {
        Validator.ensureNotNull(attributeName, attributeValues);
        Attribute attr = this.getAttribute(attributeName, this.schema);
        if (attr == null) {
            return false;
        }
        String lowerName = StaticUtils.toLowerCase(attr.getName());
        Attribute newAttr = Attribute.removeValues(attr, new Attribute(attributeName, attributeValues));
        if (newAttr.hasValue()) {
            this.attributes.put(lowerName, newAttr);
        } else {
            this.attributes.remove(lowerName);
        }
        return attr.getRawValues().length != newAttr.getRawValues().length;
    }

    public boolean removeAttributeValues(@NotNull String attributeName, byte[] ... attributeValues) {
        Validator.ensureNotNull(attributeName, attributeValues);
        Attribute attr = this.getAttribute(attributeName, this.schema);
        if (attr == null) {
            return false;
        }
        String lowerName = StaticUtils.toLowerCase(attr.getName());
        Attribute newAttr = Attribute.removeValues(attr, new Attribute(attributeName, attributeValues));
        if (newAttr.hasValue()) {
            this.attributes.put(lowerName, newAttr);
        } else {
            this.attributes.remove(lowerName);
        }
        return attr.getRawValues().length != newAttr.getRawValues().length;
    }

    public void setAttribute(@NotNull Attribute attribute) {
        Validator.ensureNotNull(attribute);
        Attribute a = this.getAttribute(attribute.getName(), this.schema);
        String lowerName = a == null ? StaticUtils.toLowerCase(attribute.getName()) : StaticUtils.toLowerCase(a.getName());
        this.attributes.put(lowerName, attribute);
    }

    public void setAttribute(@NotNull String attributeName, @NotNull String attributeValue) {
        Validator.ensureNotNull(attributeName, attributeValue);
        this.setAttribute(new Attribute(attributeName, this.schema, attributeValue));
    }

    public void setAttribute(@NotNull String attributeName, @NotNull byte[] attributeValue) {
        Validator.ensureNotNull(attributeName, attributeValue);
        this.setAttribute(new Attribute(attributeName, this.schema, (byte[][])new byte[][]{attributeValue}));
    }

    public void setAttribute(@NotNull String attributeName, String ... attributeValues) {
        Validator.ensureNotNull(attributeName, attributeValues);
        this.setAttribute(new Attribute(attributeName, this.schema, attributeValues));
    }

    public void setAttribute(@NotNull String attributeName, byte[] ... attributeValues) {
        Validator.ensureNotNull(attributeName, attributeValues);
        this.setAttribute(new Attribute(attributeName, this.schema, attributeValues));
    }

    public void setAttribute(@NotNull String attributeName, @NotNull Collection<String> attributeValues) {
        Validator.ensureNotNull(attributeName, attributeValues);
        this.setAttribute(new Attribute(attributeName, this.schema, attributeValues));
    }

    public boolean matchesBaseAndScope(@NotNull String baseDN, @NotNull SearchScope scope) throws LDAPException {
        return this.getParsedDN().matchesBaseAndScope(new DN(baseDN), scope);
    }

    public boolean matchesBaseAndScope(@NotNull DN baseDN, @NotNull SearchScope scope) throws LDAPException {
        return this.getParsedDN().matchesBaseAndScope(baseDN, scope);
    }

    @NotNull
    public static List<Modification> diff(@NotNull Entry sourceEntry, @NotNull Entry targetEntry, boolean ignoreRDN, String ... attributes) {
        return Entry.diff(sourceEntry, targetEntry, ignoreRDN, true, attributes);
    }

    @NotNull
    public static List<Modification> diff(@NotNull Entry sourceEntry, @NotNull Entry targetEntry, boolean ignoreRDN, boolean reversible, String ... attributes) {
        return Entry.diff(sourceEntry, targetEntry, ignoreRDN, reversible, false, attributes);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static List<Modification> diff(@NotNull Entry sourceEntry, @NotNull Entry targetEntry, boolean ignoreRDN, boolean reversible, boolean byteForByte, String ... attributes) {
        ArrayList<ASN1OctetString> newValues;
        void var10_18;
        ASN1OctetString[] values;
        Attribute attr;
        String lowerName;
        HashSet<String> compareAttrs = null;
        if (attributes != null && attributes.length > 0) {
            compareAttrs = new HashSet<String>(StaticUtils.computeMapCapacity(attributes.length));
            for (String string : attributes) {
                compareAttrs.add(StaticUtils.toLowerCase(Attribute.getBaseName(string)));
            }
        }
        LinkedHashMap<String, Attribute> sourceOnlyAttrs = new LinkedHashMap<String, Attribute>(StaticUtils.computeMapCapacity(20));
        LinkedHashMap<String, Attribute> targetOnlyAttrs = new LinkedHashMap<String, Attribute>(StaticUtils.computeMapCapacity(20));
        LinkedHashMap<String, Attribute> commonAttrs = new LinkedHashMap<String, Attribute>(StaticUtils.computeMapCapacity(20));
        for (Map.Entry<String, Attribute> e : sourceEntry.attributes.entrySet()) {
            lowerName = StaticUtils.toLowerCase(e.getKey());
            if (compareAttrs != null && !compareAttrs.contains(Attribute.getBaseName(lowerName))) continue;
            if (byteForByte) {
                Attribute a2 = e.getValue();
                attr = new Attribute(a2.getName(), (MatchingRule)OctetStringMatchingRule.getInstance(), a2.getRawValues());
            } else {
                attr = e.getValue();
            }
            sourceOnlyAttrs.put(lowerName, attr);
            commonAttrs.put(lowerName, attr);
        }
        for (Map.Entry<String, Attribute> e : targetEntry.attributes.entrySet()) {
            lowerName = StaticUtils.toLowerCase(e.getKey());
            if (compareAttrs != null && !compareAttrs.contains(Attribute.getBaseName(lowerName)) || sourceOnlyAttrs.remove(lowerName) != null) continue;
            if (byteForByte) {
                Attribute a = e.getValue();
                attr = new Attribute(a.getName(), (MatchingRule)OctetStringMatchingRule.getInstance(), a.getRawValues());
            } else {
                attr = e.getValue();
            }
            targetOnlyAttrs.put(lowerName, attr);
        }
        for (String lowerName2 : sourceOnlyAttrs.keySet()) {
            commonAttrs.remove(lowerName2);
        }
        Object var10_16 = null;
        RDN targetRDN = null;
        if (ignoreRDN) {
            try {
                RDN rDN = sourceEntry.getRDN();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            try {
                targetRDN = targetEntry.getRDN();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        ArrayList<Modification> mods = new ArrayList<Modification>(10);
        for (Attribute a : sourceOnlyAttrs.values()) {
            if (reversible) {
                values = a.getRawValues();
                if (var10_18 != null && var10_18.hasAttribute(a.getName())) {
                    newValues = new ArrayList<ASN1OctetString>(values.length);
                    for (ASN1OctetString aSN1OctetString : values) {
                        if (var10_18.hasAttributeValue(a.getName(), aSN1OctetString.getValue())) continue;
                        newValues.add(aSN1OctetString);
                    }
                    if (newValues.isEmpty()) continue;
                    values = new ASN1OctetString[newValues.size()];
                    newValues.toArray(values);
                }
                mods.add(new Modification(ModificationType.DELETE, a.getName(), values));
                continue;
            }
            mods.add(new Modification(ModificationType.REPLACE, a.getName()));
        }
        for (Attribute a : targetOnlyAttrs.values()) {
            values = a.getRawValues();
            if (targetRDN != null && targetRDN.hasAttribute(a.getName())) {
                newValues = new ArrayList(values.length);
                for (ASN1OctetString aSN1OctetString : values) {
                    if (targetRDN.hasAttributeValue(a.getName(), aSN1OctetString.getValue())) continue;
                    newValues.add(aSN1OctetString);
                }
                if (newValues.isEmpty()) continue;
                values = new ASN1OctetString[newValues.size()];
                newValues.toArray(values);
            }
            if (reversible) {
                mods.add(new Modification(ModificationType.ADD, a.getName(), values));
                continue;
            }
            mods.add(new Modification(ModificationType.REPLACE, a.getName(), values));
        }
        for (Attribute sourceAttr : commonAttrs.values()) {
            Attribute targetAttr = targetEntry.getAttribute(sourceAttr.getName());
            if (byteForByte && targetAttr != null) {
                targetAttr = new Attribute(targetAttr.getName(), (MatchingRule)OctetStringMatchingRule.getInstance(), targetAttr.getRawValues());
            }
            if (sourceAttr.equals(targetAttr)) continue;
            if (reversible || targetRDN != null && targetRDN.hasAttribute(targetAttr.getName())) {
                ArrayList addValues;
                void var20_39;
                ASN1OctetString[] sourceValueArray = sourceAttr.getRawValues();
                LinkedHashMap<ASN1OctetString, ASN1OctetString> sourceValues = new LinkedHashMap<ASN1OctetString, ASN1OctetString>(StaticUtils.computeMapCapacity(sourceValueArray.length));
                ASN1OctetString[] aSN1OctetStringArray = sourceValueArray;
                int n = aSN1OctetStringArray.length;
                boolean bl = false;
                while (var20_39 < n) {
                    ASN1OctetString s = aSN1OctetStringArray[var20_39];
                    try {
                        sourceValues.put(sourceAttr.getMatchingRule().normalize(s), s);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        sourceValues.put(s, s);
                    }
                    ++var20_39;
                }
                ASN1OctetString[] targetValueArray = targetAttr.getRawValues();
                LinkedHashMap<ASN1OctetString, ASN1OctetString> targetValues = new LinkedHashMap<ASN1OctetString, ASN1OctetString>(StaticUtils.computeMapCapacity(targetValueArray.length));
                for (ASN1OctetString s : targetValueArray) {
                    try {
                        targetValues.put(sourceAttr.getMatchingRule().normalize(s), s);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        targetValues.put(s, s);
                    }
                }
                Iterator iterator = sourceValues.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry e = iterator.next();
                    if (targetValues.remove(e.getKey()) != null) {
                        iterator.remove();
                        continue;
                    }
                    if (var10_18 == null || !var10_18.hasAttributeValue(sourceAttr.getName(), ((ASN1OctetString)e.getValue()).getValue())) continue;
                    iterator.remove();
                }
                Iterator targetIterator = targetValues.entrySet().iterator();
                while (targetIterator.hasNext()) {
                    Map.Entry e = targetIterator.next();
                    if (targetRDN == null || !targetRDN.hasAttributeValue(targetAttr.getName(), ((ASN1OctetString)e.getValue()).getValue())) continue;
                    targetIterator.remove();
                }
                ArrayList delValues = new ArrayList(sourceValues.values());
                if (!delValues.isEmpty()) {
                    ASN1OctetString[] delArray = new ASN1OctetString[delValues.size()];
                    mods.add(new Modification(ModificationType.DELETE, sourceAttr.getName(), delValues.toArray(delArray)));
                }
                if ((addValues = new ArrayList(targetValues.values())).isEmpty()) continue;
                ASN1OctetString[] addArray = new ASN1OctetString[addValues.size()];
                mods.add(new Modification(ModificationType.ADD, targetAttr.getName(), addValues.toArray(addArray)));
                continue;
            }
            mods.add(new Modification(ModificationType.REPLACE, targetAttr.getName(), targetAttr.getRawValues()));
        }
        return mods;
    }

    @NotNull
    public static Entry mergeEntries(Entry ... entries) {
        Validator.ensureNotNull(entries);
        Validator.ensureTrue(entries.length > 0);
        Entry newEntry = entries[0].duplicate();
        for (int i = 1; i < entries.length; ++i) {
            for (Attribute a : entries[i].attributes.values()) {
                newEntry.addAttribute(a);
            }
        }
        return newEntry;
    }

    @NotNull
    public static Entry intersectEntries(Entry ... entries) {
        Validator.ensureNotNull(entries);
        Validator.ensureTrue(entries.length > 0);
        Entry newEntry = entries[0].duplicate();
        for (Attribute a : entries[0].attributes.values()) {
            String name = a.getName();
            block1: for (byte[] v : a.getValueByteArrays()) {
                for (int i = 1; i < entries.length; ++i) {
                    if (entries[i].hasAttributeValue(name, v)) continue;
                    newEntry.removeAttributeValue(name, v);
                    continue block1;
                }
            }
        }
        return newEntry;
    }

    @NotNull
    public static Entry applyModifications(@NotNull Entry entry, boolean lenient, Modification ... modifications) throws LDAPException {
        Validator.ensureNotNull(entry, modifications);
        Validator.ensureFalse(modifications.length == 0);
        return Entry.applyModifications(entry, lenient, Arrays.asList(modifications));
    }

    @NotNull
    public static Entry applyModifications(@NotNull Entry entry, boolean lenient, @NotNull List<Modification> modifications) throws LDAPException {
        Validator.ensureNotNull(entry, modifications);
        Validator.ensureFalse(modifications.isEmpty());
        Entry e = entry.duplicate();
        ArrayList<String> errors = new ArrayList<String>(modifications.size());
        ResultCode resultCode = null;
        RDN rdn = null;
        try {
            rdn = entry.getRDN();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
        }
        block12: for (Modification m : modifications) {
            String name = m.getAttributeName();
            byte[][] values = m.getValueByteArrays();
            switch (m.getModificationType().intValue()) {
                case 0: {
                    if (lenient) {
                        e.addAttribute(m.getAttribute());
                        break;
                    }
                    if (values.length == 0) {
                        errors.add(LDAPMessages.ERR_ENTRY_APPLY_MODS_ADD_NO_VALUES.get(name));
                    }
                    for (int i = 0; i < values.length; ++i) {
                        if (e.addAttribute(name, values[i])) continue;
                        if (resultCode == null) {
                            resultCode = ResultCode.ATTRIBUTE_OR_VALUE_EXISTS;
                        }
                        errors.add(LDAPMessages.ERR_ENTRY_APPLY_MODS_ADD_EXISTING.get(m.getValues()[i], name));
                    }
                    continue block12;
                }
                case 1: {
                    if (values.length == 0) {
                        boolean removed = e.removeAttribute(name);
                        if (lenient || removed) continue block12;
                        if (resultCode == null) {
                            resultCode = ResultCode.NO_SUCH_ATTRIBUTE;
                        }
                        errors.add(LDAPMessages.ERR_ENTRY_APPLY_MODS_DELETE_NONEXISTENT_ATTR.get(name));
                        break;
                    }
                    for (int i = 0; i < values.length; ++i) {
                        boolean removed = e.removeAttributeValue(name, values[i]);
                        if (lenient || removed) continue;
                        if (resultCode == null) {
                            resultCode = ResultCode.NO_SUCH_ATTRIBUTE;
                        }
                        errors.add(LDAPMessages.ERR_ENTRY_APPLY_MODS_DELETE_NONEXISTENT_VALUE.get(m.getValues()[i], name));
                    }
                    continue block12;
                }
                case 2: {
                    if (values.length == 0) {
                        e.removeAttribute(name);
                        break;
                    }
                    e.setAttribute(m.getAttribute());
                    break;
                }
                case 3: {
                    BigInteger incrementValue;
                    BigInteger currentValue;
                    Attribute a = e.getAttribute(name);
                    if (a == null || !a.hasValue()) {
                        errors.add(LDAPMessages.ERR_ENTRY_APPLY_MODS_INCREMENT_NO_SUCH_ATTR.get(name));
                        continue block12;
                    }
                    if (a.size() > 1) {
                        errors.add(LDAPMessages.ERR_ENTRY_APPLY_MODS_INCREMENT_NOT_SINGLE_VALUED.get(name));
                        continue block12;
                    }
                    if (rdn != null && rdn.hasAttribute(name)) {
                        String msg = LDAPMessages.ERR_ENTRY_APPLY_MODS_TARGETS_RDN.get(entry.getDN());
                        if (!errors.contains(msg)) {
                            errors.add(msg);
                        }
                        if (resultCode != null) continue block12;
                        resultCode = ResultCode.NOT_ALLOWED_ON_RDN;
                        continue block12;
                    }
                    try {
                        currentValue = new BigInteger(a.getValue());
                    }
                    catch (NumberFormatException nfe) {
                        Debug.debugException(nfe);
                        errors.add(LDAPMessages.ERR_ENTRY_APPLY_MODS_INCREMENT_ENTRY_VALUE_NOT_INTEGER.get(name, a.getValue()));
                        continue block12;
                    }
                    if (values.length == 0) {
                        errors.add(LDAPMessages.ERR_ENTRY_APPLY_MODS_INCREMENT_NO_MOD_VALUES.get(name));
                        continue block12;
                    }
                    if (values.length > 1) {
                        errors.add(LDAPMessages.ERR_ENTRY_APPLY_MODS_INCREMENT_MULTIPLE_MOD_VALUES.get(name));
                        continue block12;
                    }
                    String incrementValueStr = m.getValues()[0];
                    try {
                        incrementValue = new BigInteger(incrementValueStr);
                    }
                    catch (NumberFormatException nfe) {
                        Debug.debugException(nfe);
                        errors.add(LDAPMessages.ERR_ENTRY_APPLY_MODS_INCREMENT_MOD_VALUE_NOT_INTEGER.get(name, incrementValueStr));
                        continue block12;
                    }
                    BigInteger newValue = currentValue.add(incrementValue);
                    e.setAttribute(name, newValue.toString());
                    break;
                }
                default: {
                    errors.add(LDAPMessages.ERR_ENTRY_APPLY_MODS_UNKNOWN_TYPE.get(String.valueOf(m.getModificationType())));
                }
            }
        }
        if (rdn != null) {
            String[] rdnAttrs = rdn.getAttributeNames();
            byte[][] rdnValues = rdn.getByteArrayAttributeValues();
            for (int i = 0; i < rdnAttrs.length; ++i) {
                if (e.hasAttributeValue(rdnAttrs[i], rdnValues[i]) || !entry.hasAttributeValue(rdnAttrs[i], rdnValues[i])) continue;
                errors.add(LDAPMessages.ERR_ENTRY_APPLY_MODS_TARGETS_RDN.get(entry.getDN()));
                if (resultCode != null) break;
                resultCode = ResultCode.NOT_ALLOWED_ON_RDN;
                break;
            }
        }
        if (errors.isEmpty()) {
            return e;
        }
        if (resultCode == null) {
            resultCode = ResultCode.CONSTRAINT_VIOLATION;
        }
        throw new LDAPException(resultCode, LDAPMessages.ERR_ENTRY_APPLY_MODS_FAILURE.get(e.getDN(), StaticUtils.concatenateStrings(errors)));
    }

    @NotNull
    public static Entry applyModifyDN(@NotNull Entry entry, @NotNull String newRDN, boolean deleteOldRDN) throws LDAPException {
        return Entry.applyModifyDN(entry, newRDN, deleteOldRDN, null);
    }

    @NotNull
    public static Entry applyModifyDN(@NotNull Entry entry, @NotNull String newRDN, boolean deleteOldRDN, @Nullable String newSuperiorDN) throws LDAPException {
        int i;
        Validator.ensureNotNull(entry);
        Validator.ensureNotNull(newRDN);
        DN parsedOldDN = entry.getParsedDN();
        RDN parsedOldRDN = parsedOldDN.getRDN();
        DN parsedOldSuperiorDN = parsedOldDN.getParent();
        RDN parsedNewRDN = new RDN(newRDN);
        DN parsedNewSuperiorDN = newSuperiorDN == null ? parsedOldSuperiorDN : new DN(newSuperiorDN);
        Entry newEntry = entry.duplicate();
        if (parsedNewSuperiorDN == null) {
            newEntry.setDN(new DN(parsedNewRDN));
        } else {
            newEntry.setDN(new DN(parsedNewRDN, parsedNewSuperiorDN));
        }
        if (deleteOldRDN && parsedOldRDN != null) {
            String[] oldNames = parsedOldRDN.getAttributeNames();
            byte[][] oldValues = parsedOldRDN.getByteArrayAttributeValues();
            for (i = 0; i < oldNames.length; ++i) {
                if (parsedNewRDN.hasAttributeValue(oldNames[i], oldValues[i])) continue;
                newEntry.removeAttributeValue(oldNames[i], oldValues[i]);
            }
        }
        String[] newNames = parsedNewRDN.getAttributeNames();
        byte[][] newValues = parsedNewRDN.getByteArrayAttributeValues();
        for (i = 0; i < newNames.length; ++i) {
            if (parsedOldRDN != null && parsedOldRDN.hasAttributeValue(newNames[i], newValues[i])) continue;
            newEntry.addAttribute(newNames[i], newValues[i]);
        }
        return newEntry;
    }

    public int hashCode() {
        int hashCode = 0;
        try {
            hashCode += this.getParsedDN().hashCode();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            hashCode += this.dn.hashCode();
        }
        for (Attribute a : this.attributes.values()) {
            hashCode += a.hashCode();
        }
        return hashCode;
    }

    public boolean equals(@Nullable Object o) {
        Entry e;
        block8: {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            e = (Entry)o;
            try {
                DN thisDN = this.getParsedDN();
                DN thatDN = e.getParsedDN();
                if (!thisDN.equals(thatDN)) {
                    return false;
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                if (this.dn.equals(e.dn)) break block8;
                return false;
            }
        }
        if (this.attributes.size() != e.attributes.size()) {
            return false;
        }
        for (Attribute a : this.attributes.values()) {
            if (e.hasAttribute(a)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Entry duplicate() {
        return new Entry(this.dn, this.schema, this.attributes.values());
    }

    @Override
    @NotNull
    public final String[] toLDIF() {
        return this.toLDIF(0);
    }

    @Override
    @NotNull
    public final String[] toLDIF(int wrapColumn) {
        List<String> ldifLines = new ArrayList<String>(2 * this.attributes.size());
        Entry.encodeNameAndValue("dn", new ASN1OctetString(this.dn), ldifLines);
        for (Attribute a : this.attributes.values()) {
            String name = a.getName();
            if (a.hasValue()) {
                for (ASN1OctetString value : a.getRawValues()) {
                    Entry.encodeNameAndValue(name, value, ldifLines);
                }
                continue;
            }
            Entry.encodeNameAndValue(name, EMPTY_OCTET_STRING, ldifLines);
        }
        if (wrapColumn > 2) {
            ldifLines = LDIFWriter.wrapLines(wrapColumn, ldifLines);
        }
        String[] lineArray = new String[ldifLines.size()];
        ldifLines.toArray(lineArray);
        return lineArray;
    }

    private static void encodeNameAndValue(@NotNull String name, @NotNull ASN1OctetString value, @NotNull List<String> lines) {
        String line = LDIFWriter.encodeNameAndValue(name, value);
        if (LDIFWriter.commentAboutBase64EncodedValues() && line.startsWith(name + "::")) {
            StringTokenizer tokenizer = new StringTokenizer(line, "\r\n");
            while (tokenizer.hasMoreTokens()) {
                lines.add(tokenizer.nextToken());
            }
        } else {
            lines.add(line);
        }
    }

    @Override
    public final void toLDIF(@NotNull ByteStringBuffer buffer) {
        this.toLDIF(buffer, 0);
    }

    @Override
    public final void toLDIF(@NotNull ByteStringBuffer buffer, int wrapColumn) {
        LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.dn), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL_BYTES);
        for (Attribute a : this.attributes.values()) {
            String name = a.getName();
            if (a.hasValue()) {
                for (ASN1OctetString value : a.getRawValues()) {
                    LDIFWriter.encodeNameAndValue(name, value, buffer, wrapColumn);
                    buffer.append(StaticUtils.EOL_BYTES);
                }
                continue;
            }
            LDIFWriter.encodeNameAndValue(name, EMPTY_OCTET_STRING, buffer, wrapColumn);
            buffer.append(StaticUtils.EOL_BYTES);
        }
    }

    @Override
    @NotNull
    public final String toLDIFString() {
        StringBuilder buffer = new StringBuilder();
        this.toLDIFString(buffer, 0);
        return buffer.toString();
    }

    @Override
    @NotNull
    public final String toLDIFString(int wrapColumn) {
        StringBuilder buffer = new StringBuilder();
        this.toLDIFString(buffer, wrapColumn);
        return buffer.toString();
    }

    @Override
    public final void toLDIFString(@NotNull StringBuilder buffer) {
        this.toLDIFString(buffer, 0);
    }

    @Override
    public final void toLDIFString(@NotNull StringBuilder buffer, int wrapColumn) {
        LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.dn), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL);
        for (Attribute a : this.attributes.values()) {
            String name = a.getName();
            if (a.hasValue()) {
                for (ASN1OctetString value : a.getRawValues()) {
                    LDIFWriter.encodeNameAndValue(name, value, buffer, wrapColumn);
                    buffer.append(StaticUtils.EOL);
                }
                continue;
            }
            LDIFWriter.encodeNameAndValue(name, EMPTY_OCTET_STRING, buffer, wrapColumn);
            buffer.append(StaticUtils.EOL);
        }
    }

    @Override
    @NotNull
    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("Entry(dn='");
        buffer.append(this.dn);
        buffer.append("', attributes={");
        Iterator<Attribute> iterator = this.attributes.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().toString(buffer);
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("})");
    }
}

