/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.core.search.AggregationProfile;
import org.opensearch.client.opensearch.core.search.FetchProfile;
import org.opensearch.client.opensearch.core.search.SearchProfile;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ShardProfile
implements PlainJsonSerializable {
    private final List<AggregationProfile> aggregations;
    private final String id;
    private final List<SearchProfile> searches;
    @Nullable
    private final FetchProfile fetch;
    public static final JsonpDeserializer<ShardProfile> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardProfile::setupShardProfileDeserializer);

    private ShardProfile(Builder builder) {
        this.aggregations = ApiTypeHelper.unmodifiableRequired(builder.aggregations, (Object)this, "aggregations");
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.searches = ApiTypeHelper.unmodifiableRequired(builder.searches, (Object)this, "searches");
        this.fetch = builder.fetch;
    }

    public static ShardProfile of(Function<Builder, ObjectBuilder<ShardProfile>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<AggregationProfile> aggregations() {
        return this.aggregations;
    }

    public final String id() {
        return this.id;
    }

    public final List<SearchProfile> searches() {
        return this.searches;
    }

    @Nullable
    public final FetchProfile fetch() {
        return this.fetch;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.aggregations)) {
            generator.writeKey("aggregations");
            generator.writeStartArray();
            for (AggregationProfile aggregationProfile : this.aggregations) {
                aggregationProfile.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("id");
        generator.write(this.id);
        if (ApiTypeHelper.isDefined(this.searches)) {
            generator.writeKey("searches");
            generator.writeStartArray();
            for (SearchProfile searchProfile : this.searches) {
                searchProfile.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.fetch != null) {
            generator.writeKey("fetch");
            this.fetch.serialize(generator, mapper);
        }
    }

    protected static void setupShardProfileDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aggregations, JsonpDeserializer.arrayDeserializer(AggregationProfile._DESERIALIZER), "aggregations");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::searches, JsonpDeserializer.arrayDeserializer(SearchProfile._DESERIALIZER), "searches");
        op.add(Builder::fetch, FetchProfile._DESERIALIZER, "fetch");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ShardProfile> {
        private List<AggregationProfile> aggregations;
        private String id;
        private List<SearchProfile> searches;
        @Nullable
        private FetchProfile fetch;

        public final Builder aggregations(List<AggregationProfile> list) {
            this.aggregations = Builder._listAddAll(this.aggregations, list);
            return this;
        }

        public final Builder aggregations(AggregationProfile value, AggregationProfile ... values) {
            this.aggregations = Builder._listAdd(this.aggregations, value, values);
            return this;
        }

        public final Builder aggregations(Function<AggregationProfile.Builder, ObjectBuilder<AggregationProfile>> fn) {
            return this.aggregations(fn.apply(new AggregationProfile.Builder()).build(), new AggregationProfile[0]);
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder searches(List<SearchProfile> list) {
            this.searches = Builder._listAddAll(this.searches, list);
            return this;
        }

        public final Builder searches(SearchProfile value, SearchProfile ... values) {
            this.searches = Builder._listAdd(this.searches, value, values);
            return this;
        }

        public final Builder searches(Function<SearchProfile.Builder, ObjectBuilder<SearchProfile>> fn) {
            return this.searches(fn.apply(new SearchProfile.Builder()).build(), new SearchProfile[0]);
        }

        public final Builder fetch(@Nullable FetchProfile value) {
            this.fetch = value;
            return this;
        }

        public final Builder fetch(Function<FetchProfile.Builder, ObjectBuilder<FetchProfile>> fn) {
            return this.fetch(fn.apply(new FetchProfile.Builder()).build());
        }

        @Override
        public ShardProfile build() {
            this._checkSingleUse();
            return new ShardProfile(this);
        }
    }
}

