/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.ingest.Pipeline;
import org.opensearch.client.opensearch.ingest.SimulateResponse;
import org.opensearch.client.opensearch.ingest.simulate.Document;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class SimulateRequest
extends RequestBase
implements PlainJsonSerializable {
    private final List<Document> docs;
    @Nullable
    private final String id;
    @Nullable
    private final Pipeline pipeline;
    @Nullable
    private final Boolean verbose;
    public static final JsonpDeserializer<SimulateRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SimulateRequest::setupSimulateRequestDeserializer);
    public static final Endpoint<SimulateRequest, SimulateResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<SimulateRequest, SimulateResponse>(request -> "POST", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (request.id() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ingest");
            buf.append("/pipeline");
            buf.append("/_simulate");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ingest");
            buf.append("/pipeline");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            buf.append("/_simulate");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.verbose != null) {
            params.put("verbose", String.valueOf(request.verbose));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, SimulateResponse._DESERIALIZER);

    private SimulateRequest(Builder builder) {
        this.docs = ApiTypeHelper.unmodifiable(builder.docs);
        this.id = builder.id;
        this.pipeline = builder.pipeline;
        this.verbose = builder.verbose;
    }

    public static SimulateRequest of(Function<Builder, ObjectBuilder<SimulateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<Document> docs() {
        return this.docs;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nullable
    public final Pipeline pipeline() {
        return this.pipeline;
    }

    @Nullable
    public final Boolean verbose() {
        return this.verbose;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.docs)) {
            generator.writeKey("docs");
            generator.writeStartArray();
            for (Document item0 : this.docs) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.pipeline != null) {
            generator.writeKey("pipeline");
            this.pipeline.serialize(generator, mapper);
        }
    }

    protected static void setupSimulateRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::docs, JsonpDeserializer.arrayDeserializer(Document._DESERIALIZER), "docs");
        op.add(Builder::pipeline, Pipeline._DESERIALIZER, "pipeline");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<SimulateRequest> {
        @Nullable
        private List<Document> docs;
        @Nullable
        private String id;
        @Nullable
        private Pipeline pipeline;
        @Nullable
        private Boolean verbose;

        public final Builder docs(List<Document> list) {
            this.docs = Builder._listAddAll(this.docs, list);
            return this;
        }

        public final Builder docs(Document value, Document ... values) {
            this.docs = Builder._listAdd(this.docs, value, values);
            return this;
        }

        public final Builder docs(Function<Document.Builder, ObjectBuilder<Document>> fn) {
            return this.docs(fn.apply(new Document.Builder()).build(), new Document[0]);
        }

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder pipeline(@Nullable Pipeline value) {
            this.pipeline = value;
            return this;
        }

        public final Builder pipeline(Function<Pipeline.Builder, ObjectBuilder<Pipeline>> fn) {
            return this.pipeline(fn.apply(new Pipeline.Builder()).build());
        }

        public final Builder verbose(@Nullable Boolean value) {
            this.verbose = value;
            return this;
        }

        @Override
        public SimulateRequest build() {
            this._checkSingleUse();
            return new SimulateRequest(this);
        }
    }
}

