/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.tasks;

import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.tasks.CancelResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

public class CancelRequest
extends RequestBase {
    private final List<String> actions;
    private final List<String> nodes;
    @Nullable
    private final String parentTaskId;
    @Nullable
    private final String taskId;
    @Nullable
    private final Boolean waitForCompletion;
    public static final Endpoint<CancelRequest, CancelResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CancelRequest, CancelResponse>(request -> "POST", request -> {
        boolean _taskId = true;
        boolean propsSet = false;
        if (request.taskId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_tasks");
            buf.append("/_cancel");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_tasks");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskId, buf);
            buf.append("/_cancel");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (ApiTypeHelper.isDefined(request.nodes)) {
            params.put("nodes", request.nodes.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.parentTaskId != null) {
            params.put("parent_task_id", request.parentTaskId);
        }
        if (ApiTypeHelper.isDefined(request.actions)) {
            params.put("actions", request.actions.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(request.waitForCompletion));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, CancelResponse._DESERIALIZER);

    private CancelRequest(Builder builder) {
        this.actions = ApiTypeHelper.unmodifiable(builder.actions);
        this.nodes = ApiTypeHelper.unmodifiable(builder.nodes);
        this.parentTaskId = builder.parentTaskId;
        this.taskId = builder.taskId;
        this.waitForCompletion = builder.waitForCompletion;
    }

    public static CancelRequest of(Function<Builder, ObjectBuilder<CancelRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> actions() {
        return this.actions;
    }

    public final List<String> nodes() {
        return this.nodes;
    }

    @Nullable
    public final String parentTaskId() {
        return this.parentTaskId;
    }

    @Nullable
    public final String taskId() {
        return this.taskId;
    }

    @Nullable
    public final Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<CancelRequest> {
        @Nullable
        private List<String> actions;
        @Nullable
        private List<String> nodes;
        @Nullable
        private String parentTaskId;
        @Nullable
        private String taskId;
        @Nullable
        private Boolean waitForCompletion;

        public final Builder actions(List<String> list) {
            this.actions = Builder._listAddAll(this.actions, list);
            return this;
        }

        public final Builder actions(String value, String ... values) {
            this.actions = Builder._listAdd(this.actions, value, values);
            return this;
        }

        public final Builder nodes(List<String> list) {
            this.nodes = Builder._listAddAll(this.nodes, list);
            return this;
        }

        public final Builder nodes(String value, String ... values) {
            this.nodes = Builder._listAdd(this.nodes, value, values);
            return this;
        }

        public final Builder parentTaskId(@Nullable String value) {
            this.parentTaskId = value;
            return this;
        }

        public final Builder taskId(@Nullable String value) {
            this.taskId = value;
            return this;
        }

        public final Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        @Override
        public CancelRequest build() {
            this._checkSingleUse();
            return new CancelRequest(this);
        }
    }
}

