/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.time;

import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.time.Clock;
import com.datastax.oss.driver.internal.core.time.MonotonicTimestampGenerator;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class AtomicTimestampGenerator
extends MonotonicTimestampGenerator {
    private final AtomicLong lastRef = new AtomicLong(0L);

    public AtomicTimestampGenerator(DriverContext context) {
        super(context);
    }

    @VisibleForTesting
    AtomicTimestampGenerator(Clock clock, InternalDriverContext context) {
        super(clock, context);
    }

    @Override
    public long next() {
        long next;
        long last;
        while (!this.lastRef.compareAndSet(last = this.lastRef.get(), next = this.computeNext(last))) {
        }
        return next;
    }
}

