/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem2.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.apache.jena.mem2.collection.JenaSet;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;

public class IteratorOfJenaSets<E>
extends NiceIterator<E> {
    final Iterator<? extends JenaSet<E>> parentIterator;
    ExtendedIterator<E> currentIterator;

    public IteratorOfJenaSets(Iterator<? extends JenaSet<E>> parentIterator) {
        this.parentIterator = parentIterator;
        this.currentIterator = parentIterator.hasNext() ? parentIterator.next().keyIterator() : NiceIterator.emptyIterator();
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator.hasNext()) {
            return true;
        }
        while (this.parentIterator.hasNext()) {
            this.currentIterator = this.parentIterator.next().keyIterator();
            if (!this.currentIterator.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public E next() {
        if (this.hasNext()) {
            return (E)this.currentIterator.next();
        }
        throw new NoSuchElementException();
    }

    public void forEachRemaining(Consumer<? super E> action) {
        this.currentIterator.forEachRemaining(action);
        this.parentIterator.forEachRemaining(i -> i.keyIterator().forEachRemaining(action));
    }
}

