/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.commons.fileupload2.core.AbstractFileUpload;
import org.apache.commons.fileupload2.core.FileItemHeaders;
import org.apache.commons.fileupload2.core.FileItemInput;
import org.apache.commons.fileupload2.core.FileItemInputImpl;
import org.apache.commons.fileupload2.core.FileItemInputIterator;
import org.apache.commons.fileupload2.core.FileUploadContentTypeException;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.core.FileUploadSizeException;
import org.apache.commons.fileupload2.core.MultipartInput;
import org.apache.commons.fileupload2.core.RequestContext;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;

class FileItemInputIteratorImpl
implements FileItemInputIterator {
    private final AbstractFileUpload<?, ?, ?> fileUpload;
    private final RequestContext requestContext;
    private long sizeMax;
    private long fileSizeMax;
    private MultipartInput multiPartInput;
    private MultipartInput.ProgressNotifier progressNotifier;
    private byte[] multiPartBoundary;
    private FileItemInputImpl currentItem;
    private String currentFieldName;
    private boolean skipPreamble;
    private boolean itemValid;
    private boolean eof;
    private final boolean multipartRelated;

    FileItemInputIteratorImpl(AbstractFileUpload<?, ?, ?> fileUploadBase, RequestContext requestContext) throws FileUploadException, IOException {
        this.fileUpload = fileUploadBase;
        this.sizeMax = fileUploadBase.getSizeMax();
        this.fileSizeMax = fileUploadBase.getFileSizeMax();
        this.requestContext = Objects.requireNonNull(requestContext, "requestContext");
        this.multipartRelated = this.requestContext.isMultipartRelated();
        this.skipPreamble = true;
        this.findNextItem();
    }

    private boolean findNextItem() throws FileUploadException, IOException {
        if (this.eof) {
            return false;
        }
        if (this.currentItem != null) {
            this.currentItem.close();
            this.currentItem = null;
        }
        MultipartInput multi = this.getMultiPartInput();
        while (true) {
            boolean nextPart;
            if (!(nextPart = this.skipPreamble ? multi.skipPreamble() : multi.readBoundary())) {
                if (this.currentFieldName == null) {
                    this.eof = true;
                    return false;
                }
                multi.setBoundary(this.multiPartBoundary);
                this.currentFieldName = null;
                continue;
            }
            FileItemHeaders headers = this.fileUpload.getParsedHeaders(multi.readHeaders());
            if (this.multipartRelated) {
                this.currentFieldName = "";
                this.currentItem = new FileItemInputImpl(this, null, null, headers.getHeader("Content-type"), false, this.getContentLength(headers));
                this.currentItem.setHeaders(headers);
                this.progressNotifier.noteItem();
                this.itemValid = true;
                return true;
            }
            if (this.currentFieldName == null) {
                String fieldName = this.fileUpload.getFieldName(headers);
                if (fieldName != null) {
                    String subContentType = headers.getHeader("Content-type");
                    if (subContentType != null && subContentType.toLowerCase(Locale.ROOT).startsWith("multipart/mixed")) {
                        this.currentFieldName = fieldName;
                        byte[] subBoundary = this.fileUpload.getBoundary(subContentType);
                        multi.setBoundary(subBoundary);
                        this.skipPreamble = true;
                        continue;
                    }
                    String fileName = this.fileUpload.getFileName(headers);
                    this.currentItem = new FileItemInputImpl(this, fileName, fieldName, headers.getHeader("Content-type"), fileName == null, this.getContentLength(headers));
                    this.currentItem.setHeaders(headers);
                    this.progressNotifier.noteItem();
                    this.itemValid = true;
                    return true;
                }
            } else {
                String fileName = this.fileUpload.getFileName(headers);
                if (fileName != null) {
                    this.currentItem = new FileItemInputImpl(this, fileName, this.currentFieldName, headers.getHeader("Content-type"), false, this.getContentLength(headers));
                    this.currentItem.setHeaders(headers);
                    this.progressNotifier.noteItem();
                    this.itemValid = true;
                    return true;
                }
            }
            multi.discardBodyData();
        }
    }

    private long getContentLength(FileItemHeaders headers) {
        try {
            return Long.parseLong(headers.getHeader("Content-length"));
        }
        catch (Exception e2) {
            return -1L;
        }
    }

    @Override
    public long getFileSizeMax() {
        return this.fileSizeMax;
    }

    public MultipartInput getMultiPartInput() throws FileUploadException, IOException {
        if (this.multiPartInput == null) {
            this.init(this.fileUpload, this.requestContext);
        }
        return this.multiPartInput;
    }

    @Override
    public long getSizeMax() {
        return this.sizeMax;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.eof) {
            return false;
        }
        if (this.itemValid) {
            return true;
        }
        return this.findNextItem();
    }

    protected void init(AbstractFileUpload<?, ?, ?> fileUploadBase, RequestContext initContext) throws FileUploadException, IOException {
        InputStream inputStream;
        long requestSize;
        String contentType = this.requestContext.getContentType();
        if (null == contentType || !contentType.toLowerCase(Locale.ROOT).startsWith("multipart/")) {
            throw new FileUploadContentTypeException(String.format("the request doesn't contain a %s or %s stream, content type header is %s", "multipart/form-data", "multipart/mixed", contentType), contentType);
        }
        long contentLengthInt = this.requestContext.getContentLength();
        long l = requestSize = RequestContext.class.isAssignableFrom(this.requestContext.getClass()) ? this.requestContext.getContentLength() : contentLengthInt;
        if (this.sizeMax >= 0L) {
            if (requestSize != -1L && requestSize > this.sizeMax) {
                throw new FileUploadSizeException(String.format("the request was rejected because its size (%s) exceeds the configured maximum (%s)", requestSize, this.sizeMax), this.sizeMax, requestSize);
            }
            inputStream = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream(this.requestContext.getInputStream())).setMaxCount(this.sizeMax)).setOnMaxCount((max2, count) -> {
                throw new FileUploadSizeException(String.format("The request was rejected because its size (%s) exceeds the configured maximum (%s)", count, max2), (long)max2, (long)count);
            })).get();
        } else {
            inputStream = this.requestContext.getInputStream();
        }
        Charset charset = Charsets.toCharset(fileUploadBase.getHeaderCharset(), this.requestContext.getCharset());
        this.multiPartBoundary = fileUploadBase.getBoundary(contentType);
        if (this.multiPartBoundary == null) {
            IOUtils.closeQuietly(inputStream);
            throw new FileUploadException("the request was rejected because no multipart boundary was found");
        }
        this.progressNotifier = new MultipartInput.ProgressNotifier(fileUploadBase.getProgressListener(), requestSize);
        try {
            this.multiPartInput = ((MultipartInput.Builder)MultipartInput.builder().setInputStream(inputStream)).setBoundary(this.multiPartBoundary).setProgressNotifier(this.progressNotifier).get();
        }
        catch (IllegalArgumentException e2) {
            IOUtils.closeQuietly(inputStream);
            throw new FileUploadContentTypeException(String.format("The boundary specified in the %s header is too long", "Content-type"), e2);
        }
        this.multiPartInput.setHeaderCharset(charset);
    }

    @Override
    public FileItemInput next() throws IOException {
        if (this.eof || !this.itemValid && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.itemValid = false;
        return this.currentItem;
    }

    @Override
    public void setFileSizeMax(long fileSizeMax) {
        this.fileSizeMax = fileSizeMax;
    }

    @Override
    public void setSizeMax(long sizeMax) {
        this.sizeMax = sizeMax;
    }

    @Override
    public Iterator<FileItemInput> unwrap() {
        return (Iterator)((Object)this);
    }
}

