/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ext.xerces.impl.dv.xs;

import org.apache.jena.ext.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.jena.ext.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.jena.ext.xerces.impl.dv.xs.SchemaDateTimeException;

public class DateTimeDV
extends AbstractDateTimeDV {
    @Override
    public Object getActualValue(String content) throws InvalidDatatypeValueException {
        try {
            return this.parse(content);
        }
        catch (Exception ex) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "dateTime"});
        }
    }

    protected AbstractDateTimeDV.DateTimeData parse(String str2) throws SchemaDateTimeException {
        AbstractDateTimeDV.DateTimeData date2 = new AbstractDateTimeDV.DateTimeData(str2, this);
        int len = str2.length();
        int end = this.indexOf(str2, 0, len, 'T');
        int dateEnd = this.getDate(str2, 0, end, date2);
        this.getTime(str2, end + 1, len, date2);
        if (dateEnd != end) {
            throw new RuntimeException(str2 + " is an invalid dateTime dataype value. Invalid character(s) seprating date and time values.");
        }
        this.validateDateTime(date2);
        this.saveUnnormalized(date2);
        if (date2.utc != 0 && date2.utc != 90) {
            this.normalize(date2);
        }
        return date2;
    }
}

