/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.mgt;

import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.Authenticator;
import org.apache.shiro.authc.pam.ModularRealmAuthenticator;
import org.apache.shiro.lang.util.LifecycleUtils;
import org.apache.shiro.mgt.RealmSecurityManager;

public abstract class AuthenticatingSecurityManager
extends RealmSecurityManager {
    private Authenticator authenticator = new ModularRealmAuthenticator();

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) throws IllegalArgumentException {
        if (authenticator == null) {
            String msg = "Authenticator argument cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        this.authenticator = authenticator;
    }

    @Override
    protected void afterRealmsSet() {
        super.afterRealmsSet();
        if (this.authenticator instanceof ModularRealmAuthenticator) {
            ((ModularRealmAuthenticator)this.authenticator).setRealms(this.getRealms());
        }
    }

    @Override
    public AuthenticationInfo authenticate(AuthenticationToken token) throws AuthenticationException {
        return this.authenticator.authenticate(token);
    }

    @Override
    public void destroy() {
        LifecycleUtils.destroy(this.getAuthenticator());
        this.authenticator = null;
        super.destroy();
    }
}

